/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bundles {
    private final Hashtable<String, BundleImpl> bundles = new Hashtable();
    private final HashSet<BundleImpl> zombies = new HashSet();
    private FrameworkContext fwCtx;

    Bundles(FrameworkContext fw) {
        this.fwCtx = fw;
        this.bundles.put(fw.systemBundle.location, fw.systemBundle);
    }

    void clear() {
        this.bundles.clear();
        this.fwCtx = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BundleImpl install(String location, InputStream in, Bundle caller) throws BundleException {
        BundleImpl b;
        this.checkIllegalState();
        Bundles bundles = this;
        synchronized (bundles) {
            b = this.bundles.get(location);
            if (b != null) {
                if ((b = (BundleImpl)b.fwCtx.bundleHooks.filterBundle(b.bundleContext, b)) == null) {
                    throw new BundleException("Rejected by a bundle hook", 12);
                }
                return b;
            }
            b = this.fwCtx.perm.callInstall0(this, location, in, caller);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BundleImpl install0(String location, InputStream in, Object checkContext, Bundle caller) throws BundleException {
        BundleArchive ba = null;
        try {
            InputStream bin;
            if (in == null) {
                String basicAuth;
                URL url = new URL(location);
                URLConnection conn = url.openConnection();
                String auth = this.fwCtx.props.getProperty("http.proxyAuth");
                if (auth != null && !"".equals(auth) && ("http".equals(url.getProtocol()) || "https".equals(url.getProtocol()))) {
                    String base64 = Util.base64Encode(auth);
                    conn.setRequestProperty("Proxy-Authorization", ((Object)new StringBuffer().append("Basic ").append(base64)).toString());
                }
                if ((basicAuth = this.fwCtx.props.getProperty("http.basicAuth")) != null && !"".equals(basicAuth) && ("http".equals(url.getProtocol()) || "https".equals(url.getProtocol()))) {
                    String base64 = Util.base64Encode(basicAuth);
                    conn.setRequestProperty("Authorization", ((Object)new StringBuffer().append("Basic ").append(base64)).toString());
                }
                bin = conn.getInputStream();
            } else {
                bin = in;
            }
            try {
                ba = this.fwCtx.storage.insertBundleJar(location, bin);
            }
            finally {
                bin.close();
            }
            BundleImpl res = new BundleImpl(this.fwCtx, ba, checkContext, caller);
            this.bundles.put(location, res);
            this.fwCtx.listeners.bundleChanged(new BundleEvent(1, res, caller));
            return res;
        }
        catch (Exception e) {
            if (ba != null) {
                ba.purge();
            }
            if (e instanceof SecurityException) {
                throw (SecurityException)e;
            }
            if (e instanceof BundleException) {
                throw (BundleException)e;
            }
            throw new BundleException(((Object)new StringBuffer().append("Failed to install bundle: ").append(e)).toString(), 0, e);
        }
    }

    void remove(String location) {
        this.bundles.remove(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addZombie(BundleImpl b) {
        Hashtable<String, BundleImpl> hashtable = this.bundles;
        synchronized (hashtable) {
            this.zombies.add(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeZombie(BundleImpl b) {
        Hashtable<String, BundleImpl> hashtable = this.bundles;
        synchronized (hashtable) {
            this.zombies.remove(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bundle getBundle(long id) {
        this.checkIllegalState();
        Hashtable<String, BundleImpl> hashtable = this.bundles;
        synchronized (hashtable) {
            Enumeration<BundleImpl> e = this.bundles.elements();
            while (e.hasMoreElements()) {
                BundleImpl b = e.nextElement();
                if (b.id != id) continue;
                return b;
            }
        }
        return null;
    }

    Bundle getBundle(String location) {
        this.checkIllegalState();
        return this.bundles.get(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Bundle> getBundles(String name, Version version) {
        this.checkIllegalState();
        ArrayList<Bundle> res = new ArrayList<Bundle>(this.bundles.size());
        if ("system.bundle".equals(name) && version.equals(this.fwCtx.systemBundle.getVersion())) {
            res.add(this.fwCtx.systemBundle);
        }
        Hashtable<String, BundleImpl> hashtable = this.bundles;
        synchronized (hashtable) {
            Enumeration<BundleImpl> e = this.bundles.elements();
            while (e.hasMoreElements()) {
                BundleImpl b = e.nextElement();
                if (!name.equals(b.getSymbolicName()) || !version.equals(b.getVersion())) continue;
                res.add(b);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<BundleImpl> getBundles() {
        ArrayList<BundleImpl> res = new ArrayList<BundleImpl>(this.bundles.size());
        Hashtable<String, BundleImpl> hashtable = this.bundles;
        synchronized (hashtable) {
            res.addAll(this.bundles.values());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<BundleGeneration> getBundleGenerations(String name) {
        ArrayList<BundleGeneration> res = new ArrayList<BundleGeneration>();
        if ("system.bundle".equals(name)) {
            res.add(this.fwCtx.systemBundle.current());
        }
        Hashtable<String, BundleImpl> hashtable = this.bundles;
        synchronized (hashtable) {
            for (BundleImpl b : this.bundles.values()) {
                if (name != null && !name.equals(b.getSymbolicName())) continue;
                res.add(b.current());
            }
        }
        return res;
    }

    List<BundleGeneration> getBundles(String name, VersionRange range) {
        this.checkIllegalState();
        List<BundleGeneration> res = this.getBundleGenerations(name);
        int i = 0;
        while (i < res.size()) {
            BundleGeneration bg = res.remove(i);
            if (range != null && !range.includes(bg.version)) continue;
            int j = i;
            while (--j >= 0 && bg.version.compareTo(res.get((int)j).version) > 0) {
            }
            res.add(j + 1, bg);
            ++i;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<BundleImpl> getActiveBundles() {
        this.checkIllegalState();
        ArrayList<BundleImpl> slist = new ArrayList<BundleImpl>();
        Hashtable<String, BundleImpl> hashtable = this.bundles;
        synchronized (hashtable) {
            Enumeration<BundleImpl> e = this.bundles.elements();
            while (e.hasMoreElements()) {
                BundleImpl b = e.nextElement();
                int s = b.getState();
                if (s != 32 && s != 8) continue;
                slist.add(b);
            }
        }
        return slist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getRemovalPendingBundles(Collection<Bundle> res) {
        Hashtable<String, BundleImpl> hashtable = this.bundles;
        synchronized (hashtable) {
            for (BundleImpl b : this.bundles.values()) {
                if (!b.hasZombies()) continue;
                res.add(b);
            }
            res.addAll(this.zombies);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getUnattachedBundles(Collection<Bundle> res) {
        Hashtable<String, BundleImpl> hashtable = this.bundles;
        synchronized (hashtable) {
            for (BundleImpl b : this.bundles.values()) {
                BundleGeneration curr;
                if (b.getState() != 2 || !(curr = b.current()).isFragment() || curr.getResolvedHosts().size() <= 0) continue;
                res.add(b);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkExtensionBundleRestart() {
        Hashtable<String, BundleImpl> hashtable = this.bundles;
        synchronized (hashtable) {
            for (BundleImpl b : this.zombies) {
                if (!b.extensionNeedsRestart()) continue;
                return true;
            }
            for (BundleImpl b : this.bundles.values()) {
                if (!b.extensionNeedsRestart()) continue;
                return true;
            }
        }
        return false;
    }

    synchronized void load() {
        BundleArchive[] bas;
        for (BundleArchive ba : bas = this.fwCtx.storage.getAllBundleArchives()) {
            try {
                BundleImpl b = new BundleImpl(this.fwCtx, ba, null, this.fwCtx.systemBundle);
                this.bundles.put(b.location, b);
            }
            catch (Exception e) {
                try {
                    ba.setAutostartSetting(-1);
                    ba.setStartLevel(-2);
                }
                catch (IOException _ioe) {
                    // empty catch block
                }
                System.err.println(((Object)new StringBuffer().append("Error: Failed to load bundle ").append(ba.getBundleId()).append(" (").append(ba.getBundleLocation()).append(")").append(" uninstalled it!")).toString());
                e.printStackTrace();
            }
        }
    }

    Collection<BundleGeneration> getFragmentBundles(BundleGeneration target) {
        HashMap<String, BundleGeneration> res = new HashMap<String, BundleGeneration>();
        Enumeration<BundleImpl> e = this.bundles.elements();
        while (e.hasMoreElements()) {
            String sym;
            BundleGeneration old;
            BundleImpl b = e.nextElement();
            BundleGeneration bg = b.current();
            if (!bg.isFragment() || b.state == 1 || !bg.fragment.isTarget(target) || (old = (BundleGeneration)res.get(sym = bg.symbolicName)) != null && old.symbolicName.equals(sym) && old.version.compareTo(bg.version) > 0) continue;
            res.put(sym, bg);
        }
        return res.values();
    }

    private void checkIllegalState() {
        if (null == this.fwCtx) {
            throw new IllegalStateException("This framework instance is not active.");
        }
    }
}

