/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.jmeter;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.domain.PerformanceResultsSummary;
import com.xebialabs.xltest.domain.SamplingPerformanceResultsSummary;
import com.xebialabs.xltest.importers.AbstractPerformanceSummaryResultsImporter;
import com.xebialabs.xltest.jmeter.JMeterImportFailedException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMeterXmlImporter
extends AbstractPerformanceSummaryResultsImporter {
    private static final Logger LOG = LoggerFactory.getLogger(JMeterXmlImporter.class);
    private final OverthereFile jmeterXmlFile;
    protected static final String EL_TEST_RESULTS = "testResults";
    protected static final String EL_HTTP_SAMPLE = "httpSample";
    protected static final QName ATTR_VERSION = QName.valueOf("version");
    protected static final QName ATTR_S = QName.valueOf("s");
    protected static final QName ATTR_TS = QName.valueOf("ts");
    protected static final QName ATTR_T = QName.valueOf("t");

    public JMeterXmlImporter(OverthereFile jmeterXmlFile) {
        this.jmeterXmlFile = jmeterXmlFile;
    }

    public long getTimestamp() {
        return this.jmeterXmlFile.lastModified();
    }

    public String getImportablePath() {
        return this.jmeterXmlFile.getPath();
    }

    public PerformanceResultsSummary constructPerformanceResultsSummary() throws JMeterImportFailedException {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLEventReader reader = factory.createXMLEventReader(this.jmeterXmlFile.getInputStream(), "UTF-8");
            SamplingPerformanceResultsSummary performanceResultsSummary = new SamplingPerformanceResultsSummary();
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (!e.isStartElement()) continue;
                StartElement element = e.asStartElement();
                if (EL_TEST_RESULTS.equals(element.getName().getLocalPart())) {
                    String version = element.getAttributeByName(ATTR_VERSION).getValue();
                    LOG.info("Importing JMeter XML format {}", (Object)version);
                    continue;
                }
                if (EL_HTTP_SAMPLE.equals(element.getName().getLocalPart())) {
                    String sampleResult = this.getAttribute(element, ATTR_S);
                    long timestamp = Long.parseLong(this.getAttribute(element, ATTR_TS));
                    long elapsed = Long.parseLong(this.getAttribute(element, ATTR_T));
                    performanceResultsSummary.updateWithSample(timestamp, elapsed, sampleResult);
                    continue;
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Ignoring type={} element={}", (Object)e.getEventType(), (Object)e);
            }
            return performanceResultsSummary;
        }
        catch (XMLStreamException e) {
            throw new JMeterImportFailedException(String.format("Could not read JMeter XML data from: '%s'", this.jmeterXmlFile.toString()), e);
        }
    }

    private String getAttribute(StartElement item, QName attributeName) {
        Attribute attr = item.getAttributeByName(attributeName);
        return attr.getValue();
    }

    public String toString() {
        return String.format("JMeterXmlImporter(%s)", this.jmeterXmlFile);
    }
}

