/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.google.common.base.Objects;
import com.google.common.collect.ComparisonChain;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xltest.domain.Qualification;
import java.util.Comparator;

@Metadata(description="Test specification base type.", root=Metadata.ConfigurationItemRoot.CONFIGURATION, virtual=true, versioned=false)
public abstract class BaseTestSpecification
extends BaseConfigurationItem {
    public static final String DEFAULT_FUNCTIONAL_TEST_QUALIFIER = "xlt.DefaultFunctionalTestsQualifier";
    public static final String DEFAULT_PERFORMANCE_TEST_QUALIFIER = "xlt.DefaultPerformanceTestsQualifier";
    public static final String CATEGORY_EXECUTION = "Execution";
    public static final String CATEGORY_PARAMETERS = "Parameters";
    @Property(description="Unique name for the test specification.", label="Name")
    protected String title = "";
    @Property(description="Qualifier used to determine if a run of this test set passed or failed.", required=false)
    private String qualificationType;
    public static final Comparator<BaseTestSpecification> titleComparator = new Comparator<BaseTestSpecification>(){

        @Override
        public int compare(BaseTestSpecification o1, BaseTestSpecification o2) {
            return ComparisonChain.start().compare((Comparable)((Object)o1.getTitle()), (Comparable)((Object)o2.getTitle())).compare((Comparable)((Object)o1.getId()), (Comparable)((Object)o2.getId())).result();
        }
    };

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getQualificationType() {
        return this.qualificationType;
    }

    public void setQualificationType(String qualificationType) {
        this.qualificationType = qualificationType;
    }

    public boolean hasQualificationType() {
        return this.qualificationType != null && !this.qualificationType.isEmpty();
    }

    public Qualification getQualification() {
        if (!this.hasQualificationType()) {
            return null;
        }
        return Qualification.getQualificationFor(this.qualificationType);
    }

    public String getProjectId() {
        return this.id.substring(0, this.id.lastIndexOf(47));
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("title", (Object)this.title).add("qualificationType", (Object)this.qualificationType).toString();
    }
}

