/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xltest.domain.Computable;
import com.xebialabs.xltest.domain.ScriptedConfigurationItem;
import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.repository.TestRunsRepository;
import java.io.FileNotFoundException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.script.ScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Metadata(description="Report base type.", root=Metadata.ConfigurationItemRoot.CONFIGURATION, virtual=true, versioned=false)
public class Report
extends ScriptedConfigurationItem
implements Computable<TestRun, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(Report.class);
    @Property(description="The type of report. One of 'link', 'highchart', 'table', 'html', 'qualification'.")
    private String reportType;
    @Property(description="The name of the file holding the icon for this report.")
    private String iconName;
    @Property(description="The explanation for first time users as shown in the UI.")
    private String userFriendlyDescription;
    @Property(description="Category of test tools for which this report is applicable.", defaultValue="functional")
    private Set<String> applicableCategories = Sets.newHashSet((Object[])new String[]{"functional"});
    @Property(description="User presentable title to identify this report.")
    private String title;
    @Property(description="Some reports belong to test specifications. Others to test-run 'level'.", required=false, defaultValue="true")
    private boolean visibleOnTestSpecificationLevel = true;
    @Autowired
    private transient RepositoryService repository;
    @Autowired
    private transient TestRunsRepository testRunsRepository;
    private Map<String, Object> attributes = new TreeMap<String, Object>();

    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public String getIconName() {
        return this.iconName;
    }

    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    public String getUserFriendlyDescription() {
        return this.userFriendlyDescription;
    }

    public void setUserFriendlyDescription(String userFriendlyDescription) {
        this.userFriendlyDescription = userFriendlyDescription;
    }

    public Set<String> getApplicableCategories() {
        return this.applicableCategories;
    }

    public void setApplicableCategories(Set<String> applicableCategories) {
        this.applicableCategories = applicableCategories;
    }

    public boolean isVisibleOnTestSpecificationLevel() {
        return this.visibleOnTestSpecificationLevel;
    }

    public void setVisibleOnTestSpecificationLevel(boolean visibleOnTestSpecificationLevel) {
        this.visibleOnTestSpecificationLevel = visibleOnTestSpecificationLevel;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public TestRunsRepository getTestRunsRepository() {
        return this.testRunsRepository;
    }

    @Override
    public Object compute(TestRun testRun) {
        LOG.debug("compute reportId={} testRunId={}", (Object)this.getId(), (Object)testRun.getId());
        ScriptContext context = this.newScriptContext();
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            context.setAttribute(entry.getKey(), entry.getValue(), 100);
        }
        context.setAttribute("testRun", testRun, 100);
        context.setAttribute("testRuns", this.testRunsRepository, 100);
        context.setAttribute("repository", this.repository, 100);
        try {
            LOG.debug("Start generating report reportId={} title={}", (Object)this.getId(), (Object)this.getTitle());
            Object result = this.execute(context, this);
            LOG.debug("Done generating report reportId={} title={}", (Object)this.getId(), (Object)this.getTitle());
            return result;
        }
        catch (FileNotFoundException fnfe) {
            LOG.error("Error generating report reportId={} file not found: {}", (Object)this.getId(), (Object)fnfe.getMessage());
            throw new RuntimeException("Could not perform report transformation.", fnfe);
        }
        catch (Exception e) {
            LOG.error("Error generating report reportId={} error: {}", (Object)this.getId(), (Object)e.getMessage());
            throw new RuntimeException("Could not perform report transformation.", e);
        }
    }

    public void addAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public <T> T getAttribute(String key) {
        return (T)this.attributes.get(key);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    protected RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public int compareTo(BaseConfigurationItem o) {
        String otherReportType;
        Report other;
        String otherTitle;
        if (!(o instanceof Report)) {
            return super.compareTo(o);
        }
        String thisTitle = this.title != null ? this.title : "";
        int comp = thisTitle.compareTo(otherTitle = (other = (Report)o).getTitle() != null ? other.getTitle() : "");
        if (comp != 0) {
            return comp;
        }
        String thisReportType = this.reportType != null ? this.reportType : "";
        comp = thisReportType.compareTo(otherReportType = other.getReportType() != null ? other.getReportType() : "");
        if (comp != 0) {
            return comp;
        }
        return super.compareTo(o);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("reportType", (Object)this.reportType).add("iconName", (Object)this.iconName).add("userFriendlyDescription", (Object)this.userFriendlyDescription).add("applicableCategories", this.applicableCategories).add("title", (Object)this.title).add("visibleOnTestSpecificationLevel", this.visibleOnTestSpecificationLevel).add("attributes", this.attributes).toString();
    }
}

