/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.serialize;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltest.serialize.CiDepth;
import com.xebialabs.xltype.serialization.CiWriter;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.json.CiJsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
@Provider
@Produces(value={"application/json"})
public class CiListJsonMessageBodyWriter
implements MessageBodyWriter<Collection<ConfigurationItem>> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            type = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
        }
        return ConfigurationItem.class.isAssignableFrom(type);
    }

    public long getSize(Collection<ConfigurationItem> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Collection<ConfigurationItem> cis, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        int depth = this.calculateDepth(annotations);
        ConfigurationItemConverter converter = new ConfigurationItemConverter();
        CiJsonWriter writer = new CiJsonWriter();
        writer.startList();
        for (ConfigurationItem ci : cis) {
            converter.writeCi(ci, (CiWriter)writer, depth);
        }
        writer.endList();
        String serializedListJson = writer.toString();
        ArrayList<ConfigurationItem> cisList = new ArrayList<ConfigurationItem>(cis);
        try {
            JSONArray jsonArray = new JSONArray(serializedListJson);
            for (int count = 0; count < cis.size(); ++count) {
                JSONObject ciJson = (JSONObject)jsonArray.get(count);
                ciJson.put("name", (Object)((ConfigurationItem)cisList.get(count)).getName());
            }
            serializedListJson = jsonArray.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        entityStream.write(serializedListJson.getBytes(StandardCharsets.UTF_8));
    }

    private int calculateDepth(Annotation[] annotations) {
        if (annotations == null) {
            return 0;
        }
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != CiDepth.class) continue;
            CiDepth depthAnnotation = (CiDepth)annotation;
            return depthAnnotation.value();
        }
        return 0;
    }
}

