/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.service;

import com.google.common.base.CaseFormat;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import com.jayway.jsonpath.spi.JsonProvider;
import com.jayway.jsonpath.spi.JsonProviderFactory;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.repository.TestRunsRepositoryImpl;
import com.xebialabs.xltest.service.EventRepository;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequestBuilder;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.deletebyquery.DeleteByQueryRequestBuilder;
import org.elasticsearch.action.deletebyquery.DeleteByQueryResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilteredQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class EventRepositoryImpl
implements EventRepository,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(EventRepositoryImpl.class);
    public static final String INDEX_XLTEST = "xltest";
    public static final String ELASTICSEARCH_DEFAULT_INDEX_CONFIGURATION = "elasticsearch/index-defaults.json";
    public static final List<String> EVENT_TYPES = ImmutableList.of((Object)"childFinished", (Object)"executionStarted", (Object)"executionFinished", (Object)"importStarted", (Object)"childStarted", (Object)"functionalResult", (Object)"qualificationComputed", (Object)"importFinished");
    private static final FieldSortBuilder SORT_TIMESTAMP_ASC = SortBuilders.fieldSort((String)"timestamp").order(SortOrder.ASC).unmappedType("long");
    private static final FieldSortBuilder SORT_TIMESTAMP_DESC = SortBuilders.fieldSort((String)"timestamp").order(SortOrder.DESC).unmappedType("long");
    private final Client client;

    public EventRepositoryImpl(Client client) {
        this.client = client;
    }

    public void afterPropertiesSet() throws Exception {
        this.configureIndex();
    }

    public String getResourceAsString(String resourcePath) throws IOException {
        URL url = Resources.getResource((String)resourcePath);
        return Resources.toString((URL)url, (Charset)Charsets.UTF_8);
    }

    public void configureIndex() throws InterruptedException, ExecutionException, IOException {
        if (this.existsXlTestIndex()) {
            return;
        }
        LOG.info("Configuring Elasticsearch indices");
        Settings indexSettings = ImmutableSettings.settingsBuilder().build();
        PutIndexTemplateRequestBuilder putTemplate = this.client.admin().indices().preparePutTemplate("default-index-template").setTemplate("*").setOrder(0).setSettings(indexSettings);
        URL url = Resources.getResource((String)ELASTICSEARCH_DEFAULT_INDEX_CONFIGURATION);
        String cfg = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        LOG.debug("Default mappings for indices: {}", (Object)cfg);
        putTemplate.addMapping("_default_", cfg);
        putTemplate.execute().actionGet();
        try {
            CreateIndexRequest cir = Requests.createIndexRequest((String)INDEX_XLTEST);
            for (String evenType : EVENT_TYPES) {
                String hyphenized = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, evenType);
                String fileName = String.format("elasticsearch/%s-mapping.json", hyphenized);
                try {
                    String mapping = this.getResourceAsString(fileName);
                    LOG.info("Adding mapping for '{}' from '{}'", (Object)evenType, (Object)fileName);
                    cir.mapping(evenType, mapping);
                }
                catch (IllegalArgumentException e) {
                    LOG.debug("No mapping for: {}", (Object)evenType);
                }
            }
            this.client.admin().indices().create(cir).actionGet();
        }
        catch (IndexAlreadyExistsException e) {
            LOG.info("Index '{}' already existed", (Object)INDEX_XLTEST);
        }
    }

    public Event findById(String id) {
        IdsQueryBuilder b = QueryBuilders.idsQuery((String[])new String[0]).addIds(new String[]{id});
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{INDEX_XLTEST}).setQuery((QueryBuilder)b).execute().actionGet();
        SearchHits hits = response.getHits();
        if (hits.getTotalHits() > 1L) {
            throw new IllegalStateException("Multiple events found with the same id " + id);
        }
        if (hits.getTotalHits() == 1L) {
            SearchHit hit = hits.getAt(0);
            return this.parseElasticSearchHit(hit);
        }
        return null;
    }

    public void insert(Event event) {
        this.insert(event, false);
    }

    public void insert(Event event, boolean refresh) {
        LOG.trace("insert: event='{}' refresh={}", (Object)event, (Object)refresh);
        JsonProvider jsonProvider = JsonProviderFactory.createProvider();
        String content = jsonProvider.toJson((Object)event.getProperties());
        this.insert(event.getType(), content, refresh);
    }

    public void insert(Collection<Event> events) {
        this.insert(events, false);
    }

    public void insert(Collection<Event> events, boolean refresh) {
        for (Event event : events) {
            this.insert(event, refresh);
        }
    }

    private void insert(String type, String json, boolean refresh) {
        IndexRequestBuilder indexRequestBuilder = this.client.prepareIndex(INDEX_XLTEST, type);
        indexRequestBuilder.setRefresh(refresh);
        ListenableActionFuture execute = indexRequestBuilder.setSource(json).execute();
        this.waitUntilDone(refresh, (ActionFuture<? extends ActionResponse>)execute);
    }

    public void update(Event event, boolean refresh) {
        Preconditions.checkNotNull((Object)event.getId());
        JsonProvider jsonProvider = JsonProviderFactory.createProvider();
        String content = jsonProvider.toJson((Object)event.getProperties());
        IndexRequestBuilder indexRequestBuilder = this.client.prepareIndex(INDEX_XLTEST, event.getType());
        indexRequestBuilder.setId(event.getId());
        indexRequestBuilder.setRefresh(refresh);
        ListenableActionFuture execute = indexRequestBuilder.setSource(content).execute();
        this.waitUntilDone(refresh, (ActionFuture<? extends ActionResponse>)execute);
    }

    public void update(Event event) {
        this.update(event, false);
    }

    public void update(Collection<Event> events) {
        this.update(events, false);
    }

    public void update(Collection<Event> events, boolean refresh) {
        for (Event event : events) {
            this.update(event, refresh);
        }
    }

    public List<Event> query(String query) {
        LOG.trace("query: {}", (Object)query);
        QueryStringQueryBuilder b = QueryBuilders.queryStringQuery((String)query);
        return this.query((QueryBuilder)b);
    }

    public List<Event> query(QueryBuilder b) {
        ArrayList<Event> all = new ArrayList<Event>();
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{INDEX_XLTEST}).setQuery(b).addSort((SortBuilder)SORT_TIMESTAMP_ASC).setFrom(0).setSize(100000).execute().actionGet();
        SearchHits hits = response.getHits();
        for (SearchHit hit : hits) {
            all.add(this.parseElasticSearchHit(hit));
        }
        return all;
    }

    public List<Event> query(FilterBuilder fb) {
        LOG.debug("query(): {}", (Object)fb);
        FilteredQueryBuilder qb = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)fb);
        return this.query((QueryBuilder)qb);
    }

    public ListenableActionFuture<DeleteByQueryResponse> delete(QueryBuilder qb) {
        DeleteByQueryRequestBuilder deleteByQueryRequestBuilder = this.client.prepareDeleteByQuery(new String[]{INDEX_XLTEST});
        deleteByQueryRequestBuilder.setQuery(qb);
        ListenableActionFuture future = deleteByQueryRequestBuilder.execute();
        return future;
    }

    public ListenableActionFuture<DeleteByQueryResponse> delete(FilterBuilder fb) {
        FilteredQueryBuilder qb = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)fb);
        return this.delete((QueryBuilder)qb);
    }

    public Event fetchLatest(String query) {
        SearchHits hits;
        LOG.trace("fetchLatest: {}", (Object)query);
        QueryStringQueryBuilder b = QueryBuilders.queryStringQuery((String)query);
        try {
            SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{INDEX_XLTEST}).setQuery((QueryBuilder)b).setSize(1).addSort((SortBuilder)SORT_TIMESTAMP_DESC).execute().actionGet();
            hits = response.getHits();
        }
        catch (SearchPhaseExecutionException e) {
            LOG.warn("Could not execute elasticSearch query", (Throwable)e);
            return null;
        }
        if (hits.getTotalHits() >= 1L) {
            String hit = hits.getAt(0).sourceAsString();
            return this.parseElasticSearchJson(hit);
        }
        return null;
    }

    public Event fetchLatestGroupBy(QueryBuilder qb) {
        LOG.debug("Query: {}", (Object)qb.toString());
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{INDEX_XLTEST}).setQuery(qb).setSize(1).addSort((SortBuilder)SORT_TIMESTAMP_DESC).execute().actionGet();
        SearchHits hits = response.getHits();
        if (hits.getTotalHits() == 0L) {
            return null;
        }
        return this.parseElasticSearchHit(hits.getAt(0));
    }

    public Event fetchLatest(String testSpecificationName, String eventType) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("testSpecification", testSpecificationName);
        return this.fetchLatest(TestRunsRepositoryImpl.constructSearchQuery("type:" + eventType, queryParams));
    }

    public long countAll() {
        ListenableActionFuture execute = this.client.prepareCount(new String[]{INDEX_XLTEST}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute();
        this.waitUntilDone(true, (ActionFuture<? extends ActionResponse>)execute);
        long count = ((CountResponse)execute.actionGet()).getCount();
        LOG.debug("countAll: {} events in the repository", (Object)count);
        return count;
    }

    public void refreshIndex() {
        this.client.admin().indices().prepareRefresh(new String[0]).execute().actionGet();
    }

    private Event parseElasticSearchHit(SearchHit hit) {
        Event event = Event.withId((String)hit.id(), (Map)hit.getSource());
        return event;
    }

    private Event parseElasticSearchJson(String hit) {
        if (hit == null) {
            return null;
        }
        Map object = (Map)JsonProviderFactory.createProvider().parse(hit);
        return new Event(object);
    }

    public boolean deleteIndex(boolean block) {
        ActionFuture delete = this.client.admin().indices().delete(new DeleteIndexRequest(INDEX_XLTEST));
        this.waitUntilDone(block, (ActionFuture<? extends ActionResponse>)delete);
        return ((DeleteIndexResponse)delete.actionGet()).isAcknowledged();
    }

    private boolean existsXlTestIndex() {
        return ((IndicesExistsResponse)this.client.admin().indices().exists(new IndicesExistsRequest(new String[]{INDEX_XLTEST})).actionGet()).isExists();
    }

    private void waitUntilDone(boolean block, ActionFuture<? extends ActionResponse> execute) {
        if (block) {
            execute.actionGet();
        }
    }
}

