/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;

public class MethodCall
implements Externalizable {
    private static final long serialVersionUID = 7873471327078957662L;
    protected String method_name;
    protected short method_id;
    protected Object[] args;
    protected Class[] types;
    protected Method method;
    protected static final Log log = LogFactory.getLog(MethodCall.class);
    protected short mode;
    protected static final short OLD = 1;
    protected static final short METHOD = 2;
    protected static final short TYPES = 3;
    protected static final short ID = 5;

    public MethodCall() {
    }

    public MethodCall(Method method) {
        this(method, (Object[])null);
    }

    public MethodCall(Method method, Object ... arguments) {
        this.init(method);
        if (arguments != null) {
            this.args = arguments;
        }
    }

    public MethodCall(short method_id, Object ... args) {
        this.method_id = method_id;
        this.mode = (short)5;
        this.args = args;
    }

    public MethodCall(String method_name, Object[] args, Class[] types) {
        this.method_name = method_name;
        this.args = args;
        this.types = types;
        this.mode = (short)3;
    }

    private void init(Method method) {
        this.method = method;
        this.mode = (short)2;
        this.method_name = method.getName();
    }

    public int getMode() {
        return this.mode;
    }

    public String getName() {
        return this.method_name;
    }

    public void setName(String n) {
        this.method_name = n;
    }

    public short getId() {
        return this.method_id;
    }

    public void setId(short method_id) {
        this.method_id = method_id;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public void setArgs(Object ... args) {
        this.args = args;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method m) {
        this.init(m);
    }

    Method findMethod(Class target_class) throws Exception {
        int len = this.args != null ? this.args.length : 0;
        Method[] methods = MethodCall.getAllMethods(target_class);
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.getName().equals(this.method_name) || m.getParameterTypes().length != len) continue;
            return m;
        }
        return null;
    }

    public static Method findMethod(Class target_class, String method_name, Object[] args) throws Exception {
        int len = args != null ? args.length : 0;
        Method retval = null;
        Method[] methods = MethodCall.getAllMethods(target_class);
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] parameter_types;
            Method m = methods[i];
            if (!m.getName().equals(method_name) || (parameter_types = m.getParameterTypes()).length != len) continue;
            retval = m;
            boolean all_primitive = true;
            for (Class<?> parameter_type : parameter_types) {
                if (MethodCall.isPrimitiveType(parameter_type)) continue;
                all_primitive = false;
                break;
            }
            if (!all_primitive) continue;
            return m;
        }
        return retval;
    }

    static Method[] getAllMethods(Class target) {
        Class superclass = target;
        ArrayList<Method[]> methods = new ArrayList<Method[]>();
        int size = 0;
        while (superclass != null) {
            try {
                Method[] m = superclass.getDeclaredMethods();
                methods.add(m);
                size += m.length;
                superclass = superclass.getSuperclass();
            }
            catch (SecurityException e) {
                if (log.isWarnEnabled()) {
                    log.warn("unable to enumerate methods of superclass " + superclass + " of class " + target);
                }
                superclass = null;
            }
        }
        Method[] result = new Method[size];
        int index = 0;
        for (Method[] m : methods) {
            System.arraycopy(m, 0, result, index, m.length);
            index += m.length;
        }
        return result;
    }

    static Method getMethod(Class target, String methodName, Class[] types) {
        if (types == null) {
            types = new Class[]{};
        }
        Method[] methods = MethodCall.getAllMethods(target);
        block0: for (int i = 0; i < methods.length; ++i) {
            Class<?>[] parameters;
            Method m = methods[i];
            if (!methodName.equals(m.getName()) || types.length != (parameters = m.getParameterTypes()).length) continue;
            for (int j = 0; j < types.length; ++j) {
                if (!parameters[j].isAssignableFrom(types[j])) continue block0;
            }
            return m;
        }
        return null;
    }

    public Object invoke(Object target) throws Exception {
        Method meth = null;
        if (this.method_name == null || target == null) {
            if (log.isErrorEnabled()) {
                log.error("method name or target is null");
            }
            return null;
        }
        Class<?> cl = target.getClass();
        switch (this.mode) {
            case 1: {
                meth = this.findMethod(cl);
                break;
            }
            case 2: {
                if (this.method == null) break;
                meth = this.method;
                break;
            }
            case 3: {
                meth = MethodCall.getMethod(cl, this.method_name, this.types);
                break;
            }
            case 5: {
                break;
            }
            default: {
                if (!log.isErrorEnabled()) break;
                log.error("mode " + this.mode + " is invalid");
            }
        }
        if (meth != null) {
            try {
                return meth.invoke(target, this.args);
            }
            catch (InvocationTargetException target_ex) {
                Throwable exception = target_ex.getTargetException();
                if (exception instanceof Error) {
                    throw (Error)exception;
                }
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof Exception) {
                    throw (Exception)exception;
                }
                throw new RuntimeException(exception);
            }
        }
        throw new NoSuchMethodException(this.method_name);
    }

    public Object invoke(Object target, Object[] args) throws Exception {
        if (args != null) {
            this.args = args;
        }
        return this.invoke(target);
    }

    static Class[] getTypesFromString(Class cl, String[] signature) throws Exception {
        Class[] mytypes = new Class[signature.length];
        for (int i = 0; i < signature.length; ++i) {
            String name = signature[i];
            Class<Constable> parameter = "long".equals(name) ? Long.TYPE : ("int".equals(name) ? Integer.TYPE : ("short".equals(name) ? Short.TYPE : ("char".equals(name) ? Character.TYPE : ("byte".equals(name) ? Byte.TYPE : ("float".equals(name) ? Float.TYPE : ("double".equals(name) ? Double.TYPE : ("boolean".equals(name) ? Boolean.TYPE : Class.forName(name, false, cl.getClassLoader()))))))));
            mytypes[i] = parameter;
        }
        return mytypes;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        boolean first = true;
        if (this.method_name != null) {
            ret.append(this.method_name);
        } else {
            ret.append(this.method_id);
        }
        ret.append('(');
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                if (first) {
                    first = false;
                } else {
                    ret.append(", ");
                }
                ret.append(this.args[i]);
            }
        }
        ret.append(')');
        return ret.toString();
    }

    public String toStringDetails() {
        StringBuilder ret = new StringBuilder();
        ret.append("MethodCall ");
        if (this.method_name != null) {
            ret.append("name=").append(this.method_name);
        } else {
            ret.append("id=").append(this.method_id);
        }
        ret.append(", number of args=").append(this.args != null ? this.args.length : 0).append(')');
        if (this.args != null) {
            ret.append("\nArgs:");
            for (int i = 0; i < this.args.length; ++i) {
                ret.append("\n[").append(this.args[i]).append(" (").append(this.args[i] != null ? this.args[i].getClass().getName() : "null").append(")]");
            }
        }
        return ret.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.method_name != null) {
            out.writeBoolean(true);
            out.writeUTF(this.method_name);
        } else {
            out.writeBoolean(false);
            out.writeShort(this.method_id);
        }
        out.writeObject(this.args);
        out.writeShort(this.mode);
        switch (this.mode) {
            case 1: {
                break;
            }
            case 2: {
                out.writeObject(this.method.getParameterTypes());
                out.writeObject(this.method.getDeclaringClass());
                break;
            }
            case 3: {
                out.writeObject(this.types);
                break;
            }
            case 5: {
                break;
            }
            default: {
                if (!log.isErrorEnabled()) break;
                log.error("mode " + this.mode + " is invalid");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean name_available = in.readBoolean();
        if (name_available) {
            this.method_name = in.readUTF();
        } else {
            this.method_id = in.readShort();
        }
        this.args = (Object[])in.readObject();
        this.mode = in.readShort();
        switch (this.mode) {
            case 1: {
                break;
            }
            case 2: {
                Class[] parametertypes = (Class[])in.readObject();
                Class declaringclass = (Class)in.readObject();
                try {
                    this.method = declaringclass.getDeclaredMethod(this.method_name, parametertypes);
                    break;
                }
                catch (NoSuchMethodException e) {
                    throw new IOException(e.toString());
                }
            }
            case 3: {
                this.types = (Class[])in.readObject();
                break;
            }
            case 5: {
                break;
            }
            default: {
                if (!log.isErrorEnabled()) break;
                log.error("mode " + this.mode + " is invalid");
            }
        }
    }

    public static Object convert(String arg, Class<?> type) {
        if (type == String.class) {
            return arg;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean.valueOf(arg);
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return Byte.valueOf(arg);
        }
        if (type == Short.TYPE || type == Short.class) {
            return Short.valueOf(arg);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return Integer.valueOf(arg);
        }
        if (type == Long.TYPE || type == Long.class) {
            return Long.valueOf(arg);
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(arg);
        }
        if (type == Double.TYPE || type == Double.class) {
            return Double.valueOf(arg);
        }
        return arg;
    }

    public static boolean isPrimitiveType(Class<?> type) {
        return type == String.class || type == Boolean.TYPE || type == Boolean.class || type == Character.TYPE || type == Character.class || type == Byte.TYPE || type == Byte.class || type == Short.TYPE || type == Short.class || type == Integer.TYPE || type == Integer.class || type == Long.TYPE || type == Long.class || type == Float.TYPE || type == Float.class || type == Double.TYPE || type == Double.class;
    }
}

