/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedList;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

@MBean(description="Failure detection based on simple heartbeat protocol")
public class FD
extends Protocol {
    @Property(description="Timeout to suspect a node P if neither a heartbeat nor data were received from P.")
    protected long timeout = 3000L;
    @Property(description="Number of times to send an are-you-alive message")
    protected int max_tries = 5;
    @Property(description="Treat messages received from members as heartbeats. Note that this means we're updating a value in a hashmap every time a message is passing up the stack through FD, which is costly.")
    boolean msg_counts_as_heartbeat = true;
    protected int num_heartbeats;
    protected int num_suspect_events;
    protected final BoundedList<Address> suspect_history = new BoundedList(20);
    protected Address local_addr;
    protected volatile long last_ack = System.currentTimeMillis();
    protected final AtomicInteger num_tries = new AtomicInteger(1);
    protected final Lock lock = new ReentrantLock();
    protected volatile Address ping_dest;
    protected final List<Address> members = new ArrayList<Address>();
    protected final List<Address> pingable_mbrs = new ArrayList<Address>();
    protected TimeScheduler timer;
    protected Future<?> monitor_future = null;
    protected final Broadcaster bcast_task = new Broadcaster();

    @ManagedAttribute(description="Member address")
    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    @ManagedAttribute(description="List of cluster members")
    public String getMembers() {
        return this.members != null ? this.members.toString() : "null";
    }

    @ManagedAttribute(description="List of pingable members of a cluster")
    public String getPingableMembers() {
        return this.pingable_mbrs != null ? this.pingable_mbrs.toString() : "null";
    }

    @ManagedAttribute(description="Ping destination")
    public String getPingDest() {
        return this.ping_dest != null ? this.ping_dest.toString() : "null";
    }

    @ManagedAttribute(description="Number of heartbeats sent")
    public int getNumberOfHeartbeatsSent() {
        return this.num_heartbeats;
    }

    @ManagedAttribute(description="Number of suspect events received")
    public int getNumSuspectEventsGenerated() {
        return this.num_suspect_events;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public int getMaxTries() {
        return this.max_tries;
    }

    public void setMaxTries(int max_tries) {
        this.max_tries = max_tries;
    }

    public int getCurrentNumTries() {
        return this.num_tries.get();
    }

    @ManagedOperation(description="Print suspect history")
    public String printSuspectHistory() {
        StringBuilder sb = new StringBuilder();
        for (Address addr : this.suspect_history) {
            sb.append(new Date()).append(": ").append(addr).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void resetStats() {
        this.num_suspect_events = 0;
        this.num_heartbeats = 0;
        this.suspect_history.clear();
    }

    @Override
    public void init() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer cannot be retrieved");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.lock.lock();
        try {
            this.ping_dest = null;
            this.stopMonitor();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Address getPingDest(List<Address> mbrs) {
        Address retval = null;
        if (mbrs == null || mbrs.size() < 2 || this.local_addr == null) {
            return null;
        }
        for (int i = 0; i < mbrs.size(); ++i) {
            Address tmp = mbrs.get(i);
            if (!this.local_addr.equals(tmp)) continue;
            if (i + 1 >= mbrs.size()) {
                retval = mbrs.get(0);
                break;
            }
            retval = mbrs.get(i + 1);
            break;
        }
        return retval;
    }

    @ManagedOperation(description="Stops checking for crashed members")
    public void stopFailureDetection() {
        this.stopMonitor();
    }

    @ManagedOperation(description="Resumes checking for crashed members")
    public void startFailureDetection() {
        this.startMonitor();
    }

    protected void startMonitor() {
        if (this.monitor_future == null || this.monitor_future.isDone()) {
            this.last_ack = System.currentTimeMillis();
            this.monitor_future = this.timer.scheduleWithFixedDelay(new Monitor(), this.timeout, this.timeout, TimeUnit.MILLISECONDS);
            this.num_tries.set(1);
        }
    }

    protected void stopMonitor() {
        if (this.monitor_future != null) {
            this.monitor_future.cancel(true);
            this.monitor_future = null;
        }
    }

    @ManagedAttribute(description="Whether the failure detection monitor is running", writable=false)
    public boolean isMonitorRunning() {
        return this.monitor_future != null && !this.monitor_future.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                FdHeader hdr = (FdHeader)msg.getHeader(this.id);
                if (hdr == null) {
                    if (!this.msg_counts_as_heartbeat) break;
                    this.updateTimestamp(msg.getSrc());
                    break;
                }
                switch (hdr.type) {
                    case 0: {
                        Address hb_sender = msg.getSrc();
                        if (this.log.isTraceEnabled()) {
                            this.log.trace(this.local_addr + ": received are-you-alive from " + hb_sender + ", sending response");
                        }
                        this.sendHeartbeatResponse(hb_sender);
                        break;
                    }
                    case 1: {
                        this.updateTimestamp(hdr.from);
                        break;
                    }
                    case 2: {
                        if (hdr.mbrs == null) {
                            return null;
                        }
                        if (this.log.isTraceEnabled()) {
                            this.log.trace(this.local_addr + ": received suspect message: " + hdr);
                        }
                        for (Address mbr : hdr.mbrs) {
                            if (this.local_addr != null && mbr.equals(this.local_addr)) {
                                if (this.log.isWarnEnabled()) {
                                    this.log.warn(this.local_addr + ": I was suspected by " + msg.getSrc() + "; ignoring the SUSPECT message and sending back a HEARTBEAT_ACK");
                                }
                                this.sendHeartbeatResponse(msg.getSrc());
                                continue;
                            }
                            this.lock.lock();
                            try {
                                this.computePingDest(mbr);
                            }
                            finally {
                                this.lock.unlock();
                            }
                            this.up_prot.up(new Event(9, mbr));
                            this.down_prot.down(new Event(9, mbr));
                        }
                        break;
                    }
                }
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public void up(MessageBatch batch) {
        Collection<Message> msgs = batch.getMatchingMessages(this.id, true);
        boolean updated = false;
        if (msgs != null) {
            for (Message msg : msgs) {
                FdHeader hdr = (FdHeader)msg.getHeader(this.id);
                if (hdr.type == 1) {
                    updated = true;
                    continue;
                }
                this.up(new Event(1, msg));
            }
        }
        if (updated || this.msg_counts_as_heartbeat && batch.sender() != null) {
            this.updateTimestamp(batch.sender());
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                Object retval = this.down_prot.down(evt);
                View view = (View)evt.getArg();
                this.lock.lock();
                try {
                    this.members.clear();
                    this.members.addAll(view.getMembers());
                    this.bcast_task.adjustSuspectedMembers(this.members);
                    this.computePingDest(null);
                    if (view.size() <= 1) {
                        this.stopMonitor();
                    } else if (!this.isMonitorRunning()) {
                        this.startMonitor();
                    }
                }
                finally {
                    this.lock.unlock();
                }
                return retval;
            }
            case 51: {
                this.unsuspect((Address)evt.getArg());
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    protected void sendHeartbeatResponse(Address dest) {
        Message hb_ack = new Message(dest).setFlag(Message.Flag.INTERNAL);
        FdHeader tmp_hdr = new FdHeader(1);
        tmp_hdr.from = this.local_addr;
        hb_ack.putHeader(this.id, tmp_hdr);
        this.down_prot.down(new Event(1, hb_ack));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsuspect(Address mbr) {
        this.lock.lock();
        try {
            this.bcast_task.removeSuspectedMember(mbr);
            this.computePingDest(null);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void updateTimestamp(Address sender) {
        if (sender != null && sender.equals(this.ping_dest)) {
            this.last_ack = System.currentTimeMillis();
            this.num_tries.set(1);
        }
    }

    protected void computePingDest(Address remove) {
        if (remove != null) {
            this.pingable_mbrs.remove(remove);
        } else {
            this.pingable_mbrs.clear();
            this.pingable_mbrs.addAll(this.members);
            this.pingable_mbrs.removeAll(this.bcast_task.getSuspectedMembers());
        }
        Address old_ping_dest = this.ping_dest;
        this.ping_dest = this.getPingDest(this.pingable_mbrs);
        if (Util.different(old_ping_dest, this.ping_dest)) {
            this.num_tries.set(1);
            this.last_ack = System.currentTimeMillis();
        }
    }

    protected final class BroadcastTask
    implements Runnable {
        protected final List<Address> suspected_members = new ArrayList<Address>();

        BroadcastTask(List<Address> suspected_members) {
            this.suspected_members.addAll(suspected_members);
        }

        public void stop() {
            this.suspected_members.clear();
            if (FD.this.log.isTraceEnabled()) {
                FD.this.log.trace(FD.this.local_addr + ": BroadcastTask stopped");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FdHeader hdr;
            List<Address> list = this.suspected_members;
            synchronized (list) {
                if (this.suspected_members.isEmpty()) {
                    this.stop();
                    return;
                }
                hdr = new FdHeader(2);
                hdr.mbrs = new ArrayList<Address>(this.suspected_members);
                hdr.from = FD.this.local_addr;
            }
            Message suspect_msg = new Message().setFlag(Message.Flag.INTERNAL).putHeader(FD.this.id, hdr);
            if (FD.this.log.isDebugEnabled()) {
                FD.this.log.debug(FD.this.local_addr + ": broadcasting SUSPECT message (suspects=" + this.suspected_members + ")");
            }
            FD.this.down_prot.down(new Event(1, suspect_msg));
        }

        public void addSuspectedMember(Address suspect) {
            if (suspect != null && !this.suspected_members.contains(suspect)) {
                this.suspected_members.add(suspect);
            }
        }

        public String toString() {
            return "BroadcastTask (" + this.suspected_members.size() + " suspected mbrs)";
        }
    }

    protected final class Broadcaster {
        protected final List<Address> suspected_mbrs = new ArrayList<Address>(7);
        protected final Lock bcast_lock = new ReentrantLock();
        protected Future<?> bcast_future = null;
        protected BroadcastTask task;

        protected Broadcaster() {
        }

        protected List<Address> getSuspectedMembers() {
            return this.suspected_mbrs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void startBroadcastTask(Address suspect) {
            this.bcast_lock.lock();
            try {
                if (this.bcast_future == null || this.bcast_future.isDone()) {
                    this.task = new BroadcastTask(this.suspected_mbrs);
                    this.task.addSuspectedMember(suspect);
                    this.bcast_future = FD.this.timer.scheduleWithFixedDelay(this.task, 0L, FD.this.timeout, TimeUnit.MILLISECONDS);
                    if (FD.this.log.isTraceEnabled()) {
                        FD.this.log.trace(FD.this.local_addr + ": BroadcastTask started");
                    }
                } else {
                    this.task.addSuspectedMember(suspect);
                }
            }
            finally {
                this.bcast_lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void stopBroadcastTask() {
            this.bcast_lock.lock();
            try {
                if (this.bcast_future != null) {
                    this.bcast_future.cancel(true);
                    this.bcast_future = null;
                    this.task = null;
                }
            }
            finally {
                this.bcast_lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addSuspectedMember(Address mbr) {
            if (mbr == null) {
                return;
            }
            if (!FD.this.members.contains(mbr)) {
                return;
            }
            List<Address> list = this.suspected_mbrs;
            synchronized (list) {
                if (!this.suspected_mbrs.contains(mbr)) {
                    this.suspected_mbrs.add(mbr);
                    this.startBroadcastTask(mbr);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeSuspectedMember(Address suspected_mbr) {
            if (suspected_mbr == null) {
                return;
            }
            if (FD.this.log.isDebugEnabled()) {
                FD.this.log.debug(FD.this.local_addr + ": member is " + suspected_mbr);
            }
            List<Address> list = this.suspected_mbrs;
            synchronized (list) {
                this.suspected_mbrs.remove(suspected_mbr);
                if (this.suspected_mbrs.isEmpty()) {
                    this.stopBroadcastTask();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void adjustSuspectedMembers(List<Address> new_mbrship) {
            if (new_mbrship == null || new_mbrship.isEmpty()) {
                return;
            }
            List<Address> list = this.suspected_mbrs;
            synchronized (list) {
                this.suspected_mbrs.retainAll(new_mbrship);
                if (this.suspected_mbrs.isEmpty()) {
                    this.stopBroadcastTask();
                }
            }
        }
    }

    protected class Monitor
    implements Runnable {
        protected Monitor() {
        }

        @Override
        public void run() {
            Address dest = FD.this.ping_dest;
            if (dest == null) {
                if (FD.this.log.isTraceEnabled()) {
                    FD.this.log.trace(FD.this.local_addr + ": ping_dest is null, skipping timeout check: members=" + FD.this.members + ", pingable_mbrs=" + FD.this.pingable_mbrs + ", local_addr=" + FD.this.local_addr);
                }
                return;
            }
            Message hb_req = new Message(dest).setFlag(Message.Flag.INTERNAL).putHeader(FD.this.id, new FdHeader(0));
            if (FD.this.log.isDebugEnabled()) {
                FD.this.log.debug(FD.this.local_addr + ": sending are-you-alive msg to " + dest);
            }
            FD.this.down_prot.down(new Event(1, hb_req));
            ++FD.this.num_heartbeats;
            long not_heard_from = System.currentTimeMillis() - FD.this.last_ack;
            if (not_heard_from > FD.this.timeout + 500L) {
                int tmp_tries = FD.this.num_tries.get();
                if (tmp_tries >= FD.this.max_tries) {
                    if (!dest.equals(FD.this.ping_dest)) {
                        return;
                    }
                    if (FD.this.log.isDebugEnabled()) {
                        FD.this.log.debug(FD.this.local_addr + ": received no heartbeat from " + dest + " for " + tmp_tries + " times (" + (long)tmp_tries * FD.this.timeout + " milliseconds), suspecting it");
                    }
                    FD.this.bcast_task.addSuspectedMember(dest);
                    FD.this.num_tries.set(1);
                    if (FD.this.stats) {
                        ++FD.this.num_suspect_events;
                        FD.this.suspect_history.add(dest);
                    }
                } else {
                    if (FD.this.log.isDebugEnabled()) {
                        FD.this.log.debug(FD.this.local_addr + ": heartbeat missing from " + dest + " (number=" + tmp_tries + ')');
                    }
                    FD.this.num_tries.incrementAndGet();
                }
            }
        }

        public String toString() {
            return FD.class.getSimpleName() + ": Monitor (timeout=" + FD.this.timeout + "ms)";
        }
    }

    public static class FdHeader
    extends Header {
        public static final byte HEARTBEAT = 0;
        public static final byte HEARTBEAT_ACK = 1;
        public static final byte SUSPECT = 2;
        protected byte type = 0;
        protected Collection<Address> mbrs;
        protected Address from;

        public FdHeader() {
        }

        public FdHeader(byte type) {
            this.type = type;
        }

        public FdHeader(byte type, Collection<Address> mbrs, Address from) {
            this(type);
            this.mbrs = mbrs;
            this.from = from;
        }

        @Override
        public String toString() {
            switch (this.type) {
                case 0: {
                    return "heartbeat";
                }
                case 1: {
                    return "heartbeat ack";
                }
                case 2: {
                    return "SUSPECT (suspected_mbrs=" + this.mbrs + ", from=" + this.from + ")";
                }
            }
            return "unknown type (" + this.type + ")";
        }

        @Override
        public int size() {
            int retval = 1;
            retval = (int)((long)retval + Util.size(this.mbrs));
            return retval += Util.size(this.from);
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type);
            Util.writeAddresses(this.mbrs, out);
            Util.writeAddress(this.from, out);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = in.readByte();
            this.mbrs = Util.readAddresses(in, ArrayList.class);
            this.from = Util.readAddress(in);
        }
    }
}

