/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

public class SiteUUID
extends UUID
implements SiteAddress {
    private static final long serialVersionUID = -8602137120498053578L;
    protected String name;
    protected String site;

    public SiteUUID() {
    }

    public SiteUUID(long mostSigBits, long leastSigBits, String name, String site) {
        super(mostSigBits, leastSigBits);
        this.name = name;
        this.site = site;
    }

    public SiteUUID(UUID uuid, String name, String site) {
        super(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
        this.name = name;
        this.site = site;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getSite() {
        return this.site;
    }

    @Override
    public UUID copy() {
        return new SiteUUID(this.mostSigBits, this.leastSigBits, this.name, this.site);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.name = in.readUTF();
        this.site = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeUTF(this.name);
        out.writeUTF(this.site);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        super.readFrom(in);
        this.name = Util.readString(in);
        this.site = Util.readString(in);
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        super.writeTo(out);
        Util.writeString(this.name, out);
        Util.writeString(this.site, out);
    }

    @Override
    public int size() {
        return super.size() + Util.size(this.name) + Util.size(this.site);
    }

    @Override
    public String toString() {
        String retval = this.name != null ? this.name : super.toString();
        return retval + ":" + this.site;
    }
}

