/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLSchemaGenerator {
    public static void main(String[] args) {
        String outputDir = "./";
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!"-o".equals(arg)) {
                System.out.println("XMLSchemaGenerator -o <path to newly created xsd schema file>");
                return;
            }
            outputDir = args[++i];
        }
        File f = new File(outputDir, "JGroups-3.4.xsd");
        try {
            FileWriter fw = new FileWriter(f, false);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation impl = builder.getDOMImplementation();
            Document xmldoc = impl.createDocument("http://www.w3.org/2001/XMLSchema", "xs:schema", null);
            xmldoc.getDocumentElement().setAttribute("targetNamespace", "urn:org:jgroups");
            xmldoc.getDocumentElement().setAttribute("xmlns:tns", "urn:org:jgroups");
            xmldoc.getDocumentElement().setAttribute("elementFormDefault", "qualified");
            Element complexType = xmldoc.createElement("xs:complexType");
            complexType.setAttribute("name", "ConfigType");
            xmldoc.getDocumentElement().appendChild(complexType);
            Element allType = xmldoc.createElement("xs:choice");
            allType.setAttribute("maxOccurs", "unbounded");
            complexType.appendChild(allType);
            Set<Class<?>> classes = XMLSchemaGenerator.getClasses("org.jgroups.protocols", Protocol.class);
            for (Class<?> clazz : classes) {
                XMLSchemaGenerator.classToXML(xmldoc, allType, clazz, "");
            }
            classes = XMLSchemaGenerator.getClasses("org.jgroups.protocols.pbcast", Protocol.class);
            for (Class<?> clazz : classes) {
                XMLSchemaGenerator.classToXML(xmldoc, allType, clazz, "pbcast.");
            }
            classes = XMLSchemaGenerator.getClasses("org.jgroups.protocols.tom", Protocol.class);
            for (Class<?> clazz : classes) {
                XMLSchemaGenerator.classToXML(xmldoc, allType, clazz, "tom.");
            }
            classes = XMLSchemaGenerator.getClasses("org.jgroups.protocols.relay", Protocol.class);
            for (Class<?> clazz : classes) {
                XMLSchemaGenerator.classToXML(xmldoc, allType, clazz, "relay.");
            }
            classes = XMLSchemaGenerator.getClasses("org.jgroups.protocols.rules", Protocol.class);
            for (Class<?> clazz : classes) {
                XMLSchemaGenerator.classToXML(xmldoc, allType, clazz, "rules.");
            }
            Element xsElement = xmldoc.createElement("xs:element");
            xsElement.setAttribute("name", "config");
            xsElement.setAttribute("type", "tns:ConfigType");
            xmldoc.getDocumentElement().appendChild(xsElement);
            DOMSource domSource = new DOMSource(xmldoc);
            StreamResult streamResult = new StreamResult(fw);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("method", "xml");
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            serializer.transform(domSource, streamResult);
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Set<Class<?>> getClasses(String packageName, Class<?> assignableFrom) throws IOException, ClassNotFoundException {
        String filePath;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        HashSet classes = new HashSet();
        String path = packageName.replace('.', '/');
        URL resource = loader.getResource(path);
        if (resource != null && (filePath = resource.getFile()) != null && new File(filePath).isDirectory()) {
            for (String file : new File(filePath).list()) {
                String name;
                Class<?> clazz;
                if (!file.endsWith(".class") || !assignableFrom.isAssignableFrom(clazz = Class.forName(name = packageName + '.' + file.substring(0, file.indexOf(".class"))))) continue;
                classes.add(clazz);
            }
        }
        return classes;
    }

    private static void classToXML(Document xmldoc, Element parent, Class<?> clazz, String preAppendToSimpleClassName) throws Exception {
        boolean isConcreteClass;
        boolean bl = isConcreteClass = (clazz.getModifiers() & 0x400) == 0;
        if (isConcreteClass && !clazz.isAnonymousClass()) {
            parent.appendChild(XMLSchemaGenerator.createXMLTree(xmldoc, clazz, preAppendToSimpleClassName));
        }
    }

    private static Element createXMLTree(Document xmldoc, Class<?> clazz, String preAppendToSimpleClassName) throws Exception {
        Method[] methods;
        Element classElement = xmldoc.createElement("xs:element");
        String elementName = preAppendToSimpleClassName + clazz.getSimpleName();
        if (elementName == null || elementName.isEmpty()) {
            throw new IllegalArgumentException("Cannot create empty attribute name for element xs:element, class is " + clazz);
        }
        classElement.setAttribute("name", elementName);
        Element complexType = xmldoc.createElement("xs:complexType");
        classElement.appendChild(complexType);
        for (Class<?> clazzInLoop = clazz; clazzInLoop != null; clazzInLoop = clazzInLoop.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazzInLoop.getDeclaredFields()) {
                boolean annotationRedefinesName;
                if (!field.isAnnotationPresent(Property.class)) continue;
                String property = field.getName();
                Property r = field.getAnnotation(Property.class);
                boolean bl = annotationRedefinesName = !r.name().isEmpty() && r.deprecatedMessage().isEmpty();
                if (annotationRedefinesName) {
                    property = r.name();
                }
                if (property == null || property.isEmpty()) {
                    throw new IllegalArgumentException("Cannot create empty attribute name for element xs:attribute, field is " + field);
                }
                Element attributeElement = xmldoc.createElement("xs:attribute");
                attributeElement.setAttribute("name", property);
                attributeElement.setAttribute("type", "xs:string");
                complexType.appendChild(attributeElement);
                Element annotationElement = xmldoc.createElement("xs:annotation");
                attributeElement.appendChild(annotationElement);
                Element documentationElement = xmldoc.createElement("xs:documentation");
                documentationElement.setTextContent(r.description());
                annotationElement.appendChild(documentationElement);
            }
        }
        for (Method method : methods = clazz.getMethods()) {
            if (!method.isAnnotationPresent(Property.class)) continue;
            Property annotation = method.getAnnotation(Property.class);
            String name = annotation.name();
            if (name.length() < 1) {
                name = Util.methodNameToAttributeName(method.getName());
            }
            Element attributeElement = xmldoc.createElement("xs:attribute");
            attributeElement.setAttribute("name", name);
            attributeElement.setAttribute("type", "xs:string");
            complexType.appendChild(attributeElement);
            String desc = annotation.description();
            if (desc.isEmpty()) continue;
            Element annotationElement = xmldoc.createElement("xs:annotation");
            attributeElement.appendChild(annotationElement);
            Element documentationElement = xmldoc.createElement("xs:documentation");
            documentationElement.setTextContent(annotation.description());
            annotationElement.appendChild(documentationElement);
        }
        return classElement;
    }
}

