/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.optimize;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.model.Column;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.optimize.OptimizerRule;
import org.modeshape.jcr.query.optimize.PushSelectCriteria;
import org.modeshape.jcr.query.optimize.RaiseSelectCriteria;
import org.modeshape.jcr.query.plan.CanonicalPlanner;
import org.modeshape.jcr.query.plan.PlanNode;
import org.modeshape.jcr.query.plan.PlanUtil;
import org.modeshape.jcr.query.validate.Schemata;

@Immutable
public class ReplaceViews
implements OptimizerRule {
    public static final ReplaceViews INSTANCE = new ReplaceViews();

    @Override
    public PlanNode execute(QueryContext context, PlanNode plan, LinkedList<OptimizerRule> ruleStack) {
        CanonicalPlanner planner = new CanonicalPlanner();
        Schemata schemata = context.getSchemata();
        HashSet<PlanNode> processedSources = new HashSet<PlanNode>();
        boolean foundViews = false;
        do {
            foundViews = false;
            for (PlanNode sourceNode : plan.findAllAtOrBelow(PlanNode.Type.SOURCE)) {
                Schemata.View view;
                PlanNode viewPlan;
                if (processedSources.contains(sourceNode)) continue;
                processedSources.add(sourceNode);
                SelectorName tableName = sourceNode.getProperty(PlanNode.Property.SOURCE_NAME, SelectorName.class);
                SelectorName tableAlias = sourceNode.getProperty(PlanNode.Property.SOURCE_ALIAS, SelectorName.class);
                Schemata.Table table = schemata.getTable(tableName);
                if (!(table instanceof Schemata.View) || (viewPlan = planner.createPlan(context, (view = (Schemata.View)table).getDefinition())) == null) continue;
                PlanNode viewProjectNode = viewPlan.findAtOrBelow(PlanNode.Type.PROJECT);
                if (viewProjectNode.getSelectors().size() == 1) {
                    PlanNode project;
                    SelectorName tableAliasOrName = tableAlias != null ? tableAlias : tableName;
                    SelectorName viewAlias = viewProjectNode.getSelectors().iterator().next();
                    Map<SelectorName, SelectorName> replacements = Collections.singletonMap(viewAlias, tableAliasOrName);
                    PlanUtil.replaceReferencesToRemovedSource(context, viewPlan, replacements);
                    if (!context.getHints().validateColumnExistance && (project = sourceNode.findAncestor(PlanNode.Type.PROJECT)) != null) {
                        List<Column> projectedColumns = project.getPropertyAsList(PlanNode.Property.PROJECT_COLUMNS, Column.class);
                        viewPlan = PlanUtil.addMissingProjectColumns(context, viewProjectNode, projectedColumns);
                        assert (viewPlan != null);
                    }
                }
                sourceNode.addLastChild(viewPlan);
                sourceNode.extractFromParent();
                PlanNode parent = viewPlan.getParent();
                if (parent != null) {
                    PlanUtil.ColumnMapping aliasMappings = null;
                    if (tableAlias != null) {
                        aliasMappings = PlanUtil.createMappingForAliased(tableAlias, view, viewPlan);
                        PlanUtil.replaceViewReferences(context, parent, aliasMappings);
                    }
                    PlanUtil.ColumnMapping viewMappings = PlanUtil.createMappingFor(view, viewPlan);
                    PlanUtil.replaceViewReferences(context, parent, viewMappings);
                }
                if (viewPlan.is(PlanNode.Type.PROJECT)) {
                    for (PlanNode node = viewPlan.getParent(); node != null && !node.isOneOf(PlanNode.Type.JOIN, new PlanNode.Type[0]); node = node.getParent()) {
                        if (!node.is(PlanNode.Type.PROJECT) || !viewPlan.getSelectors().containsAll(node.getSelectors())) continue;
                        viewPlan.extractFromParent();
                        break;
                    }
                }
                foundViews = true;
            }
        } while (foundViews);
        if (foundViews) {
            if (!(ruleStack.getFirst() instanceof RaiseSelectCriteria)) {
                ruleStack.addFirst(RaiseSelectCriteria.INSTANCE);
                ruleStack.addFirst(PushSelectCriteria.INSTANCE);
            }
            ruleStack.addFirst(this);
        }
        return plan;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

