/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.spi.index;

import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.change.AbstractNodeChange;
import org.modeshape.jcr.cache.change.AbstractPropertyChange;
import org.modeshape.jcr.cache.change.Change;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.cache.change.NodeAdded;
import org.modeshape.jcr.cache.change.NodeRemoved;
import org.modeshape.jcr.cache.change.PropertyAdded;
import org.modeshape.jcr.cache.change.PropertyChanged;
import org.modeshape.jcr.cache.change.PropertyRemoved;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.Property;

public class IndexChangeSetListeners {
    public static ChangeSetListener create(ExecutionContext context, NodeTypes.Supplier nodeTypesSupplier, IndexDefinition indexDefinition, SingleColumnIndexOperations operations) {
        assert (indexDefinition.hasSingleColumn());
        String processKey = context.getProcessId();
        NameFactory names = context.getValueFactories().getNameFactory();
        Name nodeTypeName = (Name)names.create(indexDefinition.getNodeTypeName());
        Name propName = (Name)names.create(indexDefinition.getColumnDefinition(0).getPropertyName());
        return new SinglePropertyIndexChangeSetListener(processKey, nodeTypesSupplier, nodeTypeName, propName, operations);
    }

    public static ChangeSetListener create(ExecutionContext context, NodeTypes.Supplier nodeTypesSupplier, IndexDefinition indexDefinition, MultiColumnIndexOperations operations) {
        assert (indexDefinition.hasSingleColumn());
        String processKey = context.getProcessId();
        NameFactory names = context.getValueFactories().getNameFactory();
        Name nodeTypeName = (Name)names.create(indexDefinition.getNodeTypeName());
        Name[] propNames = new Name[indexDefinition.size()];
        for (int i = 0; i != indexDefinition.size(); ++i) {
            propNames[i] = (Name)names.create(indexDefinition.getColumnDefinition(i).getPropertyName());
        }
        return new MultiPropertyIndexChangeSetListener(processKey, nodeTypesSupplier, nodeTypeName, propNames, operations);
    }

    private IndexChangeSetListeners() {
    }

    @NotThreadSafe
    protected static class MultiPropertyIndexChangeSetListener
    extends IndexChangeSetListener {
        private final Name[] indexedPropertyNames;
        private final MultiColumnIndexOperations ops;
        private final int numberOfProperties;
        private NodeKey nodeKey;
        private boolean hasNewProps = false;
        private boolean hasOldProps = false;
        private final Property[] newProps;
        private final Property[] oldProps;

        public MultiPropertyIndexChangeSetListener(String localProcessKey, NodeTypes.Supplier nodeTypesSupplier, Name nodeType, Name[] indexedPropertyNames, MultiColumnIndexOperations ops) {
            super(localProcessKey, nodeTypesSupplier, nodeType);
            this.indexedPropertyNames = indexedPropertyNames;
            this.numberOfProperties = indexedPropertyNames.length;
            this.ops = ops;
            this.newProps = new Property[this.numberOfProperties];
            this.oldProps = new Property[this.numberOfProperties];
        }

        @Override
        public void notify(ChangeSet changeSet) {
            if (this.ops.start(changeSet.getWorkspaceName(), this.isLocal(changeSet))) {
                NodeKey nodeKey = null;
                block0: for (Change change : changeSet) {
                    AbstractNodeChange nodeChange;
                    if (!(change instanceof AbstractNodeChange) || !this.acceptableNodeType(nodeChange = (AbstractNodeChange)change)) continue;
                    if (nodeKey == null) {
                        nodeKey = nodeChange.getKey();
                    } else if (!nodeKey.equals(nodeChange.getKey())) {
                        this.processProperties();
                        nodeKey = nodeChange.getKey();
                    }
                    if (nodeChange instanceof AbstractPropertyChange) {
                        AbstractPropertyChange propChange = (AbstractPropertyChange)nodeChange;
                        Property property = propChange.getProperty();
                        for (int i = 0; i != this.numberOfProperties; ++i) {
                            if (!this.indexedPropertyNames[i].equals(property.getName())) continue;
                            if (nodeChange instanceof PropertyAdded) {
                                this.newProps[i] = property;
                                this.hasNewProps = true;
                                continue block0;
                            }
                            if (nodeChange instanceof PropertyChanged) {
                                PropertyChanged changedProperty = (PropertyChanged)nodeChange;
                                this.newProps[i] = property;
                                this.oldProps[i] = changedProperty.getOldProperty();
                                this.hasNewProps = true;
                                this.hasOldProps = true;
                                continue block0;
                            }
                            if (!(nodeChange instanceof PropertyRemoved)) continue block0;
                            this.oldProps[i] = property;
                            this.hasOldProps = true;
                            continue block0;
                        }
                        continue;
                    }
                    if (nodeChange instanceof NodeAdded) {
                        NodeAdded added = (NodeAdded)nodeChange;
                        for (int i = 0; i != this.numberOfProperties; ++i) {
                            this.newProps[i] = added.getProperties().get(this.indexedPropertyNames[i]);
                            this.oldProps[i] = null;
                        }
                        this.ops.add(nodeKey, this.newProps);
                        change = null;
                        nodeKey = null;
                        this.clearPropertyBuffer();
                        continue;
                    }
                    if (!(nodeChange instanceof NodeRemoved)) continue;
                    this.ops.remove(nodeKey);
                    this.clearPropertyBuffer();
                }
                this.processProperties();
            }
        }

        private void processProperties() {
            if (this.hasNewProps) {
                if (this.hasOldProps) {
                    this.ops.change(this.nodeKey, this.newProps, this.oldProps);
                } else {
                    this.ops.add(this.nodeKey, this.newProps);
                }
                this.clearPropertyBuffer();
            } else if (this.hasOldProps) {
                this.ops.remove(this.nodeKey);
                this.clearPropertyBuffer();
            }
        }

        private void clearPropertyBuffer() {
            for (int i = 0; i != this.numberOfProperties; ++i) {
                this.newProps[i] = null;
                this.oldProps[i] = null;
            }
            this.hasNewProps = false;
            this.hasOldProps = false;
        }
    }

    @NotThreadSafe
    protected static class SinglePropertyIndexChangeSetListener
    extends IndexChangeSetListener {
        private final Name indexedPropertyName;
        private final SingleColumnIndexOperations ops;

        public SinglePropertyIndexChangeSetListener(String localProcessKey, NodeTypes.Supplier nodeTypesSupplier, Name nodeType, Name indexedPropertyName, SingleColumnIndexOperations ops) {
            super(localProcessKey, nodeTypesSupplier, nodeType);
            this.indexedPropertyName = indexedPropertyName;
            this.ops = ops;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notify(ChangeSet changeSet) {
            if (this.ops.start(changeSet.getWorkspaceName(), this.isLocal(changeSet))) {
                try {
                    for (Change change : changeSet) {
                        AbstractNodeChange nodeChange;
                        if (!(change instanceof AbstractNodeChange) || !this.acceptableNodeType(nodeChange = (AbstractNodeChange)change)) continue;
                        if (nodeChange instanceof AbstractPropertyChange) {
                            AbstractPropertyChange propChange = (AbstractPropertyChange)nodeChange;
                            Property property = propChange.getProperty();
                            if (!this.indexedPropertyName.equals(property.getName())) continue;
                            if (nodeChange instanceof PropertyAdded) {
                                this.ops.add(propChange.getKey(), property);
                                continue;
                            }
                            if (nodeChange instanceof PropertyChanged) {
                                PropertyChanged changedProperty = (PropertyChanged)nodeChange;
                                this.ops.change(propChange.getKey(), property, changedProperty.getOldProperty());
                                continue;
                            }
                            if (!(nodeChange instanceof PropertyRemoved)) continue;
                            this.ops.remove(propChange.getKey());
                            continue;
                        }
                        if (nodeChange instanceof NodeAdded) {
                            NodeAdded added = (NodeAdded)nodeChange;
                            Property addedProperty = added.getProperties().get(this.indexedPropertyName);
                            if (addedProperty == null) continue;
                            this.ops.add(nodeChange.getKey(), addedProperty);
                            continue;
                        }
                        if (!(nodeChange instanceof NodeRemoved)) continue;
                        this.ops.remove(nodeChange.getKey());
                    }
                }
                finally {
                    this.ops.end();
                }
            }
        }
    }

    @NotThreadSafe
    protected static abstract class IndexChangeSetListener
    implements ChangeSetListener {
        private final String localProcessKey;
        protected final NodeTypes.Supplier nodeTypesSupplier;
        private final Name nodeType;

        protected IndexChangeSetListener(String localProcessKey, NodeTypes.Supplier nodeTypesSupplier, Name nodeType) {
            this.localProcessKey = localProcessKey;
            this.nodeTypesSupplier = nodeTypesSupplier;
            this.nodeType = nodeType;
        }

        protected final boolean isLocal(ChangeSet changeSet) {
            return this.localProcessKey.equals(changeSet.getProcessKey());
        }

        protected final boolean acceptableNodeType(AbstractNodeChange change) {
            return change.isType(this.nodeType, this.nodeTypesSupplier.getNodeTypes());
        }
    }

    protected static interface NodeTypePredicate {
        public boolean accept(AbstractNodeChange var1);
    }

    @NotThreadSafe
    public static interface MultiColumnIndexOperations {
        public boolean start(String var1, boolean var2);

        public void add(NodeKey var1, Property[] var2);

        public void change(NodeKey var1, Property[] var2, Property[] var3);

        public void remove(NodeKey var1);

        public void end();
    }

    @NotThreadSafe
    public static interface SingleColumnIndexOperations {
        public boolean start(String var1, boolean var2);

        public void add(NodeKey var1, Property var2);

        public void change(NodeKey var1, Property var2, Property var3);

        public void remove(NodeKey var1);

        public void end();
    }
}

