/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IntroSorter;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.ImmutableShardRouting;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.FailedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.StartedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.base.Predicate;
import org.elasticsearch.common.collect.IdentityHashSet;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.settings.NodeSettingsService;

public class BalancedShardsAllocator
extends AbstractComponent
implements ShardsAllocator {
    public static final String SETTING_THRESHOLD = "cluster.routing.allocation.balance.threshold";
    public static final String SETTING_INDEX_BALANCE_FACTOR = "cluster.routing.allocation.balance.index";
    public static final String SETTING_SHARD_BALANCE_FACTOR = "cluster.routing.allocation.balance.shard";
    public static final String SETTING_PRIMARY_BALANCE_FACTOR = "cluster.routing.allocation.balance.primary";
    private static final float DEFAULT_INDEX_BALANCE_FACTOR = 0.55f;
    private static final float DEFAULT_SHARD_BALANCE_FACTOR = 0.45f;
    @Deprecated
    private static final float DEFAULT_PRIMARY_BALANCE_FACTOR = 0.0f;
    private volatile WeightFunction weightFunction = new WeightFunction(0.55f, 0.45f, 0.0f);
    private volatile float threshold = 1.0f;

    public BalancedShardsAllocator(Settings settings) {
        this(settings, new NodeSettingsService(settings));
    }

    @Inject
    public BalancedShardsAllocator(Settings settings, NodeSettingsService nodeSettingsService) {
        super(settings);
        ApplySettings applySettings = new ApplySettings();
        applySettings.onRefreshSettings(settings);
        nodeSettingsService.addListener(applySettings);
    }

    @Override
    public void applyStartedShards(StartedRerouteAllocation allocation) {
    }

    @Override
    public void applyFailedShards(FailedRerouteAllocation allocation) {
    }

    @Override
    public boolean allocateUnassigned(RoutingAllocation allocation) {
        return this.rebalance(allocation);
    }

    @Override
    public boolean rebalance(RoutingAllocation allocation) {
        Balancer balancer = new Balancer(this.logger, allocation, this.weightFunction, this.threshold);
        return balancer.balance();
    }

    @Override
    public boolean move(MutableShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        Balancer balancer = new Balancer(this.logger, allocation, this.weightFunction, this.threshold);
        return balancer.move(shardRouting, node);
    }

    public float getThreshold() {
        return this.threshold;
    }

    public float getIndexBalance() {
        return this.weightFunction.indexBalance;
    }

    public float getPrimaryBalance() {
        return this.weightFunction.primaryBalance;
    }

    public float getShardBalance() {
        return this.weightFunction.shardBalance;
    }

    static final class NodeSorter
    extends IntroSorter {
        final ModelNode[] modelNodes;
        final float[] weights;
        private final WeightFunction function;
        private String index;
        private final Balancer balancer;
        private float pivotWeight;

        public NodeSorter(ModelNode[] modelNodes, WeightFunction function, Balancer balancer) {
            this.function = function;
            this.balancer = balancer;
            this.modelNodes = modelNodes;
            this.weights = new float[modelNodes.length];
        }

        public void reset(Operation operation, String index) {
            this.index = index;
            for (int i = 0; i < this.weights.length; ++i) {
                this.weights[i] = this.weight(operation, this.modelNodes[i]);
            }
            this.sort(0, this.modelNodes.length);
        }

        public float weight(Operation operation, ModelNode node) {
            return this.function.weight(operation, this.balancer, node, this.index);
        }

        protected void swap(int i, int j) {
            ModelNode tmpNode = this.modelNodes[i];
            this.modelNodes[i] = this.modelNodes[j];
            this.modelNodes[j] = tmpNode;
            float tmpWeight = this.weights[i];
            this.weights[i] = this.weights[j];
            this.weights[j] = tmpWeight;
        }

        protected int compare(int i, int j) {
            return Float.compare(this.weights[i], this.weights[j]);
        }

        protected void setPivot(int i) {
            this.pivotWeight = this.weights[i];
        }

        protected int comparePivot(int j) {
            return Float.compare(this.pivotWeight, this.weights[j]);
        }

        public float delta() {
            return this.weights[this.weights.length - 1] - this.weights[0];
        }
    }

    static final class ModelIndex {
        private final String id;
        private final Map<MutableShardRouting, Decision> shards = new HashMap<MutableShardRouting, Decision>();
        private int numPrimaries = -1;
        private int highestPrimary = -1;

        public ModelIndex(String id) {
            this.id = id;
        }

        public int highestPrimary() {
            if (this.highestPrimary == -1) {
                int maxId = -1;
                for (MutableShardRouting shard : this.shards.keySet()) {
                    if (!shard.primary()) continue;
                    maxId = Math.max(maxId, shard.id());
                }
                this.highestPrimary = maxId;
                return this.highestPrimary;
            }
            return this.highestPrimary;
        }

        public String getIndexId() {
            return this.id;
        }

        public Decision getDecicion(MutableShardRouting shard) {
            return this.shards.get(shard);
        }

        public int numShards() {
            return this.shards.size();
        }

        public Collection<MutableShardRouting> getAllShards() {
            return this.shards.keySet();
        }

        public int numPrimaries() {
            if (this.numPrimaries == -1) {
                int num = 0;
                for (MutableShardRouting shard : this.shards.keySet()) {
                    if (!shard.primary()) continue;
                    ++num;
                }
                this.numPrimaries = num;
                return this.numPrimaries;
            }
            return this.numPrimaries;
        }

        public Decision removeShard(MutableShardRouting shard) {
            this.numPrimaries = -1;
            this.highestPrimary = -1;
            return this.shards.remove(shard);
        }

        public void addShard(MutableShardRouting shard, Decision decision) {
            this.numPrimaries = -1;
            this.highestPrimary = -1;
            assert (decision != null);
            assert (!this.shards.containsKey(shard)) : "Shard already allocated on current node: " + this.shards.get(shard) + " " + shard;
            this.shards.put(shard, decision);
        }

        public boolean containsShard(MutableShardRouting shard) {
            return this.shards.containsKey(shard);
        }
    }

    static class ModelNode
    implements Iterable<ModelIndex> {
        private final String id;
        private final Map<String, ModelIndex> indices = new HashMap<String, ModelIndex>();
        private int numShards = -1;
        private int numPrimaries = -1;

        public ModelNode(String id) {
            this.id = id;
        }

        public ModelIndex getIndex(String indexId) {
            return this.indices.get(indexId);
        }

        public String getNodeId() {
            return this.id;
        }

        public int numShards() {
            if (this.numShards == -1) {
                int sum = 0;
                for (ModelIndex index : this.indices.values()) {
                    sum += index.numShards();
                }
                this.numShards = sum;
            }
            return this.numShards;
        }

        public int numShards(String idx) {
            ModelIndex index = this.indices.get(idx);
            return index == null ? 0 : index.numShards();
        }

        public int numPrimaries(String idx) {
            ModelIndex index = this.indices.get(idx);
            return index == null ? 0 : index.numPrimaries();
        }

        public int numPrimaries() {
            if (this.numPrimaries == -1) {
                int sum = 0;
                for (ModelIndex index : this.indices.values()) {
                    sum += index.numPrimaries();
                }
                this.numPrimaries = sum;
            }
            return this.numPrimaries;
        }

        public Collection<MutableShardRouting> shards() {
            ArrayList<MutableShardRouting> result = new ArrayList<MutableShardRouting>();
            for (ModelIndex index : this.indices.values()) {
                result.addAll(index.getAllShards());
            }
            return result;
        }

        public int highestPrimary(String index) {
            ModelIndex idx = this.indices.get(index);
            if (idx != null) {
                return idx.highestPrimary();
            }
            return -1;
        }

        public void addShard(MutableShardRouting shard, Decision decision) {
            this.numShards = -1;
            this.numPrimaries = -1;
            ModelIndex index = this.indices.get(shard.index());
            if (index == null) {
                index = new ModelIndex(shard.index());
                this.indices.put(index.getIndexId(), index);
            }
            index.addShard(shard, decision);
        }

        public Decision removeShard(MutableShardRouting shard) {
            this.numShards = -1;
            this.numPrimaries = -1;
            ModelIndex index = this.indices.get(shard.index());
            Decision removed = null;
            if (index != null && (removed = index.removeShard(shard)) != null && index.numShards() == 0) {
                this.indices.remove(shard.index());
            }
            return removed;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Node(").append(this.id).append(")");
            return sb.toString();
        }

        @Override
        public Iterator<ModelIndex> iterator() {
            return this.indices.values().iterator();
        }

        public boolean containsShard(MutableShardRouting shard) {
            ModelIndex index = this.getIndex(shard.getIndex());
            return index == null ? false : index.containsShard(shard);
        }
    }

    public static class Balancer {
        private final ESLogger logger;
        private final Map<String, ModelNode> nodes = new HashMap<String, ModelNode>();
        private final HashSet<String> indices = new HashSet();
        private final RoutingAllocation allocation;
        private final RoutingNodes routingNodes;
        private final WeightFunction weight;
        private final float threshold;
        private final MetaData metaData;
        private final Predicate<MutableShardRouting> assignedFilter = new Predicate<MutableShardRouting>(){

            @Override
            public boolean apply(MutableShardRouting input) {
                return input.assignedToNode();
            }
        };

        public Balancer(ESLogger logger, RoutingAllocation allocation, WeightFunction weight, float threshold) {
            this.logger = logger;
            this.allocation = allocation;
            this.weight = weight;
            this.threshold = threshold;
            this.routingNodes = allocation.routingNodes();
            for (RoutingNode node : this.routingNodes) {
                this.nodes.put(node.nodeId(), new ModelNode(node.nodeId()));
            }
            this.metaData = this.routingNodes.metaData();
        }

        private ModelNode[] nodesArray() {
            return this.nodes.values().toArray(new ModelNode[this.nodes.size()]);
        }

        public float avgShardsPerNode(String index) {
            return (float)this.metaData.index(index).totalNumberOfShards() / (float)this.nodes.size();
        }

        public float avgShardsPerNode() {
            return (float)this.metaData.totalNumberOfShards() / (float)this.nodes.size();
        }

        public float avgPrimariesPerNode() {
            return (float)this.metaData.numberOfShards() / (float)this.nodes.size();
        }

        public float avgPrimariesPerNode(String index) {
            return (float)this.metaData.index(index).numberOfShards() / (float)this.nodes.size();
        }

        private NodeSorter newNodeSorter() {
            return new NodeSorter(this.nodesArray(), this.weight, this);
        }

        private boolean initialize(RoutingNodes routing, RoutingNodes.UnassignedShards unassigned) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Start distributing Shards", new Object[0]);
            }
            this.indices.addAll(this.allocation.routingTable().indicesRouting().keySet());
            this.buildModelFromAssigned(routing.shards(this.assignedFilter));
            return this.allocateUnassigned(unassigned, routing.ignoredUnassigned());
        }

        private static float absDelta(float lower, float higher) {
            assert (higher >= lower) : higher + " lt " + lower + " but was expected to be gte";
            return Math.abs(higher - lower);
        }

        private static boolean lessThan(float delta, float threshold) {
            return delta <= threshold + 0.001f;
        }

        public boolean balance() {
            RoutingNodes.UnassignedShards unassigned;
            boolean changed;
            if (this.nodes.isEmpty()) {
                return false;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Start balancing cluster", new Object[0]);
            }
            if (!(changed = this.initialize(this.routingNodes, unassigned = this.routingNodes.unassigned().transactionBegin()))) {
                NodeSorter sorter = this.newNodeSorter();
                if (this.nodes.size() > 1) {
                    block0: for (String index : this.buildWeightOrderedIndidces(Operation.BALANCE, sorter)) {
                        sorter.reset(Operation.BALANCE, index);
                        float[] weights = sorter.weights;
                        ModelNode[] modelNodes = sorter.modelNodes;
                        int lowIdx = 0;
                        int highIdx = weights.length - 1;
                        while (true) {
                            ModelNode minNode = modelNodes[lowIdx];
                            ModelNode maxNode = modelNodes[highIdx];
                            if (maxNode.numShards(index) > 0) {
                                float delta = Balancer.absDelta(weights[lowIdx], weights[highIdx]);
                                if (Balancer.lessThan(delta, this.threshold)) {
                                    if (lowIdx <= 0 || highIdx - 1 <= 0 || !(Balancer.absDelta(weights[0], weights[highIdx - 1]) > this.threshold)) {
                                        if (!this.logger.isTraceEnabled()) continue block0;
                                        this.logger.trace("Stop balancing index [{}]  min_node [{}] weight: [{}]  max_node [{}] weight: [{}]  delta: [{}]", index, maxNode.getNodeId(), Float.valueOf(weights[highIdx]), minNode.getNodeId(), Float.valueOf(weights[lowIdx]), Float.valueOf(delta));
                                        continue block0;
                                    }
                                } else {
                                    if (this.logger.isTraceEnabled()) {
                                        this.logger.trace("Balancing from node [{}] weight: [{}] to node [{}] weight: [{}]  delta: [{}]", maxNode.getNodeId(), Float.valueOf(weights[highIdx]), minNode.getNodeId(), Float.valueOf(weights[lowIdx]), Float.valueOf(delta));
                                    }
                                    if (this.tryRelocateShard(Operation.BALANCE, minNode, maxNode, index, delta)) {
                                        weights[lowIdx] = sorter.weight(Operation.BALANCE, modelNodes[lowIdx]);
                                        weights[highIdx] = sorter.weight(Operation.BALANCE, modelNodes[highIdx]);
                                        sorter.sort(0, weights.length);
                                        lowIdx = 0;
                                        highIdx = weights.length - 1;
                                        changed = true;
                                        continue;
                                    }
                                }
                            }
                            if (lowIdx < highIdx - 1) {
                                ++lowIdx;
                                continue;
                            }
                            if (lowIdx <= 0) continue block0;
                            lowIdx = 0;
                            --highIdx;
                        }
                    }
                }
            }
            this.routingNodes.unassigned().transactionEnd(unassigned);
            return changed;
        }

        private String[] buildWeightOrderedIndidces(Operation operation, NodeSorter sorter) {
            final String[] indices = this.indices.toArray(new String[this.indices.size()]);
            final float[] deltas = new float[indices.length];
            for (int i = 0; i < deltas.length; ++i) {
                sorter.reset(operation, indices[i]);
                deltas[i] = sorter.delta();
            }
            new IntroSorter(){
                float pivotWeight;

                protected void swap(int i, int j) {
                    String tmpIdx = indices[i];
                    indices[i] = indices[j];
                    indices[j] = tmpIdx;
                    float tmpDelta = deltas[i];
                    deltas[i] = deltas[j];
                    deltas[j] = tmpDelta;
                }

                protected int compare(int i, int j) {
                    return Float.compare(deltas[j], deltas[i]);
                }

                protected void setPivot(int i) {
                    this.pivotWeight = deltas[i];
                }

                protected int comparePivot(int j) {
                    return Float.compare(deltas[j], this.pivotWeight);
                }
            }.sort(0, deltas.length);
            return indices;
        }

        public boolean move(MutableShardRouting shard, RoutingNode node) {
            RoutingNodes.UnassignedShards unassigned;
            boolean changed;
            if (this.nodes.isEmpty() || !shard.started()) {
                return false;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Try moving shard [{}] from [{}]", shard, node);
            }
            if (!(changed = this.initialize(this.routingNodes, unassigned = this.routingNodes.unassigned().transactionBegin()))) {
                ModelNode sourceNode = this.nodes.get(node.nodeId());
                assert (sourceNode != null);
                NodeSorter sorter = this.newNodeSorter();
                sorter.reset(Operation.MOVE, shard.getIndex());
                ModelNode[] nodes = sorter.modelNodes;
                assert (sourceNode.containsShard(shard));
                for (ModelNode currentNode : nodes) {
                    if (currentNode.getNodeId().equals(node.nodeId())) continue;
                    RoutingNode target = this.routingNodes.node(currentNode.getNodeId());
                    Decision decision = this.allocation.deciders().canAllocate(shard, target, this.allocation);
                    if (decision.type() != Decision.Type.YES) continue;
                    sourceNode.removeShard(shard);
                    MutableShardRouting initializingShard = new MutableShardRouting(shard.index(), shard.id(), currentNode.getNodeId(), shard.currentNodeId(), shard.restoreSource(), shard.primary(), ShardRoutingState.INITIALIZING, shard.version() + 1L);
                    currentNode.addShard(initializingShard, decision);
                    this.routingNodes.assign(initializingShard, target.nodeId());
                    this.routingNodes.relocate(shard, target.nodeId());
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("Moved shard [{}] to node [{}]", shard, currentNode.getNodeId());
                    }
                    changed = true;
                    break;
                }
            }
            this.routingNodes.unassigned().transactionEnd(unassigned);
            return changed;
        }

        private void buildModelFromAssigned(Iterable<MutableShardRouting> shards) {
            for (MutableShardRouting shard : shards) {
                assert (shard.assignedToNode());
                if (shard.state() == ShardRoutingState.RELOCATING) continue;
                ModelNode node = this.nodes.get(shard.currentNodeId());
                assert (node != null);
                node.addShard(shard, Decision.single(Decision.Type.YES, "Already allocated on node", node.getNodeId(), new Object[0]));
                if (!this.logger.isTraceEnabled()) continue;
                this.logger.trace("Assigned shard [{}] to node [{}]", shard, node.getNodeId());
            }
        }

        private boolean allocateUnassigned(RoutingNodes.UnassignedShards unassigned, List<MutableShardRouting> ignoredUnassigned) {
            assert (!this.nodes.isEmpty());
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Start allocating unassigned shards", new Object[0]);
            }
            if (unassigned.isEmpty()) {
                return false;
            }
            boolean changed = false;
            AllocationDeciders deciders = this.allocation.deciders();
            Comparator<MutableShardRouting> comparator = new Comparator<MutableShardRouting>(){

                @Override
                public int compare(MutableShardRouting o1, MutableShardRouting o2) {
                    if (o1.primary() ^ o2.primary()) {
                        return o1.primary() ? -1 : (o2.primary() ? 1 : 0);
                    }
                    int indexCmp = o1.index().compareTo(o2.index());
                    if (indexCmp == 0) {
                        return o1.getId() - o2.getId();
                    }
                    return indexCmp;
                }
            };
            Object[] primary = unassigned.drain();
            Object[] secondary = new MutableShardRouting[primary.length];
            int secondaryLength = 0;
            int primaryLength = primary.length;
            ArrayUtil.timSort((Object[])primary, (Comparator)comparator);
            IdentityHashSet<ModelNode> throttledNodes = new IdentityHashSet<ModelNode>();
            do {
                for (int i = 0; i < primaryLength; ++i) {
                    Object shard = primary[i];
                    if (!((ImmutableShardRouting)shard).primary()) {
                        boolean drop;
                        boolean bl = drop = deciders.canAllocate((ShardRouting)shard, this.allocation).type() == Decision.Type.NO;
                        if (drop) {
                            ignoredUnassigned.add((MutableShardRouting)shard);
                            while (i < primaryLength - 1 && comparator.compare((MutableShardRouting)primary[i], (MutableShardRouting)primary[i + 1]) == 0) {
                                ignoredUnassigned.add((MutableShardRouting)primary[++i]);
                            }
                            continue;
                        }
                        while (i < primaryLength - 1 && comparator.compare((MutableShardRouting)primary[i], (MutableShardRouting)primary[i + 1]) == 0) {
                            secondary[secondaryLength++] = primary[++i];
                        }
                    }
                    assert (!((ImmutableShardRouting)shard).assignedToNode()) : shard;
                    float minWeight = Float.POSITIVE_INFINITY;
                    ModelNode minNode = null;
                    Decision decision = null;
                    if (throttledNodes.size() < this.nodes.size()) {
                        for (ModelNode node : this.nodes.values()) {
                            Decision currentDecision;
                            if (throttledNodes.contains(node) || node.containsShard((MutableShardRouting)shard)) continue;
                            node.addShard((MutableShardRouting)shard, Decision.ALWAYS);
                            float currentWeight = this.weight.weight(Operation.ALLOCATE, this, node, ((ImmutableShardRouting)shard).index());
                            Decision removed = node.removeShard((MutableShardRouting)shard);
                            assert (removed != null);
                            if (!(currentWeight <= minWeight) || (currentDecision = deciders.canAllocate((ShardRouting)shard, this.routingNodes.node(node.getNodeId()), this.allocation)).type() != Decision.Type.YES && currentDecision.type() != Decision.Type.THROTTLE) continue;
                            if (currentWeight == minWeight) {
                                if (currentDecision.type() == decision.type()) {
                                    int repId = ((ImmutableShardRouting)shard).id();
                                    int nodeHigh = node.highestPrimary(((ImmutableShardRouting)shard).index());
                                    int minNodeHigh = minNode.highestPrimary(((ImmutableShardRouting)shard).index());
                                    if (!((nodeHigh > repId && minNodeHigh > repId || nodeHigh < repId && minNodeHigh < repId) && nodeHigh < minNodeHigh) && (nodeHigh <= minNodeHigh || nodeHigh <= repId || minNodeHigh >= repId)) continue;
                                    minNode = node;
                                    minWeight = currentWeight;
                                    decision = currentDecision;
                                } else if (currentDecision.type() != Decision.Type.YES) continue;
                            }
                            minNode = node;
                            minWeight = currentWeight;
                            decision = currentDecision;
                        }
                    }
                    assert (decision != null && minNode != null || decision == null && minNode == null);
                    if (minNode != null) {
                        minNode.addShard((MutableShardRouting)shard, decision);
                        if (decision.type() == Decision.Type.YES) {
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace("Assigned shard [{}] to [{}]", shard, minNode.getNodeId());
                            }
                            this.routingNodes.assign((MutableShardRouting)shard, this.routingNodes.node(minNode.getNodeId()).nodeId());
                            changed = true;
                            continue;
                        }
                        RoutingNode node = this.routingNodes.node(minNode.getNodeId());
                        if (deciders.canAllocate(node, this.allocation).type() != Decision.Type.YES) {
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace("Can not allocate on node [{}] remove from round decision [{}]", new Object[]{node, decision.type()});
                            }
                            throttledNodes.add(minNode);
                        }
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("No eligable node found to assign shard [{}] decision [{}]", new Object[]{shard, decision.type()});
                        }
                    } else if (this.logger.isTraceEnabled()) {
                        this.logger.trace("No Node found to assign shard [{}]", shard);
                    }
                    ignoredUnassigned.add((MutableShardRouting)shard);
                    if (((ImmutableShardRouting)shard).primary()) continue;
                    while (secondaryLength > 0 && comparator.compare((MutableShardRouting)shard, (MutableShardRouting)secondary[secondaryLength - 1]) == 0) {
                        ignoredUnassigned.add((MutableShardRouting)secondary[--secondaryLength]);
                    }
                }
                primaryLength = secondaryLength;
                Object[] tmp = primary;
                primary = secondary;
                secondary = tmp;
                secondaryLength = 0;
            } while (primaryLength > 0);
            return changed;
        }

        private boolean tryRelocateShard(Operation operation, ModelNode minNode, ModelNode maxNode, String idx, float minCost) {
            ModelIndex index = maxNode.getIndex(idx);
            Decision decision = null;
            if (index != null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Try relocating shard for index index [{}] from node [{}] to node [{}]", idx, maxNode.getNodeId(), minNode.getNodeId());
                }
                RoutingNode node = this.routingNodes.node(minNode.getNodeId());
                ImmutableShardRouting candidate = null;
                AllocationDeciders deciders = this.allocation.deciders();
                ArrayList<MutableShardRouting> shards = new ArrayList<MutableShardRouting>(index.getAllShards());
                for (MutableShardRouting shard : shards) {
                    Decision srcDecision;
                    if (!shard.started()) continue;
                    Decision allocationDecision = deciders.canAllocate(shard, node, this.allocation);
                    Decision rebalanceDecision = deciders.canRebalance(shard, this.allocation);
                    if (allocationDecision.type() != Decision.Type.YES && allocationDecision.type() != Decision.Type.THROTTLE || rebalanceDecision.type() != Decision.Type.YES && rebalanceDecision.type() != Decision.Type.THROTTLE || (srcDecision = maxNode.removeShard(shard)) == null) continue;
                    minNode.addShard(shard, srcDecision);
                    float delta = this.weight.weight(operation, this, minNode, idx) - this.weight.weight(operation, this, maxNode, idx);
                    if (delta < minCost || candidate != null && delta == minCost && candidate.id() > shard.id()) {
                        minCost = delta;
                        candidate = shard;
                        decision = new Decision.Multi().add(allocationDecision).add(rebalanceDecision);
                    }
                    minNode.removeShard(shard);
                    maxNode.addShard(shard, srcDecision);
                }
                if (candidate != null) {
                    maxNode.removeShard((MutableShardRouting)candidate);
                    minNode.addShard((MutableShardRouting)candidate, decision);
                    if (decision.type() == Decision.Type.YES) {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("Relocate shard [{}] from node [{}] to node [{}]", candidate, maxNode.getNodeId(), minNode.getNodeId());
                        }
                        if (candidate.started()) {
                            RoutingNode lowRoutingNode = this.routingNodes.node(minNode.getNodeId());
                            this.routingNodes.assign(new MutableShardRouting(candidate.index(), candidate.id(), lowRoutingNode.nodeId(), candidate.currentNodeId(), candidate.restoreSource(), candidate.primary(), ShardRoutingState.INITIALIZING, candidate.version() + 1L), lowRoutingNode.nodeId());
                            this.routingNodes.relocate((MutableShardRouting)candidate, lowRoutingNode.nodeId());
                        } else {
                            assert (candidate.unassigned());
                            this.routingNodes.assign((MutableShardRouting)candidate, this.routingNodes.node(minNode.getNodeId()).nodeId());
                        }
                        return true;
                    }
                }
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Couldn't find shard to relocate from node [{}] to node [{}] allocation decision [{}]", maxNode.getNodeId(), minNode.getNodeId(), decision == null ? "NO" : decision.type().name());
            }
            return false;
        }
    }

    public static enum Operation {
        BALANCE,
        ALLOCATE,
        MOVE;

    }

    public static class WeightFunction {
        private final float indexBalance;
        private final float shardBalance;
        private final float primaryBalance;
        private final float[] theta;

        public WeightFunction(float indexBalance, float shardBalance, float primaryBalance) {
            float sum = indexBalance + shardBalance + primaryBalance;
            if (sum <= 0.0f) {
                throw new ElasticsearchIllegalArgumentException("Balance factors must sum to a value > 0 but was: " + sum);
            }
            this.theta = new float[]{shardBalance / sum, indexBalance / sum, primaryBalance / sum};
            this.indexBalance = indexBalance;
            this.shardBalance = shardBalance;
            this.primaryBalance = primaryBalance;
        }

        public float weight(Operation operation, Balancer balancer, ModelNode node, String index) {
            float weightShard = (float)node.numShards() - balancer.avgShardsPerNode();
            float weightIndex = (float)node.numShards(index) - balancer.avgShardsPerNode(index);
            float weightPrimary = (float)node.numPrimaries() - balancer.avgPrimariesPerNode();
            return this.theta[0] * weightShard + this.theta[1] * weightIndex + this.theta[2] * weightPrimary;
        }
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            float indexBalance = settings.getAsFloat(BalancedShardsAllocator.SETTING_INDEX_BALANCE_FACTOR, Float.valueOf(BalancedShardsAllocator.this.weightFunction.indexBalance)).floatValue();
            float shardBalance = settings.getAsFloat(BalancedShardsAllocator.SETTING_SHARD_BALANCE_FACTOR, Float.valueOf(BalancedShardsAllocator.this.weightFunction.shardBalance)).floatValue();
            float primaryBalance = settings.getAsFloat(BalancedShardsAllocator.SETTING_PRIMARY_BALANCE_FACTOR, Float.valueOf(BalancedShardsAllocator.this.weightFunction.primaryBalance)).floatValue();
            float threshold = settings.getAsFloat(BalancedShardsAllocator.SETTING_THRESHOLD, Float.valueOf(BalancedShardsAllocator.this.threshold)).floatValue();
            if (threshold <= 0.0f) {
                throw new ElasticsearchIllegalArgumentException("threshold must be greater than 0.0f but was: " + threshold);
            }
            BalancedShardsAllocator.this.threshold = threshold;
            BalancedShardsAllocator.this.weightFunction = new WeightFunction(indexBalance, shardBalance, primaryBalance);
        }
    }
}

