/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocValues;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.plain.BytesBinaryDVAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.MultiValueMode;

public class BytesBinaryDVIndexFieldData
extends DocValuesIndexFieldData
implements IndexFieldData<BytesBinaryDVAtomicFieldData> {
    public BytesBinaryDVIndexFieldData(Index index, FieldMapper.Names fieldNames, FieldDataType fieldDataType) {
        super(index, fieldNames, fieldDataType);
    }

    @Override
    public final IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        throw new ElasticsearchIllegalArgumentException("can't sort on binary field");
    }

    @Override
    public BytesBinaryDVAtomicFieldData load(AtomicReaderContext context) {
        try {
            return new BytesBinaryDVAtomicFieldData(DocValues.getBinary((AtomicReader)context.reader(), (String)this.fieldNames.indexName()));
        }
        catch (IOException e) {
            throw new ElasticsearchIllegalStateException("Cannot load doc values", e);
        }
    }

    @Override
    public BytesBinaryDVAtomicFieldData loadDirect(AtomicReaderContext context) throws Exception {
        return this.load(context);
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<?> build(Index index, Settings indexSettings, FieldMapper<?> mapper, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            FieldMapper.Names fieldNames = mapper.names();
            return new BytesBinaryDVIndexFieldData(index, fieldNames, mapper.fieldDataType());
        }
    }
}

