/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.get;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.uid.Versions;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.fieldvisitor.CustomFieldsVisitor;
import org.elasticsearch.index.fieldvisitor.FieldsVisitor;
import org.elasticsearch.index.fieldvisitor.JustSourceFieldsVisitor;
import org.elasticsearch.index.get.GetField;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.internal.SizeFieldMapper;
import org.elasticsearch.index.mapper.internal.SourceFieldMapper;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.fetch.source.FetchSourceContext;
import org.elasticsearch.search.lookup.SearchLookup;

public class ShardGetService
extends AbstractIndexShardComponent {
    private final ScriptService scriptService;
    private final MapperService mapperService;
    private final IndexFieldDataService fieldDataService;
    private IndexShard indexShard;
    private final MeanMetric existsMetric = new MeanMetric();
    private final MeanMetric missingMetric = new MeanMetric();
    private final CounterMetric currentMetric = new CounterMetric();

    @Inject
    public ShardGetService(ShardId shardId, @IndexSettings Settings indexSettings, ScriptService scriptService, MapperService mapperService, IndexFieldDataService fieldDataService) {
        super(shardId, indexSettings);
        this.scriptService = scriptService;
        this.mapperService = mapperService;
        this.fieldDataService = fieldDataService;
    }

    public GetStats stats() {
        return new GetStats(this.existsMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.existsMetric.sum()), this.missingMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.missingMetric.sum()), this.currentMetric.count());
    }

    public ShardGetService setIndexShard(IndexShard indexShard) {
        this.indexShard = indexShard;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetResult get(String type, String id, String[] gFields, boolean realtime, long version, VersionType versionType, FetchSourceContext fetchSourceContext, boolean ignoreErrorsOnGeneratedFields) throws ElasticsearchException {
        this.currentMetric.inc();
        try {
            long now = System.nanoTime();
            GetResult getResult = this.innerGet(type, id, gFields, realtime, version, versionType, fetchSourceContext, ignoreErrorsOnGeneratedFields);
            if (getResult.isExists()) {
                this.existsMetric.inc(System.nanoTime() - now);
            } else {
                this.missingMetric.inc(System.nanoTime() - now);
            }
            GetResult getResult2 = getResult;
            return getResult2;
        }
        finally {
            this.currentMetric.dec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetResult get(Engine.GetResult engineGetResult, String id, String type, String[] fields, FetchSourceContext fetchSourceContext, boolean ignoreErrorsOnGeneratedFields) {
        if (!engineGetResult.exists()) {
            return new GetResult(this.shardId.index().name(), type, id, -1L, false, null, null);
        }
        this.currentMetric.inc();
        try {
            long now = System.nanoTime();
            DocumentMapper docMapper = this.mapperService.documentMapper(type);
            if (docMapper == null) {
                this.missingMetric.inc(System.nanoTime() - now);
                GetResult getResult = new GetResult(this.shardId.index().name(), type, id, -1L, false, null, null);
                return getResult;
            }
            GetResult getResult = this.innerGetLoadFromStoredFields(type, id, fields, fetchSourceContext = this.normalizeFetchSourceContent(fetchSourceContext, fields), engineGetResult, docMapper, ignoreErrorsOnGeneratedFields);
            if (getResult.isExists()) {
                this.existsMetric.inc(System.nanoTime() - now);
            } else {
                this.missingMetric.inc(System.nanoTime() - now);
            }
            GetResult getResult2 = getResult;
            return getResult2;
        }
        finally {
            this.currentMetric.dec();
        }
    }

    protected FetchSourceContext normalizeFetchSourceContent(@Nullable FetchSourceContext context, @Nullable String[] gFields) {
        if (context != null) {
            return context;
        }
        if (gFields == null) {
            return FetchSourceContext.FETCH_SOURCE;
        }
        for (String field : gFields) {
            if (!"_source".equals(field)) continue;
            return FetchSourceContext.FETCH_SOURCE;
        }
        return FetchSourceContext.DO_NOT_FETCH_SOURCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetResult innerGet(String type, String id, String[] gFields, boolean realtime, long version, VersionType versionType, FetchSourceContext fetchSourceContext, boolean ignoreErrorsOnGeneratedFields) throws ElasticsearchException {
        DocumentMapper docMapper;
        fetchSourceContext = this.normalizeFetchSourceContent(fetchSourceContext, gFields);
        boolean loadSource = gFields != null && gFields.length > 0 || fetchSourceContext.fetchSource();
        Engine.GetResult get = null;
        if (type == null || ((String)type).equals("_all")) {
            for (String string : this.mapperService.types()) {
                get = this.indexShard.get(new Engine.Get(realtime, new Term("_uid", Uid.createUidAsBytes(string, id))).loadSource(loadSource).version(version).versionType(versionType));
                if (get.exists()) {
                    type = string;
                    break;
                }
                get.release();
            }
            if (get == null) {
                return new GetResult(this.shardId.index().name(), (String)type, id, -1L, false, null, null);
            }
            if (!get.exists()) {
                return new GetResult(this.shardId.index().name(), (String)type, id, -1L, false, null, null);
            }
        } else {
            get = this.indexShard.get(new Engine.Get(realtime, new Term("_uid", Uid.createUidAsBytes((String)type, id))).loadSource(loadSource).version(version).versionType(versionType));
            if (!get.exists()) {
                get.release();
                return new GetResult(this.shardId.index().name(), (String)type, id, -1L, false, null, null);
            }
        }
        if ((docMapper = this.mapperService.documentMapper((String)type)) == null) {
            get.release();
            return new GetResult(this.shardId.index().name(), (String)type, id, -1L, false, null, null);
        }
        try {
            if (get.docIdAndVersion() != null) {
                GetResult getResult = this.innerGetLoadFromStoredFields((String)type, id, gFields, fetchSourceContext, get, docMapper, ignoreErrorsOnGeneratedFields);
                return getResult;
            }
            Translog.Source source = get.source();
            HashMap<String, GetField> fields = null;
            SearchLookup searchLookup = null;
            if (gFields != null && gFields.length > 0) {
                for (String field : gFields) {
                    if ("_source".equals(field)) continue;
                    List<Object> value = null;
                    if (field.equals("_routing") && docMapper.routingFieldMapper().fieldType().stored()) {
                        value = source.routing;
                    } else if (field.equals("_parent") && docMapper.parentFieldMapper().active() && docMapper.parentFieldMapper().fieldType().stored()) {
                        value = source.parent;
                    } else if (field.equals("_timestamp") && docMapper.timestampFieldMapper().fieldType().stored()) {
                        value = source.timestamp;
                    } else if (field.equals("_ttl") && docMapper.TTLFieldMapper().fieldType().stored()) {
                        if (source.ttl > 0L) {
                            value = docMapper.TTLFieldMapper().valueForSearch(source.timestamp + source.ttl);
                        }
                    } else if (field.equals("_size") && docMapper.rootMapper(SizeFieldMapper.class).fieldType().stored()) {
                        value = source.source.length();
                    } else {
                        List<Object> values;
                        FieldMapper<?> fieldMapper;
                        if (searchLookup == null) {
                            searchLookup = new SearchLookup(this.mapperService, this.fieldDataService, new String[]{type});
                            searchLookup.source().setNextSource(source.source);
                        }
                        if ((fieldMapper = docMapper.mappers().smartNameFieldMapper(field)) == null) {
                            if (docMapper.objectMappers().get(field) != null) {
                                throw new ElasticsearchIllegalArgumentException("field [" + field + "] isn't a leaf field");
                            }
                        } else if (this.shouldGetFromSource(ignoreErrorsOnGeneratedFields, docMapper, fieldMapper) && !(values = searchLookup.source().extractRawValues(field)).isEmpty()) {
                            for (int i = 0; i < values.size(); ++i) {
                                values.set(i, fieldMapper.valueForSearch(values.get(i)));
                            }
                            value = values;
                        }
                    }
                    if (value == null) continue;
                    if (fields == null) {
                        fields = Maps.newHashMapWithExpectedSize(2);
                    }
                    if (value instanceof List) {
                        fields.put(field, new GetField(field, value));
                        continue;
                    }
                    fields.put(field, new GetField(field, ImmutableList.of(value)));
                }
            }
            BytesReference sourceToBeReturned = null;
            SourceFieldMapper sourceFieldMapper = docMapper.sourceMapper();
            if (fetchSourceContext.fetchSource() && sourceFieldMapper.enabled()) {
                boolean sourceFetchFiltering;
                sourceToBeReturned = source.source;
                boolean sourceFieldFiltering = sourceFieldMapper.includes().length > 0 || sourceFieldMapper.excludes().length > 0;
                boolean bl = sourceFetchFiltering = fetchSourceContext.includes().length > 0 || fetchSourceContext.excludes().length > 0;
                if (fetchSourceContext.transformSource() || sourceFieldFiltering || sourceFetchFiltering) {
                    Tuple<XContentType, Map<String, Object>> typeMapTuple = XContentHelper.convertToMap(source.source, true);
                    XContentType sourceContentType = typeMapTuple.v1();
                    Map<String, Object> sourceAsMap = typeMapTuple.v2();
                    if (fetchSourceContext.transformSource()) {
                        sourceAsMap = docMapper.transformSourceAsMap(sourceAsMap);
                    }
                    if (sourceFieldFiltering) {
                        sourceAsMap = XContentMapValues.filter(sourceAsMap, sourceFieldMapper.includes(), sourceFieldMapper.excludes());
                    }
                    if (sourceFetchFiltering) {
                        sourceAsMap = XContentMapValues.filter(sourceAsMap, fetchSourceContext.includes(), fetchSourceContext.excludes());
                    }
                    try {
                        sourceToBeReturned = XContentFactory.contentBuilder(sourceContentType).map(sourceAsMap).bytes();
                    }
                    catch (IOException e) {
                        throw new ElasticsearchException("Failed to get type [" + (String)type + "] and id [" + id + "] with includes/excludes set", e);
                    }
                }
            }
            GetResult getResult = new GetResult(this.shardId.index().name(), (String)type, id, get.version(), get.exists(), sourceToBeReturned, fields);
            return getResult;
        }
        finally {
            get.release();
        }
    }

    protected boolean shouldGetFromSource(boolean ignoreErrorsOnGeneratedFields, DocumentMapper docMapper, FieldMapper<?> fieldMapper) {
        if (!fieldMapper.isGenerated()) {
            return docMapper.sourceMapper().enabled() || fieldMapper.fieldType().stored();
        }
        if (!fieldMapper.fieldType().stored()) {
            return false;
        }
        if (ignoreErrorsOnGeneratedFields) {
            return false;
        }
        throw new ElasticsearchException("Cannot access field " + fieldMapper.name() + " from transaction log. You can only get this field after refresh() has been called.");
    }

    private GetResult innerGetLoadFromStoredFields(String type, String id, String[] gFields, FetchSourceContext fetchSourceContext, Engine.GetResult get, DocumentMapper docMapper, boolean ignoreErrorsOnGeneratedFields) {
        HashMap<String, GetField> fields = null;
        BytesReference source = null;
        Versions.DocIdAndVersion docIdAndVersion = get.docIdAndVersion();
        FieldsVisitor fieldVisitor = ShardGetService.buildFieldsVisitors(gFields, fetchSourceContext);
        if (fieldVisitor != null) {
            try {
                docIdAndVersion.context.reader().document(docIdAndVersion.docId, (StoredFieldVisitor)fieldVisitor);
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to get type [" + type + "] and id [" + id + "]", e);
            }
            source = fieldVisitor.source();
            if (!fieldVisitor.fields().isEmpty()) {
                fieldVisitor.postProcess(docMapper);
                fields = new HashMap<String, GetField>(fieldVisitor.fields().size());
                for (Map.Entry<String, List<Object>> entry : fieldVisitor.fields().entrySet()) {
                    fields.put(entry.getKey(), new GetField(entry.getKey(), entry.getValue()));
                }
            }
        }
        if (gFields != null && gFields.length > 0) {
            SearchLookup searchLookup = null;
            for (String field : gFields) {
                List<Object> value = null;
                FieldMappers fieldMapper = docMapper.mappers().smartName(field);
                if (fieldMapper == null) {
                    if (docMapper.objectMappers().get(field) != null) {
                        throw new ElasticsearchIllegalArgumentException("field [" + field + "] isn't a leaf field");
                    }
                } else if (!fieldMapper.mapper().fieldType().stored() && !fieldMapper.mapper().isGenerated()) {
                    List<Object> values;
                    if (searchLookup == null) {
                        searchLookup = new SearchLookup(this.mapperService, this.fieldDataService, new String[]{type});
                        searchLookup.setNextReader(docIdAndVersion.context);
                        searchLookup.source().setNextSource(source);
                        searchLookup.setNextDocId(docIdAndVersion.docId);
                    }
                    if (!(values = searchLookup.source().extractRawValues(field)).isEmpty()) {
                        for (int i = 0; i < values.size(); ++i) {
                            values.set(i, fieldMapper.mapper().valueForSearch(values.get(i)));
                        }
                        value = values;
                    }
                }
                if (value == null) continue;
                if (fields == null) {
                    fields = Maps.newHashMapWithExpectedSize(2);
                }
                if (value instanceof List) {
                    fields.put(field, new GetField(field, value));
                    continue;
                }
                fields.put(field, new GetField(field, ImmutableList.of(value)));
            }
        }
        if (!fetchSourceContext.fetchSource()) {
            source = null;
        } else if (fetchSourceContext.transformSource() || fetchSourceContext.includes().length > 0 || fetchSourceContext.excludes().length > 0) {
            XContentType sourceContentType = null;
            Tuple<XContentType, Map<String, Object>> typeMapTuple = XContentHelper.convertToMap(source, true);
            sourceContentType = typeMapTuple.v1();
            Map<String, Object> sourceAsMap = typeMapTuple.v2();
            if (fetchSourceContext.transformSource()) {
                sourceAsMap = docMapper.transformSourceAsMap(sourceAsMap);
            }
            sourceAsMap = XContentMapValues.filter(sourceAsMap, fetchSourceContext.includes(), fetchSourceContext.excludes());
            try {
                source = XContentFactory.contentBuilder(sourceContentType).map(sourceAsMap).bytes();
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to get type [" + type + "] and id [" + id + "] with includes/excludes set", e);
            }
        }
        return new GetResult(this.shardId.index().name(), type, id, get.version(), get.exists(), source, fields);
    }

    private static FieldsVisitor buildFieldsVisitors(String[] fields, FetchSourceContext fetchSourceContext) {
        if (fields == null || fields.length == 0) {
            return fetchSourceContext.fetchSource() ? new JustSourceFieldsVisitor() : null;
        }
        return new CustomFieldsVisitor(Sets.newHashSet(fields), fetchSourceContext.fetchSource());
    }
}

