/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.rest.HasRestHeaders;
import org.elasticsearch.rest.RestStatus;

public abstract class RestResponse
implements HasRestHeaders {
    protected Map<String, List<String>> customHeaders;

    public abstract String contentType();

    public abstract boolean contentThreadSafe();

    public abstract BytesReference content();

    public abstract RestStatus status();

    public void addHeaders(Map<String, List<String>> headers) {
        if (this.customHeaders == null) {
            this.customHeaders = new HashMap<String, List<String>>(headers.size());
        }
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            List<String> values = this.customHeaders.get(entry.getKey());
            if (values == null) {
                values = Lists.newArrayList();
                this.customHeaders.put(entry.getKey(), values);
            }
            values.addAll((Collection<String>)entry.getValue());
        }
    }

    public void addHeader(String name, String value) {
        List<String> header;
        if (this.customHeaders == null) {
            this.customHeaders = new HashMap<String, List<String>>(2);
        }
        if ((header = this.customHeaders.get(name)) == null) {
            header = new ArrayList<String>();
            this.customHeaders.put(name, header);
        }
        header.add(value);
    }

    @Override
    @Nullable
    public Map<String, List<String>> getHeaders() {
        return this.customHeaders;
    }
}

