# NOTE: Please do not edit this file directly
# Create your custom reports in the 'ext' folder

paramDate = queryParameters.get('date') or ""
paramRange = queryParameters.get('range') or ""

REF_TMPL = '#/testspecifications/%s/report/xlt.TestRunEvents?runId=%s&date=%s&range=%s'
runs = testRuns.getTestRunsBetween(testRun.testSpecificationName, startDate.getTime(), endDate.getTime())

extraColumns = self.hasProperty('extraColumns') and self.getProperty('extraColumns') or []

def rowValues(run):
    return [ run.qualificationResult,
             { 'v': run.startTime.time, 'ref': REF_TMPL % (run.testSpecificationName, run.testRunId, paramDate, paramRange) },
             run.finished and (run.duration) or 'in progress'] + \
         [run.getParameter(col) for col in extraColumns]

resultHolder.setResult({
    'title':'Test runs',
    'description': 'The test runs performed in the period defined.',
    'header': [
        { 'name': '', 'kind': 'qualification'},
        { 'name': 'Start date', 'kind': 'date'},
        { 'name': 'Duration (s)', 'kind': 'duration'}
    ] + [ { 'name': str(col).title() } for col in extraColumns ],
    'body': [
        rowValues(run) for run in runs
    ]
})