/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.collection.ReadOnlyIterator;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.api.index.IndexColumnDefinition;
import org.modeshape.jcr.api.index.IndexDefinition;

@Immutable
final class RepositoryIndexDefinition
implements IndexDefinition {
    private static final Logger LOGGER = Logger.getLogger(RepositoryIndexDefinition.class);
    private final String name;
    private final String providerName;
    private final IndexDefinition.IndexKind kind;
    private final String nodeTypeName;
    private final String description;
    private final boolean synchronous;
    private final boolean enabled;
    private final List<IndexColumnDefinition> columnDefns;
    private final Map<String, IndexColumnDefinition> columnDefnsByName;
    private final Map<String, Object> extendedProperties;
    private final IndexDefinition.WorkspaceMatchRule workspaceRule;
    public static final String MATCH_ALL_WORKSPACES = "*";
    protected static final IndexDefinition.WorkspaceMatchRule MATCH_ALL_WORKSPACES_RULE = new MatchAllWorkspaces();

    public static IndexDefinition createFrom(IndexDefinition other) {
        return new RepositoryIndexDefinition(other.getName(), other.getProviderName(), other.getKind(), other.getNodeTypeName(), (Iterable<IndexColumnDefinition>)other, other.getIndexProperties(), other.getDescription(), other.isSynchronous(), other.isEnabled(), other.getWorkspaceMatchRule());
    }

    public static IndexDefinition createFrom(IndexDefinition other, boolean isEnabled) {
        return new RepositoryIndexDefinition(other.getName(), other.getProviderName(), other.getKind(), other.getNodeTypeName(), (Iterable<IndexColumnDefinition>)other, other.getIndexProperties(), other.getDescription(), other.isSynchronous(), isEnabled, other.getWorkspaceMatchRule());
    }

    RepositoryIndexDefinition(String name, String providerName, IndexDefinition.IndexKind kind, String nodeTypeName, Iterable<IndexColumnDefinition> columnDefns, Map<String, Object> extendedProperties, String description, boolean synchronous, boolean enabled, IndexDefinition.WorkspaceMatchRule workspaceRule) {
        assert (name != null);
        assert (providerName != null);
        assert (columnDefns != null);
        assert (extendedProperties != null);
        assert (workspaceRule != null);
        this.name = name;
        this.providerName = providerName;
        this.kind = kind;
        this.nodeTypeName = nodeTypeName != null ? nodeTypeName : JcrNtLexicon.BASE.getString();
        this.columnDefns = new ArrayList<IndexColumnDefinition>();
        this.extendedProperties = extendedProperties;
        this.description = description != null ? description : "";
        this.enabled = enabled;
        this.synchronous = synchronous;
        this.workspaceRule = workspaceRule;
        this.columnDefnsByName = new HashMap<String, IndexColumnDefinition>();
        for (IndexColumnDefinition columnDefn : columnDefns) {
            assert (columnDefn != null);
            this.columnDefns.add(columnDefn);
            this.columnDefnsByName.put(columnDefn.getPropertyName(), columnDefn);
        }
        assert (!this.columnDefns.isEmpty());
    }

    public String getName() {
        return this.name;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public IndexDefinition.IndexKind getKind() {
        return this.kind;
    }

    public String getNodeTypeName() {
        return this.nodeTypeName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean hasSingleColumn() {
        return this.columnDefns.size() == 1;
    }

    public int size() {
        return this.columnDefns.size();
    }

    public IndexColumnDefinition getColumnDefinition(int position) throws NoSuchElementException {
        return this.columnDefns.get(position);
    }

    public Object getIndexProperty(String propertyName) {
        return this.extendedProperties.get(propertyName);
    }

    public Map<String, Object> getIndexProperties() {
        return Collections.unmodifiableMap(this.extendedProperties);
    }

    public IndexDefinition.WorkspaceMatchRule getWorkspaceMatchRule() {
        return this.workspaceRule;
    }

    public Iterator<IndexColumnDefinition> iterator() {
        return ReadOnlyIterator.around(this.columnDefns.iterator());
    }

    public boolean appliesToProperty(String propertyName) {
        return this.columnDefnsByName.containsKey(propertyName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append('@').append(this.getProviderName());
        sb.append(" nodeType=").append(this.nodeTypeName);
        if (this.columnDefns.size() == 1) {
            sb.append(" column=");
        } else {
            sb.append(" columns=");
        }
        boolean first = true;
        for (IndexColumnDefinition col : this.columnDefns) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(col);
        }
        sb.append(" kind=").append(this.getKind());
        sb.append(" sync=").append(this.isSynchronous());
        sb.append(" workspaces=").append(this.workspaceRule);
        return sb.toString();
    }

    protected static IndexDefinition.WorkspaceMatchRule workspaceMatchRule(String ... workspaceNames) {
        if (workspaceNames == null || workspaceNames.length == 0) {
            return MATCH_ALL_WORKSPACES_RULE;
        }
        HashSet<String> names = new HashSet<String>();
        StringBuilder sb = new StringBuilder();
        for (String name : workspaceNames) {
            if ((name = name.trim()).length() == 0) continue;
            if (names.size() != 0) {
                sb.append(",");
            }
            names.add(name);
            sb.append(name);
        }
        if (!names.isEmpty()) {
            return new MultipleWorkspaceMatchRule(sb.toString(), names);
        }
        return MATCH_ALL_WORKSPACES_RULE;
    }

    public static IndexDefinition.WorkspaceMatchRule workspaceMatchRule(String rule) {
        if (rule == null) {
            return MATCH_ALL_WORKSPACES_RULE;
        }
        if ((rule = rule.trim()).length() == 0 || MATCH_ALL_WORKSPACES.equals(rule)) {
            return MATCH_ALL_WORKSPACES_RULE;
        }
        try {
            return new RegexWorkspaceMatchRule(rule, Pattern.compile(rule));
        }
        catch (PatternSyntaxException e) {
            LOGGER.debug("Unable to parse workspace rule '{0}' into regular expression", new Object[]{rule});
            try {
                String[] names = rule.split(",");
                HashSet<String> workspaceNames = new HashSet<String>();
                for (String name : names) {
                    if (name.trim().length() == 0) continue;
                    workspaceNames.add(name.trim());
                }
                if (!workspaceNames.isEmpty()) {
                    return new MultipleWorkspaceMatchRule(rule, workspaceNames);
                }
            }
            catch (PatternSyntaxException e2) {
                LOGGER.debug("Unable to parse workspace rule '{0}' into comma-separate list of workspace names", new Object[]{rule});
            }
            return new ExactWorkspaceMatchRule(rule);
        }
    }

    protected static class MultipleWorkspaceMatchRule
    implements IndexDefinition.WorkspaceMatchRule {
        private final String rule;
        private final Set<String> workspaceNames;

        protected MultipleWorkspaceMatchRule(String rule, Set<String> workspaceNames) {
            this.rule = rule;
            this.workspaceNames = workspaceNames;
        }

        public boolean usedInWorkspace(String workspaceName) {
            return this.workspaceNames.contains(workspaceName);
        }

        public String getDefinition() {
            return this.rule;
        }

        public String toString() {
            return this.getDefinition();
        }
    }

    protected static class ExactWorkspaceMatchRule
    implements IndexDefinition.WorkspaceMatchRule {
        private final String workspaceName;

        protected ExactWorkspaceMatchRule(String workspaceName) {
            this.workspaceName = workspaceName;
        }

        public boolean usedInWorkspace(String workspaceName) {
            return this.workspaceName.equals(workspaceName);
        }

        public String getDefinition() {
            return this.workspaceName;
        }

        public String toString() {
            return this.getDefinition();
        }
    }

    protected static class RegexWorkspaceMatchRule
    implements IndexDefinition.WorkspaceMatchRule {
        private final String rule;
        private final Pattern pattern;

        protected RegexWorkspaceMatchRule(String rule, Pattern pattern) {
            this.rule = rule;
            this.pattern = pattern;
        }

        public boolean usedInWorkspace(String workspaceName) {
            return this.pattern.matcher(workspaceName).matches();
        }

        public String getDefinition() {
            return this.rule;
        }

        public String toString() {
            return this.getDefinition();
        }
    }

    protected static class MatchAllWorkspaces
    implements IndexDefinition.WorkspaceMatchRule {
        protected MatchAllWorkspaces() {
        }

        public boolean usedInWorkspace(String workspaceName) {
            return true;
        }

        public String getDefinition() {
            return RepositoryIndexDefinition.MATCH_ALL_WORKSPACES;
        }

        public String toString() {
            return this.getDefinition();
        }
    }
}

