/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.engine.process;

import java.util.Iterator;
import java.util.LinkedList;
import org.mapdb.Serializer;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.collection.MultiIterator;
import org.modeshape.common.collection.SequentialIterator;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.CachedNodeSupplier;
import org.modeshape.jcr.query.BufferManager;
import org.modeshape.jcr.query.NodeSequence;
import org.modeshape.jcr.query.RowExtractors;
import org.modeshape.jcr.query.engine.process.BufferedRows;
import org.modeshape.jcr.query.engine.process.BufferingSequence;
import org.modeshape.jcr.query.engine.process.JoinSequence;
import org.modeshape.jcr.query.model.JoinType;
import org.modeshape.jcr.query.model.TypeSystem;

@NotThreadSafe
public class HashJoinSequence
extends JoinSequence {
    protected final BufferManager.DistinctBuffer<Object> rightMatchedRowKeys;
    protected final BufferManager.DistinctBuffer<BufferedRows.BufferedRow> rightRowsWithNullKey;
    protected final JoinSequence.RangeProducer<Object> rangeProducer;

    public HashJoinSequence(String workspaceName, NodeSequence left, NodeSequence right, RowExtractors.ExtractFromRow leftExtractor, RowExtractors.ExtractFromRow rightExtractor, JoinType joinType, BufferManager bufferMgr, CachedNodeSupplier nodeCache, JoinSequence.RangeProducer<?> rangeProducer, boolean pack, boolean useHeap) {
        super(workspaceName, left, right, leftExtractor, rightExtractor, joinType, bufferMgr, nodeCache, pack, useHeap, true);
        this.rangeProducer = rangeProducer;
        if (this.useNonMatchingRightRows()) {
            TypeSystem.TypeFactory<?> keyType = rightExtractor.getType();
            Serializer<?> keySerializer = bufferMgr.serializerFor(keyType);
            this.rightMatchedRowKeys = bufferMgr.createDistinctBuffer(keySerializer).keepSize(true).useHeap(useHeap).make();
            BufferedRows.BufferedRowFactory<? extends BufferedRows.BufferedRow> rowSerializer = BufferedRows.serializer(nodeCache, this.width);
            this.rightRowsWithNullKey = bufferMgr.createDistinctBuffer(rowSerializer).keepSize(true).useHeap(useHeap).make();
        } else {
            this.rightMatchedRowKeys = null;
            this.rightRowsWithNullKey = null;
        }
    }

    @Override
    protected JoinSequence.BatchFactory initialize() {
        int firstBatchSize = this.loadAll(this.delegate, this.extractor, this.rightRowsWithNullKey);
        if (firstBatchSize == 0) {
            switch (this.joinType) {
                case CROSS: 
                case RIGHT_OUTER: {
                    return new JoinSequence.EmptyBatchFactory(this);
                }
                case FULL_OUTER: 
                case LEFT_OUTER: {
                    return new JoinSequence.LeftOnlyBatchFactory(this);
                }
                case INNER: {
                    return new JoinSequence.EmptyBatchFactory(this);
                }
            }
        }
        switch (this.joinType) {
            case CROSS: {
                return new HashCrossJoinBatchFactory();
            }
        }
        return this.rangeProducer != null ? new HashJoinRangeBatchFactory() : new HashJoinBatchFactory();
    }

    protected Iterator<BufferedRows.BufferedRow> allRightRows() {
        if (this.rightRowsWithNullKey != null) {
            return SequentialIterator.create(this.rightRowsWithNullKey.iterator(), this.buffer.ascending());
        }
        return this.buffer.ascending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            try {
                if (this.rightMatchedRowKeys != null) {
                    this.rightMatchedRowKeys.close();
                }
            }
            finally {
                if (this.rightRowsWithNullKey != null) {
                    this.rightRowsWithNullKey.close();
                }
            }
        }
    }

    public String toString() {
        return "(hash-join width=" + this.width() + " " + this.joinType + " left=" + this.left + ", right=" + this.delegate + ", on " + this.leftExtractor + "=" + this.extractor + " )";
    }

    protected class RightRowsBatch
    implements NodeSequence.Batch {
        private final Iterator<BufferedRows.BufferedRow> rightRows;
        private final int maxSize;
        private BufferedRows.BufferedRow currentRight;
        private int count = 0;

        protected RightRowsBatch(Iterator<BufferedRows.BufferedRow> rightRows, int maxSize) {
            this.rightRows = rightRows;
            this.maxSize = maxSize;
            assert (this.rightRows != null);
            assert (this.maxSize > 0);
        }

        @Override
        public int width() {
            return HashJoinSequence.this.totalWidth;
        }

        @Override
        public String getWorkspaceName() {
            return HashJoinSequence.this.workspaceName;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public long rowCount() {
            return -1L;
        }

        @Override
        public boolean hasNext() {
            while (this.rightRows.hasNext() && this.count < this.maxSize) {
                this.currentRight = this.rightRows.next();
                Object key = HashJoinSequence.this.extractor.getValueInRow(this.currentRight);
                if (key == null || HashJoinSequence.this.rightMatchedRowKeys.addIfAbsent(key)) {
                    BufferingSequence.logger.trace("Join found non-matched rows on right with value {0}", new Object[]{key});
                    ++this.count;
                    return true;
                }
                BufferingSequence.logger.trace("Join found matched rows on right with value {0}", new Object[]{key});
            }
            return false;
        }

        @Override
        public void nextRow() {
        }

        @Override
        public CachedNode getNode() {
            return null;
        }

        @Override
        public CachedNode getNode(int index) {
            if (this.currentRight != null && index >= HashJoinSequence.this.leftWidth) {
                return this.currentRight.getNode(index - HashJoinSequence.this.leftWidth);
            }
            return null;
        }

        @Override
        public float getScore() {
            return 0.0f;
        }

        @Override
        public float getScore(int index) {
            if (this.currentRight != null && index >= HashJoinSequence.this.leftWidth) {
                return this.currentRight.getScore(index - HashJoinSequence.this.leftWidth);
            }
            return 0.0f;
        }
    }

    protected class HashCrossJoinBatchFactory
    extends HashJoinBatchFactory {
        protected HashCrossJoinBatchFactory() {
        }

        @Override
        protected NodeSequence.Batch createBatch(NodeSequence.Batch leftBatch) {
            return new HashCrossJoinBatch(leftBatch);
        }
    }

    protected class HashCrossJoinBatch
    extends HashJoinBatch {
        protected HashCrossJoinBatch(NodeSequence.Batch currentLeft) {
            super(currentLeft);
        }

        @Override
        protected Iterator<BufferedRows.BufferedRow> getRightRowsFor(Object leftValue) {
            return HashJoinSequence.this.allRightRows();
        }

        @Override
        protected void recordRightRowsMatched(Object rightKey) {
        }
    }

    protected class HashJoinRangeBatch
    extends HashJoinBatch {
        protected HashJoinRangeBatch(NodeSequence.Batch currentLeft) {
            super(currentLeft);
            assert (HashJoinSequence.this.rangeProducer != null);
        }

        @Override
        protected Iterator<BufferedRows.BufferedRow> getRightRowsFor(Object leftValue) {
            if (leftValue == null) {
                return null;
            }
            JoinSequence.Range<Object> range = HashJoinSequence.this.rangeProducer.getRange(leftValue);
            if (range == null) {
                return null;
            }
            return HashJoinSequence.this.buffer.getAll(range.lowerBound(), range.isLowerBoundIncluded(), range.upperBound(), range.isUpperBoundIncluded());
        }
    }

    protected class HashJoinRangeBatchFactory
    extends HashJoinBatchFactory {
        protected HashJoinRangeBatchFactory() {
        }

        @Override
        protected NodeSequence.Batch createBatch(NodeSequence.Batch leftBatch) {
            return new HashJoinRangeBatch(leftBatch);
        }
    }

    protected class HashJoinBatch
    implements NodeSequence.Batch {
        private final NodeSequence.Batch currentLeft;
        private Iterator<BufferedRows.BufferedRow> rightMatchingRows;
        private BufferedRows.BufferedRow currentRight;

        protected HashJoinBatch(NodeSequence.Batch currentLeft) {
            this.currentLeft = currentLeft;
            assert (this.currentLeft != null);
        }

        @Override
        public int width() {
            return HashJoinSequence.this.totalWidth;
        }

        @Override
        public String getWorkspaceName() {
            return HashJoinSequence.this.workspaceName;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public long rowCount() {
            return -1L;
        }

        @Override
        public boolean hasNext() {
            if (this.rightMatchingRows != null && this.rightMatchingRows.hasNext()) {
                return true;
            }
            if (!this.currentLeft.hasNext()) {
                return false;
            }
            while (this.currentLeft.hasNext()) {
                this.currentLeft.nextRow();
                Object matchingValue = HashJoinSequence.this.leftExtractor.getValueInRow(this.currentLeft);
                this.rightMatchingRows = this.getAllRightRowsFor(matchingValue);
                if (this.rightMatchingRows != null && this.rightMatchingRows.hasNext()) {
                    return true;
                }
                if (!HashJoinSequence.this.useAllLeftRowsWhenNoMatchingRightRows()) continue;
                this.rightMatchingRows = null;
                return true;
            }
            return false;
        }

        private Iterator<BufferedRows.BufferedRow> getAllRightRowsFor(Object leftValue) {
            if (leftValue instanceof Object[]) {
                LinkedList<Iterator<BufferedRows.BufferedRow>> iterators = new LinkedList<Iterator<BufferedRows.BufferedRow>>();
                for (Object left : (Object[])leftValue) {
                    Iterator<BufferedRows.BufferedRow> matching = this.getRightRowsFor(left);
                    if (matching == null || !matching.hasNext()) continue;
                    iterators.add(matching);
                }
                if (iterators.isEmpty()) {
                    return null;
                }
                if (iterators.size() == 1) {
                    return (Iterator)iterators.get(0);
                }
                return MultiIterator.fromIterators(iterators);
            }
            return this.getRightRowsFor(leftValue);
        }

        protected Iterator<BufferedRows.BufferedRow> getRightRowsFor(Object leftValue) {
            return HashJoinSequence.this.buffer.getAll(leftValue);
        }

        protected void recordRightRowsMatched(Object rightKey) {
            if (HashJoinSequence.this.rightMatchedRowKeys != null) {
                HashJoinSequence.this.rightMatchedRowKeys.addIfAbsent(rightKey);
            }
        }

        @Override
        public void nextRow() {
            if (this.rightMatchingRows != null) {
                this.currentRight = this.rightMatchingRows.next();
                this.recordRightRowsMatched(HashJoinSequence.this.extractor.getValueInRow(this.currentRight));
            } else {
                this.currentRight = null;
            }
        }

        @Override
        public CachedNode getNode() {
            return this.currentLeft.getNode();
        }

        @Override
        public CachedNode getNode(int index) {
            if (index < HashJoinSequence.this.leftWidth) {
                return this.currentLeft.getNode(index);
            }
            if (this.currentRight == null) {
                return null;
            }
            return this.currentRight.getNode(index - HashJoinSequence.this.leftWidth);
        }

        @Override
        public float getScore() {
            return this.currentLeft.getScore();
        }

        @Override
        public float getScore(int index) {
            if (index < HashJoinSequence.this.leftWidth) {
                return this.currentLeft.getScore(index);
            }
            if (this.currentRight == null) {
                return 0.0f;
            }
            return this.currentRight.getScore(index - HashJoinSequence.this.leftWidth);
        }
    }

    protected class HashJoinBatchFactory
    implements JoinSequence.BatchFactory {
        private Iterator<BufferedRows.BufferedRow> rightRows;

        protected HashJoinBatchFactory() {
        }

        @Override
        public NodeSequence.Batch nextBatch() {
            NodeSequence.Batch leftBatch = HashJoinSequence.this.findNextNonEmptyLeftBatch();
            if (leftBatch != null) {
                HashJoinSequence.this.currentLeft = null;
                return this.createBatch(leftBatch);
            }
            if (HashJoinSequence.this.rightMatchedRowKeys == null) {
                return null;
            }
            if (this.rightRows == null) {
                this.rightRows = HashJoinSequence.this.allRightRows();
            }
            if (!this.rightRows.hasNext()) {
                return null;
            }
            return new RightRowsBatch(this.rightRows, 100);
        }

        protected NodeSequence.Batch createBatch(NodeSequence.Batch leftBatch) {
            return new HashJoinBatch(leftBatch);
        }
    }
}

