/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.document;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.DocumentSequence;
import org.infinispan.schematic.document.ParsingException;
import org.infinispan.schematic.internal.document.CompactJsonWriter;
import org.infinispan.schematic.internal.document.JsonReader;
import org.infinispan.schematic.internal.document.JsonWriter;
import org.infinispan.schematic.internal.document.PrettyJsonWriter;
import org.infinispan.util.logging.LogFactory;

public class Json {
    public static final Charset UTF8;
    private static final CompactJsonWriter SHARED_COMPACT_WRITER;
    private static final JsonReader SHARED_READER;

    protected static JsonWriter getCompactJsonWriter() {
        return SHARED_COMPACT_WRITER;
    }

    protected static JsonWriter getPrettyWriter() {
        return new PrettyJsonWriter();
    }

    protected static JsonReader getReader() {
        return SHARED_READER;
    }

    public static Document read(URL url) throws ParsingException {
        return SHARED_READER.read(url);
    }

    public static Document read(InputStream stream) throws ParsingException {
        return SHARED_READER.read(stream);
    }

    public static Document read(InputStream stream, boolean introspectStringValues) throws ParsingException {
        return SHARED_READER.read(stream, introspectStringValues);
    }

    public static Document read(InputStream stream, Charset charset) throws ParsingException {
        return SHARED_READER.read(stream, charset);
    }

    public static Document read(Reader reader) throws ParsingException {
        return SHARED_READER.read(reader);
    }

    public static Document read(String json) throws ParsingException {
        return SHARED_READER.read(json);
    }

    public static DocumentSequence readMultiple(InputStream stream) {
        return SHARED_READER.readMultiple(stream);
    }

    public static DocumentSequence readMultiple(Reader reader) {
        return SHARED_READER.readMultiple(reader);
    }

    public static String write(Document bson) {
        return Json.getCompactJsonWriter().write(bson);
    }

    public static String write(Object value) {
        return Json.getCompactJsonWriter().write(value);
    }

    public static void write(Document bson, Writer writer) throws IOException {
        Json.getCompactJsonWriter().write((Object)bson, writer);
    }

    public static void write(Document bson, OutputStream stream) throws IOException {
        Json.getCompactJsonWriter().write((Object)bson, stream);
    }

    public static String writePretty(Document bson) {
        return Json.getPrettyWriter().write(bson);
    }

    public static String writePretty(Object value) {
        return Json.getPrettyWriter().write(value);
    }

    public static void writePretty(Document bson, Writer writer) throws IOException {
        Json.getPrettyWriter().write((Object)bson, writer);
    }

    public static void writePretty(Document bson, OutputStream stream) throws IOException {
        Json.getPrettyWriter().write((Object)bson, stream);
    }

    static {
        Charset charset = Charset.defaultCharset();
        try {
            charset = Charset.forName("UTF-8");
        }
        catch (Throwable t) {
            LogFactory.getLog(CompactJsonWriter.class).error((Object)"Unable to obtain 'UTF-8' character set for JSON writing; using default charset.");
        }
        UTF8 = charset;
        SHARED_COMPACT_WRITER = new CompactJsonWriter();
        SHARED_READER = new JsonReader();
    }

    public class ReservedField {
        public static final String OBJECT_ID = "$oid";
        public static final String DATE = "$date";
        public static final String TIMESTAMP = "$ts";
        public static final String INCREMENT = "$inc";
        public static final String REGEX_PATTERN = "$regex";
        public static final String REGEX_OPTIONS = "$options";
        public static final String BINARY_TYPE = "$type";
        public static final String BASE_64 = "$base64";
        public static final String UUID = "$uuid";
        public static final String CODE = "$code";
        public static final String SCOPE = "$scope";
    }
}

