/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.Util;

public class ReflectionUtil {
    private static final Log log = LogFactory.getLog(ReflectionUtil.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Class<?>[] primitives = new Class[]{Integer.TYPE, Byte.TYPE, Short.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE};
    private static final Class<?>[] primitiveArrays = new Class[]{int[].class, byte[].class, short[].class, long[].class, float[].class, double[].class, boolean[].class, char[].class};
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];

    public static List<Method> getAllMethods(Class<?> c, Class<? extends Annotation> annotationType) {
        LinkedList<Method> annotated = new LinkedList<Method>();
        ReflectionUtil.inspectRecursively(c, annotated, annotationType);
        return annotated;
    }

    public static List<Method> getAllMethodsShallow(Class<?> c, Class<? extends Annotation> annotationType) {
        LinkedList<Method> annotated = new LinkedList<Method>();
        for (Method m : c.getDeclaredMethods()) {
            if (!m.isAnnotationPresent(annotationType)) continue;
            annotated.add(m);
        }
        return annotated;
    }

    private static void getAnnotatedFieldHelper(List<Field> list, Class<?> c, Class<? extends Annotation> annotationType) {
        Field[] declaredFields;
        for (Field field : declaredFields = c.getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotationType)) continue;
            list.add(field);
        }
    }

    public static List<Field> getAnnotatedFields(Class<?> c, Class<? extends Annotation> annotationType) {
        ArrayList<Field> fields = new ArrayList<Field>(4);
        while (c != null && !c.equals(Object.class)) {
            ReflectionUtil.getAnnotatedFieldHelper(fields, c, annotationType);
            c = c.getSuperclass();
        }
        return fields;
    }

    public static Method findMethod(Class<?> type, String methodName) {
        try {
            return type.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            if (type.equals(Object.class) || type.isInterface()) {
                throw new CacheException(e);
            }
            return ReflectionUtil.findMethod(type.getSuperclass(), methodName);
        }
    }

    public static Method findMethod(Class<?> type, String methodName, Class<?>[] parameters) throws ClassNotFoundException {
        try {
            return type.getDeclaredMethod(methodName, parameters);
        }
        catch (NoSuchMethodException e) {
            if (type.equals(Object.class) || type.isInterface()) {
                throw new CacheException(e);
            }
            return ReflectionUtil.findMethod(type.getSuperclass(), methodName, parameters);
        }
    }

    private static void inspectRecursively(Class<?> c, List<Method> s, Class<? extends Annotation> annotationType) {
        for (Method method : c.getDeclaredMethods()) {
            if (!ReflectionUtil.notFound(method, s) || !method.isAnnotationPresent(annotationType)) continue;
            s.add(method);
        }
        if (!c.equals(Object.class) && !c.isInterface()) {
            ReflectionUtil.inspectRecursively(c.getSuperclass(), s, annotationType);
            for (GenericDeclaration genericDeclaration : c.getInterfaces()) {
                ReflectionUtil.inspectRecursively(genericDeclaration, s, annotationType);
            }
        }
    }

    private static boolean notFound(Method m, Collection<Method> s) {
        for (Method found : s) {
            if (!m.getName().equals(found.getName()) || !Arrays.equals(m.getParameterTypes(), found.getParameterTypes())) continue;
            return false;
        }
        return true;
    }

    public static void setValue(Object instance, String fieldName, Object value) {
        try {
            Field f = ReflectionUtil.findFieldRecursively(instance.getClass(), fieldName);
            if (f == null) {
                throw new NoSuchMethodException("Cannot find field " + fieldName + " on " + instance.getClass() + " or superclasses");
            }
            f.setAccessible(true);
            f.set(instance, value);
        }
        catch (Exception e) {
            log.unableToSetValue(e);
        }
    }

    private static Field findFieldRecursively(Class<?> c, String fieldName) {
        Field f;
        block2: {
            f = null;
            try {
                f = c.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                if (c.equals(Object.class)) break block2;
                f = ReflectionUtil.findFieldRecursively(c.getSuperclass(), fieldName);
            }
        }
        return f;
    }

    public static Object invokeAccessibly(Object instance, Method method, Object[] parameters) {
        try {
            method.setAccessible(true);
            return method.invoke(instance, parameters);
        }
        catch (InvocationTargetException e) {
            throw new CacheException("Unable to invoke method " + method + " on object of type " + (instance == null ? "null" : instance.getClass().getSimpleName()) + (parameters != null ? " with parameters " + Arrays.asList(parameters) : ""), e.getCause());
        }
        catch (Exception e) {
            throw new CacheException("Unable to invoke method " + method + " on object of type " + (instance == null ? "null" : instance.getClass().getSimpleName()) + (parameters != null ? " with parameters " + Arrays.asList(parameters) : ""), e);
        }
    }

    public static Method findGetterForField(Class<?> c, String fieldName) {
        Method retval = ReflectionUtil.findGetterForFieldUsingReflection(c, fieldName);
        if (retval == null && !c.equals(Object.class) && !c.isInterface() && (retval = ReflectionUtil.findGetterForField(c.getSuperclass(), fieldName)) == null) {
            Class<?> ifc;
            Class<?>[] arr$ = c.getInterfaces();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (retval = ReflectionUtil.findGetterForField(ifc = arr$[i$], fieldName)) == null; ++i$) {
            }
        }
        return retval;
    }

    private static Method findGetterForFieldUsingReflection(Class<?> c, String fieldName) {
        for (Method m : c.getDeclaredMethods()) {
            String name = m.getName();
            String s = null;
            if (name.startsWith("get")) {
                s = name.substring(3);
            } else if (name.startsWith("is")) {
                s = name.substring(2);
            }
            if (s == null || !s.equalsIgnoreCase(fieldName)) continue;
            return m;
        }
        return null;
    }

    public static Method findSetterForField(Class<?> c, String fieldName) {
        for (Method m : c.getDeclaredMethods()) {
            String name = m.getName();
            String s = null;
            if (name.startsWith("set")) {
                s = name.substring(3);
            }
            if (s == null || !s.equalsIgnoreCase(fieldName)) continue;
            return m;
        }
        return null;
    }

    public static String extractFieldName(String setterOrGetter) {
        String field = null;
        if (setterOrGetter.startsWith("set") || setterOrGetter.startsWith("get")) {
            field = setterOrGetter.substring(3);
        } else if (setterOrGetter.startsWith("is")) {
            field = setterOrGetter.substring(2);
        }
        if (field != null && field.length() > 1) {
            StringBuilder sb = new StringBuilder();
            sb.append(Character.toLowerCase(field.charAt(0)));
            if (field.length() > 2) {
                sb.append(field.substring(1));
            }
            return sb.toString();
        }
        return null;
    }

    public static Object getValue(Object instance, String fieldName) {
        Field f = ReflectionUtil.findFieldRecursively(instance.getClass(), fieldName);
        if (f == null) {
            throw new CacheException("Could not find field named '" + fieldName + "' on instance " + instance);
        }
        try {
            f.setAccessible(true);
            return f.get(instance);
        }
        catch (IllegalAccessException iae) {
            throw new CacheException("Cannot access field " + f, iae);
        }
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> ann) {
        T a;
        while ((a = clazz.getAnnotation(ann)) == null) {
            Class<?> superclass;
            if (!clazz.isInterface()) {
                Class<?>[] interfaces;
                for (Class<?> inter : interfaces = clazz.getInterfaces()) {
                    a = ReflectionUtil.getAnnotation(inter, ann);
                    if (a == null) continue;
                    return a;
                }
            }
            if ((superclass = clazz.getSuperclass()) == null) {
                return null;
            }
            clazz = superclass;
        }
        return a;
    }

    public static boolean isAnnotationPresent(Class<?> clazz, Class<? extends Annotation> annotation) {
        return ReflectionUtil.getAnnotation(clazz, annotation) != null;
    }

    public static Class<?>[] toClassArray(String[] typeList, ClassLoader classLoader) throws ClassNotFoundException {
        if (typeList == null) {
            return EMPTY_CLASS_ARRAY;
        }
        Class[] retval = new Class[typeList.length];
        int i = 0;
        for (String s : typeList) {
            retval[i++] = ReflectionUtil.getClassForName(s, classLoader);
        }
        return retval;
    }

    public static Class<?> getClassForName(String name, ClassLoader cl) throws ClassNotFoundException {
        try {
            return Util.loadClassStrict(name, cl);
        }
        catch (ClassNotFoundException cnfe) {
            for (Class<?> primitive : primitives) {
                if (!name.equals(primitive.getName())) continue;
                return primitive;
            }
            for (Class<?> primitive : primitiveArrays) {
                if (!name.equals(primitive.getName())) continue;
                return primitive;
            }
            throw new ClassNotFoundException("Class " + name + " cannot be found");
        }
    }

    public static String[] toStringArray(Class<?>[] classes) {
        if (classes == null) {
            return EMPTY_STRING_ARRAY;
        }
        String[] classNames = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            classNames[i] = classes[i].getName();
        }
        return classNames;
    }

    public static Field getField(String fieldName, Class<?> objectClass) {
        try {
            return objectClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            if (!objectClass.equals(Object.class)) {
                return ReflectionUtil.getField(fieldName, objectClass.getSuperclass());
            }
            return null;
        }
    }

    public static void applyProperties(Object o, Properties p) {
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            ReflectionUtil.setValue(o, (String)entry.getKey(), entry.getValue());
        }
    }

    public static <T> T unwrap(Object obj, Class<T> clazz) {
        if (clazz != null && clazz.isAssignableFrom(obj.getClass())) {
            return clazz.cast(obj);
        }
        throw log.unableToUnwrap(obj, clazz);
    }
}

