/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;

public class ServiceFinder {
    public static <S> Collection<Class<S>> load(Class<S> service, ClassLoader ... loaders) {
        LinkedHashSet<Class<S>> services = new LinkedHashSet<Class<S>>();
        for (ClassLoader loader : loaders) {
            if (loader == null) continue;
            try {
                Enumeration<URL> resources = loader.getResources("META-INF/services/" + service.getName());
                while (resources.hasMoreElements()) {
                    URL resource = resources.nextElement();
                    BufferedReader r = new BufferedReader(new InputStreamReader(resource.openStream()));
                    String line = r.readLine();
                    while (line != null) {
                        if (!(line = line.trim()).startsWith("#")) {
                            try {
                                Class<?> klass = loader.loadClass(line);
                                if (!service.isAssignableFrom(klass)) {
                                    throw new ClassCastException("Class " + line + " does not implement " + service.getName());
                                }
                                services.add(klass);
                            }
                            catch (ClassNotFoundException e) {
                                // empty catch block
                            }
                        }
                        line = r.readLine();
                    }
                    r.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return services;
    }
}

