/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.validation;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class Validator {
    private static final Logger logger = LoggerFactory.getLogger(Validator.class);

    public List<ValidationMessage> validate(ConfigurationItem roe, ConfigurationItem ... cisInContext) {
        return this.validate(roe, Lists.newArrayList((Object[])cisInContext));
    }

    public List<ValidationMessage> validate(ConfigurationItem ci, List<ConfigurationItem> cisInContext) {
        return ci.getType().getDescriptor().validate(ci);
    }

    public void validateCi(ConfigurationItem item) throws ValidationsFailedException {
        List<ValidationMessage> messages = this.validate(item, new ConfigurationItem[0]);
        if (!messages.isEmpty()) {
            item.get$validationMessages().addAll(messages);
            throw new ValidationsFailedException(item);
        }
    }

    public void validateCis(List<ConfigurationItem> entities) {
        ArrayList toBeValidated = Lists.newArrayList(entities);
        entities.clear();
        boolean allValid = true;
        for (ConfigurationItem entity : toBeValidated) {
            List<ValidationMessage> messages = this.validate(entity, new ConfigurationItem[0]);
            if (!messages.isEmpty()) {
                logger.error("Validation failed for [{}], messages are:\n" + Joiner.on((String)"\n").join(messages));
                entity.get$validationMessages().addAll(messages);
            }
            entities.add(entity);
            allValid = allValid && messages.isEmpty();
        }
        if (!allValid) {
            throw new ValidationsFailedException(entities);
        }
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class ValidationsFailedException
    extends DeployitException {
        public ValidationsFailedException(List<ConfigurationItem> cis) {
            super(cis);
        }

        public ValidationsFailedException(ConfigurationItem ci) {
            super((Object)ci);
        }
    }
}

