/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleCapabilityImpl;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundleRequirementImpl;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.ImportPkg;
import org.knopflerfish.framework.IteratorIterator;
import org.knopflerfish.framework.IteratorIteratorSorted;
import org.knopflerfish.framework.RequireBundle;
import org.knopflerfish.framework.SystemBundle;
import org.knopflerfish.framework.Util;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.wiring.BundleRequirement;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BundlePackages {
    final BundleGeneration bg;
    private final ArrayList<ExportPkg> exports = new ArrayList(1);
    private final ArrayList<ImportPkg> imports = new ArrayList(1);
    private final ArrayList<ImportPkg> dImportPatterns = new ArrayList(1);
    private final Map<String, List<BundleCapabilityImpl>> capabilities;
    private TreeMap<BundleGeneration, BundlePackages> fragments = null;
    private ArrayList<RequireBundle> require;
    private ArrayList<BundlePackages> requiredBy = null;
    private ArrayList<ImportPkg> okImports = null;
    private boolean registered = false;
    private String failReason = null;
    private int nextDynId = 0;
    static final String EMPTY_STRING = "";
    static final Util.Comparator<ExportPkg, ExportPkg> epComp = new Util.Comparator<ExportPkg, ExportPkg>(){

        @Override
        public int compare(ExportPkg a, ExportPkg b) throws ClassCastException {
            return a.name.compareTo(b.name);
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.compare((ExportPkg)x0, (ExportPkg)x1);
        }
    };
    static final Util.Comparator<ExportPkg, String> epFind = new Util.Comparator<ExportPkg, String>(){

        @Override
        public int compare(ExportPkg a, String b) {
            return a.name.compareTo(b);
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.compare((ExportPkg)x0, (String)x1);
        }
    };
    static final Util.Comparator<ImportPkg, ImportPkg> ipComp = new Util.Comparator<ImportPkg, ImportPkg>(){

        @Override
        public int compare(ImportPkg a, ImportPkg b) throws ClassCastException {
            return a.name.compareTo(b.name);
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.compare((ImportPkg)x0, (ImportPkg)x1);
        }
    };
    static final Util.Comparator<ImportPkg, String> ipFind = new Util.Comparator<ImportPkg, String>(){

        @Override
        public int compare(ImportPkg a, String b) {
            return a.name.compareTo(b);
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.compare((ImportPkg)x0, (String)x1);
        }
    };

    BundlePackages(BundleGeneration bg) {
        this.bg = bg;
        BundleArchive ba = bg.archive;
        block0: for (Util.HeaderEntry he : Util.parseManifestHeader("Import-Package", ba.getAttribute("Import-Package"), false, true, false)) {
            Iterator<String> pi = he.getKeys().iterator();
            ImportPkg ip = new ImportPkg(pi.next(), he, this, false);
            while (true) {
                int ii;
                if ((ii = Util.binarySearch(this.imports, ipComp, ip)) >= 0) {
                    throw new IllegalArgumentException(((Object)new StringBuffer().append("Duplicate import definitions for - ").append(ip.name)).toString());
                }
                this.imports.add(-ii - 1, ip);
                if (!pi.hasNext()) continue block0;
                ip = new ImportPkg(ip, pi.next());
            }
        }
        block2: for (Util.HeaderEntry he : Util.parseManifestHeader("Export-Package", ba.getAttribute("Export-Package"), false, true, false)) {
            List<String> keys = he.getKeys();
            Iterator<String> pi = keys.iterator();
            ExportPkg ep = new ExportPkg(pi.next(), he, this);
            while (true) {
                ImportPkg ip;
                int ii;
                int ei = Math.abs(Util.binarySearch(this.exports, epComp, ep) + 1);
                this.exports.add(ei, ep);
                if (!bg.v2Manifest && (ii = Util.binarySearch(this.imports, ipComp, ip = new ImportPkg(ep))) < 0) {
                    this.imports.add(-ii - 1, ip);
                }
                if (!pi.hasNext()) continue block2;
                ep = new ExportPkg(ep, pi.next());
            }
        }
        this.parseDynamicImports(ba.getAttribute("DynamicImport-Package"));
        List<Util.HeaderEntry> hes = Util.parseManifestHeader("Require-Bundle", ba.getAttribute("Require-Bundle"), true, true, false);
        if (!hes.isEmpty()) {
            this.require = new ArrayList();
            for (Util.HeaderEntry he : hes) {
                this.require.add(new RequireBundle(this, he));
            }
        } else {
            this.require = null;
        }
        this.capabilities = bg.getDeclaredCapabilities();
    }

    BundlePackages(BundleGeneration bg, String exportString) {
        this.bg = bg;
        block0: for (Util.HeaderEntry he : Util.parseManifestHeader("Export-Package", exportString, false, true, false)) {
            List<String> keys = he.getKeys();
            Iterator<String> pi = keys.iterator();
            ExportPkg ep = new ExportPkg(pi.next(), he, this);
            while (true) {
                int ei;
                if ((ei = Util.binarySearch(this.exports, epComp, ep)) >= 0) {
                    this.exports.set(ei, ep);
                } else {
                    this.exports.add(-ei - 1, ep);
                }
                if (!pi.hasNext()) continue block0;
                ep = new ExportPkg(ep, pi.next());
            }
        }
        this.require = null;
        this.capabilities = bg.getDeclaredCapabilities();
    }

    BundlePackages(BundlePackages host, BundlePackages frag, boolean noNew) {
        this.bg = host.bg;
        Iterator<ImportPkg> iiter = frag.getImports();
        while (iiter.hasNext()) {
            ImportPkg importPkg = iiter.next();
            ImportPkg ip = host.getImport(importPkg.name);
            if (ip != null) {
                if (!importPkg.intersect(ip)) {
                    throw new IllegalStateException("Host bundle import package and fragment bundle import package doesn't intersect, resolve isn't possible.");
                }
            } else if (noNew) {
                throw new IllegalStateException("Resolve host bundle package would be shadow by new fragment import.");
            }
            this.imports.add(new ImportPkg(importPkg, this));
        }
        if (frag.require != null) {
            this.require = new ArrayList();
            for (RequireBundle requireBundle : frag.require) {
                boolean match = false;
                if (host.require != null) {
                    for (RequireBundle req : host.require) {
                        if (!requireBundle.name.equals(req.name)) continue;
                        if (requireBundle.overlap(req)) {
                            match = true;
                            continue;
                        }
                        throw new IllegalStateException("Fragment bundle required bundle doesn't completely overlap required bundle in host bundle.");
                    }
                }
                if (match) continue;
                if (this.bg.bundle.state != 2) {
                    throw new IllegalStateException("Can not attach a fragment with new required bundles to a resolved host");
                }
                this.require.add(new RequireBundle(requireBundle, this));
            }
        } else {
            this.require = null;
        }
        Iterator<ExportPkg> eiter = frag.getExports();
        while (eiter.hasNext()) {
            ExportPkg hep;
            ExportPkg exportPkg = eiter.next();
            if (exportPkg.pkgEquals(hep = this.getExport(exportPkg.name))) continue;
            this.exports.add(new ExportPkg(exportPkg, this));
        }
        this.capabilities = new HashMap<String, List<BundleCapabilityImpl>>();
        for (Map.Entry entry : frag.bg.getDeclaredCapabilities().entrySet()) {
            ArrayList<BundleCapabilityImpl> l = new ArrayList<BundleCapabilityImpl>();
            for (BundleCapabilityImpl bc : (List)entry.getValue()) {
                l.add(new BundleCapabilityImpl(bc, this.bg));
            }
            this.capabilities.put((String)entry.getKey(), (List<BundleCapabilityImpl>)l);
        }
    }

    void registerPackages() {
        this.bg.bundle.fwCtx.resolver.registerCapabilities(this.capabilities, this.exports.iterator(), this.imports.iterator());
        this.registered = true;
    }

    synchronized boolean unregisterPackages(boolean force) {
        if (this.registered) {
            if (this.bg.bundle.fwCtx.resolver.unregisterCapabilities(this.capabilities, this.getExports(), this.getImports(), force)) {
                this.registered = false;
                if (this.okImports != null) {
                    this.okImports = null;
                    for (List<BundleRequirementImpl> lbr : this.bg.getOtherRequirements().values()) {
                        for (BundleRequirementImpl br : lbr) {
                            br.resetWire();
                        }
                    }
                    this.unRequireBundles();
                    this.detachFragments();
                }
            } else {
                return false;
            }
        }
        return true;
    }

    boolean resolvePackages(BundleImpl[] triggers) throws BundleException {
        this.failReason = this.bg.bundle.fwCtx.resolver.resolve(this.bg, this, triggers);
        if (this.failReason == null) {
            this.okImports = new ArrayList(this.imports.size());
            Iterator<ImportPkg> i = this.getImports();
            while (i.hasNext()) {
                ImportPkg ip = i.next();
                if (ip.provider == null) continue;
                this.okImports.add(ip);
            }
            return true;
        }
        return false;
    }

    String getResolveFailReason() {
        return this.failReason;
    }

    synchronized BundlePackages getProviderBundlePackages(String pkg) {
        if (this.bg.bundle instanceof SystemBundle) {
            return this.isExported(pkg) ? this : null;
        }
        if (this.okImports == null) {
            return null;
        }
        int ii = Util.binarySearch(this.okImports, ipFind, pkg);
        if (ii >= 0) {
            return this.okImports.get((int)ii).provider.bpkgs;
        }
        return null;
    }

    synchronized Set<String> getSubProvider(String pkg) {
        HashSet<String> res = new HashSet<String>();
        if (pkg.length() > 0) {
            pkg = ((Object)new StringBuffer().append(pkg).append(".")).toString();
        }
        if (this.okImports != null) {
            for (ImportPkg ip : this.okImports) {
                String n;
                if (ip.provider == null || !ip.name.startsWith(pkg) || (n = ip.name.substring(pkg.length())).indexOf(46) != -1) continue;
                res.add(n);
            }
            Iterator<RequireBundle> irb = this.getRequire();
            while (irb.hasNext()) {
                RequireBundle rb = irb.next();
                if (rb.bpkgs == null) continue;
                Iterator<ExportPkg> iep = rb.bpkgs.getExports();
                while (iep.hasNext()) {
                    String n;
                    ExportPkg ep = iep.next();
                    if (!ep.name.startsWith(pkg) || (n = ep.name.substring(pkg.length())).indexOf(46) != -1) continue;
                    res.add(n);
                }
            }
        }
        return res;
    }

    synchronized BundlePackages getDynamicProviderBundlePackages(String pkg) {
        if (this.okImports == null) {
            return null;
        }
        int ii = Util.binarySearch(this.okImports, ipFind, pkg);
        if (ii >= 0) {
            return this.okImports.get((int)ii).provider.bpkgs;
        }
        BundlePackages res = null;
        BundleImpl[] trigger = null;
        FrameworkContext fwCtx = this.bg.bundle.fwCtx;
        try {
            for (ImportPkg ip : this.dImportPatterns) {
                ImportPkg nip;
                ExportPkg ep;
                if (ip.name != EMPTY_STRING && (!ip.name.endsWith(".") || !pkg.startsWith(ip.name)) && !pkg.equals(ip.name)) continue;
                if (trigger == null) {
                    trigger = new BundleImpl[]{this.bg.bundle};
                    fwCtx.resolverHooks.beginResolve(trigger);
                }
                if ((ep = fwCtx.resolver.registerDynamicImport(nip = new ImportPkg(ip, pkg))) == null) continue;
                nip.provider = ep;
                nip.dynId = ++this.nextDynId;
                this.okImports.add(-ii - 1, nip);
                res = ep.bpkgs;
                break;
            }
        }
        catch (BundleException be) {
            fwCtx.frameworkError(this.bg.bundle, (Throwable)be, new FrameworkListener[0]);
        }
        if (trigger != null) {
            try {
                fwCtx.resolverHooks.endResolve(trigger);
            }
            catch (BundleException be) {
                fwCtx.frameworkError(this.bg.bundle, (Throwable)be, new FrameworkListener[0]);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<RequireBundle> getRequire() {
        if (this.fragments != null) {
            TreeMap<BundleGeneration, BundlePackages> treeMap = this.fragments;
            synchronized (treeMap) {
                ArrayList iters = new ArrayList(this.fragments.size() + 1);
                if (this.require != null) {
                    iters.add(this.require.iterator());
                }
                for (BundlePackages bundlePackages : this.fragments.values()) {
                    iters.add(bundlePackages.getRequire());
                }
                return new IteratorIterator<RequireBundle>(iters);
            }
        }
        if (this.require != null) {
            return this.require.iterator();
        }
        Iterator<RequireBundle> res = Collections.EMPTY_LIST.iterator();
        return res;
    }

    ArrayList<BundleGeneration> getRequiredBundleGenerations(String pkg) {
        ArrayList<BundleGeneration> res = null;
        Iterator<RequireBundle> i = this.getRequire();
        while (i.hasNext()) {
            RequireBundle rb = i.next();
            if (rb.bpkgs == null || !rb.bpkgs.isExported(pkg)) continue;
            if (res == null) {
                res = new ArrayList<BundleGeneration>(2);
            }
            res.add(rb.bpkgs.bg);
        }
        return res;
    }

    void addRequiredBy(BundlePackages r) {
        if (this.requiredBy == null) {
            this.requiredBy = new ArrayList();
        }
        this.requiredBy.add(r);
    }

    boolean isRequired() {
        return this.requiredBy != null && !this.requiredBy.isEmpty();
    }

    boolean isRequiredBy(BundlePackages cbp) {
        return this.requiredBy != null && this.requiredBy.contains(cbp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<BundlePackages> getRequiredBy() {
        ArrayList<BundlePackages> res = new ArrayList<BundlePackages>();
        if (this.requiredBy != null) {
            Cloneable cloneable = this.requiredBy;
            synchronized (cloneable) {
                res.addAll(this.requiredBy);
            }
            if (this.fragments != null) {
                cloneable = this.fragments;
                synchronized (cloneable) {
                    for (BundlePackages bundlePackages : this.fragments.values()) {
                        List<BundlePackages> fl = bundlePackages.getRequiredBy();
                        if (fl == null) continue;
                        res.addAll(fl);
                    }
                }
            }
        }
        return res;
    }

    void checkReExport(ExportPkg ep) {
        int i = Util.binarySearch(this.exports, epFind, ep.name);
        if (i < 0) {
            ExportPkg nep = new ExportPkg(ep, this);
            this.exports.add(-i - 1, nep);
            ep.pkg.addExporter(nep);
        }
    }

    private ExportPkg getExport(String pkg) {
        int i = Util.binarySearch(this.exports, epFind, pkg);
        if (i >= 0) {
            return this.exports.get(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<ExportPkg> getExports() {
        if (this.fragments != null) {
            TreeMap<BundleGeneration, BundlePackages> treeMap = this.fragments;
            synchronized (treeMap) {
                ArrayList iters = new ArrayList(this.fragments.size() + 1);
                iters.add(this.exports.iterator());
                for (BundlePackages bundlePackages : this.fragments.values()) {
                    iters.add(bundlePackages.getExports());
                }
                return new IteratorIteratorSorted<ExportPkg>(iters, epComp);
            }
        }
        return this.exports.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<ExportPkg> getExports(String pkg) {
        ArrayList<ExportPkg> res = new ArrayList<ExportPkg>(2);
        ExportPkg ep = this.getExport(pkg);
        if (ep != null) {
            res.add(ep);
        }
        if (this.fragments != null) {
            TreeMap<BundleGeneration, BundlePackages> treeMap = this.fragments;
            synchronized (treeMap) {
                for (BundlePackages bundlePackages : this.fragments.values()) {
                    ep = bundlePackages.getExport(pkg);
                    if (ep == null) continue;
                    res.add(ep);
                }
            }
        }
        return res.isEmpty() ? null : res.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isExported(String pkg) {
        if (this.getExport(pkg) != null) {
            return true;
        }
        if (this.fragments != null) {
            TreeMap<BundleGeneration, BundlePackages> treeMap = this.fragments;
            synchronized (treeMap) {
                for (BundlePackages bundlePackages : this.fragments.values()) {
                    if (bundlePackages.getExport(pkg) == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<ImportPkg> getImports() {
        if (this.fragments != null) {
            TreeMap<BundleGeneration, BundlePackages> treeMap = this.fragments;
            synchronized (treeMap) {
                ArrayList iters = new ArrayList(this.fragments.size() + 1);
                iters.add(this.imports.iterator());
                for (BundlePackages bundlePackages : this.fragments.values()) {
                    iters.add(bundlePackages.getImports());
                }
                return new IteratorIteratorSorted<ImportPkg>(iters, ipComp);
            }
        }
        return this.imports.iterator();
    }

    Iterator<ImportPkg> getActiveImports() {
        if (this.okImports != null) {
            return this.okImports.iterator();
        }
        if (this.bg.isFragment()) {
            return this.bg.bpkgs.getActiveImports();
        }
        return null;
    }

    SortedSet<ExportPkg> getDeclaredPackageCapabilities() {
        TreeSet<ExportPkg> epCreationOrder = new TreeSet<ExportPkg>(this.exports);
        return epCreationOrder;
    }

    SortedSet<ImportPkg> getDeclaredPackageRequirements() {
        TreeSet<ImportPkg> ipCreationOrder = new TreeSet<ImportPkg>(this.imports);
        ipCreationOrder.addAll(this.dImportPatterns);
        return ipCreationOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ExportPkg> getPackageCapabilities() {
        ArrayList<ExportPkg> res = new ArrayList<ExportPkg>(this.getDeclaredPackageCapabilities());
        if (this.fragments != null) {
            TreeMap<BundleGeneration, BundlePackages> treeMap = this.fragments;
            synchronized (treeMap) {
                for (BundlePackages bpkgs : this.fragments.values()) {
                    res.addAll(bpkgs.getDeclaredPackageCapabilities());
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ImportPkg> getPackageRequirements() {
        ArrayList<ImportPkg> res = new ArrayList<ImportPkg>();
        for (ImportPkg ip : this.getDeclaredPackageRequirements()) {
            if (ip.provider == null && !ip.isDynamic()) continue;
            res.add(ip);
        }
        if (this.fragments != null) {
            HashSet<ImportPkg> parents = new HashSet<ImportPkg>();
            Object object = this;
            synchronized (object) {
                for (ImportPkg oip : this.okImports) {
                    if (oip.parent == null || oip.parent.bpkgs == oip.bpkgs) continue;
                    parents.add(oip.parent);
                }
            }
            object = this.fragments;
            synchronized (object) {
                for (BundlePackages bpkgs : this.fragments.values()) {
                    for (ImportPkg ip : bpkgs.getDeclaredPackageRequirements()) {
                        if (!ip.isDynamic() && !parents.contains(ip)) continue;
                        res.add(ip);
                    }
                }
            }
        }
        return res;
    }

    synchronized List<ImportPkg> getActiveChildImports(ImportPkg ip) {
        ArrayList<ImportPkg> res = new ArrayList<ImportPkg>();
        for (ImportPkg oip : this.okImports) {
            if (oip.parent != ip) continue;
            res.add(oip);
        }
        return res;
    }

    List<BundleRequirement> getDeclaredBundleRequirements() {
        ArrayList<BundleRequirement> res = new ArrayList<BundleRequirement>();
        if (this.require != null) {
            TreeSet<RequireBundle> rbCreationOrder = new TreeSet<RequireBundle>(this.require);
            res.addAll(rbCreationOrder);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, List<BundleCapabilityImpl>> getOtherCapabilities() {
        Map<String, List<BundleCapabilityImpl>> res = this.capabilities;
        if (this.fragments != null) {
            TreeMap<BundleGeneration, BundlePackages> treeMap = this.fragments;
            synchronized (treeMap) {
                boolean copied = false;
                for (BundlePackages bpkgs : this.fragments.values()) {
                    Map<String, List<BundleCapabilityImpl>> frm = bpkgs.getOtherCapabilities();
                    if (frm.isEmpty()) continue;
                    if (!copied) {
                        res = new HashMap<String, List<BundleCapabilityImpl>>(res);
                        copied = true;
                    }
                    for (Map.Entry<String, List<BundleCapabilityImpl>> e : frm.entrySet()) {
                        String ns = e.getKey();
                        List<BundleCapabilityImpl> p = res.get(ns);
                        if (p != null) {
                            p = new ArrayList<BundleCapabilityImpl>(p);
                            p.addAll((Collection<BundleCapabilityImpl>)e.getValue());
                        } else {
                            p = e.getValue();
                        }
                        res.put(ns, p);
                    }
                }
            }
        }
        return res;
    }

    ClassLoader getClassLoader() {
        return this.bg.getClassLoader();
    }

    boolean isRegistered() {
        return this.registered;
    }

    String attachFragment(BundlePackages fbpkgs) throws BundleException {
        boolean resolvedHost = this.okImports != null;
        BundlePackages nfbpkgs = new BundlePackages(this, fbpkgs, resolvedHost);
        nfbpkgs.registerPackages();
        if (resolvedHost) {
            try {
                this.failReason = this.bg.bundle.fwCtx.resolver.resolve(this.bg, nfbpkgs, null);
            }
            catch (BundleException be) {
                nfbpkgs.unregisterPackages(true);
                throw be;
            }
            if (this.failReason == null) {
                Iterator<ImportPkg> i = nfbpkgs.getImports();
                while (i.hasNext()) {
                    int ii;
                    ImportPkg ip = i.next();
                    if (ip.provider == null || (ii = Util.binarySearch(this.okImports, ipComp, ip)) >= 0) continue;
                    this.okImports.add(-ii - 1, ip);
                }
            } else {
                nfbpkgs.unregisterPackages(true);
                return this.failReason;
            }
        }
        if (this.fragments == null) {
            this.fragments = new TreeMap();
        }
        this.fragments.put(fbpkgs.bg, nfbpkgs);
        return null;
    }

    void fragmentIsZombie(BundleImpl fb) {
        if (null != this.exports) {
            if (this.bg.bundle.fwCtx.debug.resolver) {
                this.bg.bundle.fwCtx.debug.println(((Object)new StringBuffer().append("Marking all packages exported by host bundle(id=").append(this.bg.bundle.id).append(",gen=").append(this.bg.generation).append(") as zombies since the attached fragment (id=").append(fb.getBundleId()).append(") was updated/uninstalled.")).toString());
            }
            for (ExportPkg exportPkg : this.exports) {
                exportPkg.zombie = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detachFragmentSynchronized(BundleGeneration fbg, boolean unregister) {
        if (this.fragments != null) {
            TreeMap<BundleGeneration, BundlePackages> treeMap = this.fragments;
            synchronized (treeMap) {
                this.detachFragment(fbg, unregister);
            }
        }
    }

    void unregister() {
        this.registered = false;
        this.unRequireBundles();
    }

    public String toString() {
        return ((Object)new StringBuffer().append("BundlePackages").append(this.bundleGenInfo())).toString();
    }

    String bundleGenInfo() {
        return ((Object)new StringBuffer().append("[id=").append(this.bg.bundle.id).append(",gen=").append(this.bg.generation).append("]")).toString();
    }

    boolean isActive() {
        return this.okImports != null;
    }

    private ImportPkg getImport(String pkg) {
        int i = Util.binarySearch(this.imports, ipFind, pkg);
        if (i >= 0) {
            return this.imports.get(i);
        }
        return null;
    }

    private void unRequireBundles() {
        if (this.require != null) {
            for (RequireBundle req : this.require) {
                if (null == req.bpkgs || null == req.bpkgs.requiredBy) continue;
                req.bpkgs.requiredBy.remove(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detachFragments() {
        if (this.fragments != null) {
            TreeMap<BundleGeneration, BundlePackages> treeMap = this.fragments;
            synchronized (treeMap) {
                while (!this.fragments.isEmpty()) {
                    this.detachFragment(this.fragments.lastKey(), false);
                }
                this.fragments = null;
            }
        }
    }

    private void detachFragment(BundleGeneration fbg, boolean unregisterPkg) {
        BundlePackages fbpkgs;
        if (null == this.okImports && (fbpkgs = this.fragments.remove(fbg)) != null) {
            if (unregisterPkg) {
                fbpkgs.unregisterPackages(true);
            } else {
                fbpkgs.unregister();
            }
        }
    }

    void parseDynamicImports(String s) {
        for (Util.HeaderEntry he : Util.parseManifestHeader("DynamicImport-Package", s, false, true, false)) {
            if (he.getDirectives().containsKey("resolution")) {
                throw new IllegalArgumentException("DynamicImport-Package entry illegal contains a resolution directive.");
            }
            ImportPkg tmpl = null;
            for (String key : he.getKeys()) {
                if (key.equals("*")) {
                    key = EMPTY_STRING;
                } else if (key.endsWith(".*")) {
                    key = key.substring(0, key.length() - 1);
                } else {
                    if (key.endsWith(".")) {
                        throw new IllegalArgumentException(((Object)new StringBuffer().append("DynamicImport-Package entry ends with '.': ").append(key)).toString());
                    }
                    if (key.indexOf("*") != -1) {
                        throw new IllegalArgumentException(((Object)new StringBuffer().append("DynamicImport-Package entry contains a '*': ").append(key)).toString());
                    }
                }
                if (tmpl != null) {
                    this.dImportPatterns.add(new ImportPkg(tmpl, key));
                    continue;
                }
                tmpl = new ImportPkg(key, he, this, true);
                this.dImportPatterns.add(tmpl);
            }
        }
    }
}

