/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.knopflerfish.framework.BundleContextImpl;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.RemoveOnlyCollection;
import org.knopflerfish.framework.ServiceListenerEntry;
import org.knopflerfish.framework.ServiceReferenceImpl;
import org.knopflerfish.framework.ServiceRegistrationImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.EventListenerHook;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServiceHooks {
    private final FrameworkContext fwCtx;
    ServiceTracker<ListenerHook, ListenerHook> listenerHookTracker;
    boolean bOpen;
    static /* synthetic */ Class class$org$osgi$framework$hooks$service$ListenerHook;
    static /* synthetic */ Class class$org$osgi$framework$hooks$service$FindHook;
    static /* synthetic */ Class class$org$osgi$framework$hooks$service$EventHook;
    static /* synthetic */ Class class$org$osgi$framework$hooks$service$EventListenerHook;

    ServiceHooks(FrameworkContext fwCtx) {
        this.fwCtx = fwCtx;
    }

    synchronized void open() {
        if (this.fwCtx.debug.hooks) {
            this.fwCtx.debug.println("opening hooks");
        }
        this.listenerHookTracker = new ServiceTracker<ListenerHook, ListenerHook>((BundleContext)this.fwCtx.systemBundle.bundleContext, class$org$osgi$framework$hooks$service$ListenerHook == null ? (class$org$osgi$framework$hooks$service$ListenerHook = ServiceHooks.class$("org.osgi.framework.hooks.service.ListenerHook")) : class$org$osgi$framework$hooks$service$ListenerHook, new ServiceTrackerCustomizer<ListenerHook, ListenerHook>(){

            @Override
            public ListenerHook addingService(ServiceReference<ListenerHook> reference) {
                ListenerHook lh = ((ServiceHooks)ServiceHooks.this).fwCtx.systemBundle.bundleContext.getService(reference);
                try {
                    Collection<ListenerHook.ListenerInfo> c;
                    Collection<ListenerHook.ListenerInfo> li = c = ServiceHooks.this.getServiceCollection();
                    lh.added(li);
                }
                catch (Exception e) {
                    ((ServiceHooks)ServiceHooks.this).fwCtx.debug.printStackTrace(((Object)new StringBuffer().append("Failed to call listener hook  #").append(reference.getProperty("service.id"))).toString(), e);
                }
                return lh;
            }

            @Override
            public void modifiedService(ServiceReference<ListenerHook> reference, ListenerHook service) {
            }

            @Override
            public void removedService(ServiceReference<ListenerHook> reference, ListenerHook service) {
                ((ServiceHooks)ServiceHooks.this).fwCtx.systemBundle.bundleContext.ungetService(reference);
            }

            @Override
            public /* synthetic */ void removedService(ServiceReference x0, Object x1) {
                this.removedService((ServiceReference<ListenerHook>)x0, (ListenerHook)x1);
            }

            @Override
            public /* synthetic */ void modifiedService(ServiceReference x0, Object x1) {
                this.modifiedService((ServiceReference<ListenerHook>)x0, (ListenerHook)x1);
            }

            @Override
            public /* synthetic */ Object addingService(ServiceReference x0) {
                return this.addingService(x0);
            }
        });
        this.listenerHookTracker.open();
        this.bOpen = true;
    }

    synchronized void close() {
        this.listenerHookTracker.close();
        this.listenerHookTracker = null;
        this.bOpen = false;
    }

    public synchronized boolean isOpen() {
        return this.bOpen;
    }

    void filterServiceReferences(BundleContextImpl bc, String service, String filter, boolean allServices, Collection<ServiceReference<?>> refs) {
        List<ServiceRegistrationImpl<?>> srl = this.fwCtx.services.get((class$org$osgi$framework$hooks$service$FindHook == null ? (class$org$osgi$framework$hooks$service$FindHook = ServiceHooks.class$("org.osgi.framework.hooks.service.FindHook")) : class$org$osgi$framework$hooks$service$FindHook).getName());
        if (srl != null) {
            RemoveOnlyCollection filtered = new RemoveOnlyCollection(refs);
            for (ServiceRegistrationImpl<?> fhr : srl) {
                ServiceReferenceImpl sr = fhr.reference;
                FindHook fh = (FindHook)sr.getService(this.fwCtx.systemBundle);
                if (fh == null) continue;
                try {
                    fh.find(bc, service, filter, allServices, filtered);
                }
                catch (Exception e) {
                    this.fwCtx.frameworkError(bc, (Throwable)new BundleException(((Object)new StringBuffer().append("Failed to call find hook  #").append(sr.getProperty("service.id"))).toString(), e), new FrameworkListener[0]);
                }
            }
        }
    }

    void filterServiceEventReceivers(ServiceEvent evt, Collection<ServiceListenerEntry> receivers) {
        List<ServiceRegistrationImpl<?>> eventListenerHooks;
        Object filtered;
        List<ServiceRegistrationImpl<?>> eventHooks = this.fwCtx.services.get((class$org$osgi$framework$hooks$service$EventHook == null ? (class$org$osgi$framework$hooks$service$EventHook = ServiceHooks.class$("org.osgi.framework.hooks.service.EventHook")) : class$org$osgi$framework$hooks$service$EventHook).getName());
        if (eventHooks != null) {
            HashSet<BundleContext> ctxs = new HashSet<BundleContext>();
            for (ServiceListenerEntry sle : receivers) {
                ctxs.add(sle.getBundleContext());
            }
            int start_size = ctxs.size();
            filtered = new RemoveOnlyCollection(ctxs);
            for (ServiceRegistrationImpl<?> sregi : eventHooks) {
                ServiceReferenceImpl sr = sregi.reference;
                EventHook eh = (EventHook)sr.getService(this.fwCtx.systemBundle);
                if (eh == null) continue;
                try {
                    eh.event(evt, (Collection<BundleContext>)filtered);
                }
                catch (Exception e) {
                    this.fwCtx.debug.printStackTrace(((Object)new StringBuffer().append("Failed to call event hook  #").append(sr.getProperty("service.id"))).toString(), e);
                }
            }
            if (start_size != ctxs.size()) {
                Iterator<ServiceListenerEntry> iterator = receivers.iterator();
                while (iterator.hasNext()) {
                    if (ctxs.contains(iterator.next().getBundleContext())) continue;
                    iterator.remove();
                }
            }
        }
        if ((eventListenerHooks = this.fwCtx.services.get((class$org$osgi$framework$hooks$service$EventListenerHook == null ? (class$org$osgi$framework$hooks$service$EventListenerHook = ServiceHooks.class$("org.osgi.framework.hooks.service.EventListenerHook")) : class$org$osgi$framework$hooks$service$EventListenerHook).getName())) != null) {
            HashMap listeners = new HashMap();
            for (ServiceListenerEntry serviceListenerEntry : receivers) {
                if (!listeners.containsKey(serviceListenerEntry.getBundleContext())) {
                    listeners.put(serviceListenerEntry.getBundleContext(), new ArrayList());
                }
                ((Collection)listeners.get(serviceListenerEntry.getBundleContext())).add(serviceListenerEntry);
            }
            for (Map.Entry entry : listeners.entrySet()) {
                entry.setValue(new RemoveOnlyCollection((Collection)entry.getValue()));
            }
            filtered = new RemoveOnlyMap(listeners);
            for (ServiceRegistrationImpl<?> sri : eventListenerHooks) {
                EventListenerHook elh = (EventListenerHook)sri.reference.getService(this.fwCtx.systemBundle);
                if (elh == null) continue;
                try {
                    elh.event(evt, (Map<BundleContext, Collection<ListenerHook.ListenerInfo>>)filtered);
                }
                catch (Exception e) {
                    this.fwCtx.debug.printStackTrace(((Object)new StringBuffer().append("Failed to call event hook  #").append(sri.reference.getProperty("service.id"))).toString(), e);
                }
            }
            receivers.clear();
            Iterator iterator = listeners.values().iterator();
            while (iterator.hasNext()) {
                Collection li;
                Collection sles = li = (Collection)iterator.next();
                receivers.addAll(sles);
            }
        }
    }

    Collection<ServiceListenerEntry> getServiceCollection() {
        return Collections.unmodifiableSet(this.fwCtx.listeners.serviceListeners.serviceSet);
    }

    void handleServiceListenerReg(ServiceListenerEntry sle) {
        if (!this.isOpen() || this.listenerHookTracker.size() == 0) {
            return;
        }
        ServiceReference<ListenerHook>[] srl = this.listenerHookTracker.getServiceReferences();
        Set<ListenerHook.ListenerInfo> set = ServiceHooks.toImmutableSet(sle);
        if (srl != null) {
            for (ServiceReference<ListenerHook> sr : srl) {
                ListenerHook lh = this.listenerHookTracker.getService(sr);
                try {
                    lh.added(set);
                }
                catch (Exception e) {
                    this.fwCtx.debug.printStackTrace(((Object)new StringBuffer().append("Failed to call listener hook #").append(sr.getProperty("service.id"))).toString(), e);
                }
            }
        }
    }

    void handleServiceListenerUnreg(ServiceListenerEntry sle) {
        if (this.isOpen()) {
            this.handleServiceListenerUnreg(ServiceHooks.toImmutableSet(sle));
        }
    }

    void handleServiceListenerUnreg(Collection<ServiceListenerEntry> set) {
        if (!this.isOpen() || this.listenerHookTracker.size() == 0) {
            return;
        }
        ServiceReference<ListenerHook>[] srl = this.listenerHookTracker.getServiceReferences();
        if (srl != null) {
            Collection<ListenerHook.ListenerInfo> lis = set;
            for (ServiceReference<ListenerHook> sr : srl) {
                ListenerHook lh = this.listenerHookTracker.getService(sr);
                try {
                    lh.removed(lis);
                }
                catch (Exception e) {
                    this.fwCtx.debug.printStackTrace(((Object)new StringBuffer().append("Failed to call listener hook #").append(sr.getProperty("service.id"))).toString(), e);
                }
            }
        }
    }

    static <E> Set<E> toImmutableSet(E obj) {
        Set<E> set = new HashSet<E>();
        set.add(obj);
        set = Collections.unmodifiableSet(set);
        return set;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RemoveOnlyMap<K, V>
    implements Map<K, V> {
        final Map<K, V> original;

        public RemoveOnlyMap(Map<K, V> original) {
            this.original = original;
        }

        @Override
        public void clear() {
            this.original.clear();
        }

        @Override
        public boolean containsKey(Object k) {
            return this.original.containsKey(k);
        }

        @Override
        public boolean containsValue(Object v) {
            return this.original.containsValue(v);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.original.entrySet();
        }

        @Override
        public V get(Object k) {
            return this.original.get(k);
        }

        @Override
        public boolean isEmpty() {
            return this.original.isEmpty();
        }

        @Override
        public Set<K> keySet() {
            return this.original.keySet();
        }

        @Override
        public V put(Object k, Object v) {
            throw new UnsupportedOperationException("objects can only be removed");
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            throw new UnsupportedOperationException("objects can only be removed");
        }

        @Override
        public V remove(Object k) {
            return this.original.remove(k);
        }

        @Override
        public int size() {
            return this.original.size();
        }

        @Override
        public Collection<V> values() {
            return this.original.values();
        }
    }
}

