/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.SortedMap;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.FrameworkContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.weaving.WeavingException;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

class WeavingHooks {
    private final FrameworkContext fwCtx;
    ServiceTracker<WeavingHook, TrackedWeavingHook> weavingHookTracker;

    WeavingHooks(FrameworkContext fwCtx) {
        this.fwCtx = fwCtx;
    }

    synchronized void open() {
        if (this.fwCtx.debug.hooks) {
            this.fwCtx.debug.println("Begin Tracking Weaving Hooks");
        }
        this.weavingHookTracker = new ServiceTracker<WeavingHook, TrackedWeavingHook>((BundleContext)this.fwCtx.systemBundle.bundleContext, WeavingHook.class, new ServiceTrackerCustomizer<WeavingHook, TrackedWeavingHook>(){

            @Override
            public TrackedWeavingHook addingService(ServiceReference<WeavingHook> reference) {
                return new TrackedWeavingHook(((WeavingHooks)WeavingHooks.this).fwCtx.systemBundle.bundleContext.getService(reference), reference);
            }

            @Override
            public void modifiedService(ServiceReference<WeavingHook> reference, TrackedWeavingHook service) {
            }

            @Override
            public void removedService(ServiceReference<WeavingHook> reference, TrackedWeavingHook service) {
            }

            @Override
            public /* synthetic */ void removedService(ServiceReference x0, Object x1) {
                this.removedService((ServiceReference<WeavingHook>)x0, (TrackedWeavingHook)x1);
            }

            @Override
            public /* synthetic */ void modifiedService(ServiceReference x0, Object x1) {
                this.modifiedService((ServiceReference<WeavingHook>)x0, (TrackedWeavingHook)x1);
            }

            @Override
            public /* synthetic */ Object addingService(ServiceReference x0) {
                return this.addingService(x0);
            }
        });
        this.weavingHookTracker.open();
    }

    synchronized void close() {
        this.weavingHookTracker.close();
        this.weavingHookTracker = null;
    }

    public synchronized boolean isOpen() {
        return this.weavingHookTracker != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized void callHooks(WovenClassImpl wc) throws Exception {
        if (!this.isOpen()) {
            return;
        }
        if (wc.isWeavingComplete()) {
            throw new RuntimeException("ERROR!!");
        }
        try {
            SortedMap<ServiceReference<WeavingHook>, TrackedWeavingHook> hooks = this.weavingHookTracker.getTracked();
            Iterator<TrackedWeavingHook> i$ = hooks.values().iterator();
            while (i$.hasNext()) {
                TrackedWeavingHook twh = i$.next();
                if (twh.isBlackListed()) continue;
                try {
                    twh.weave(wc);
                }
                catch (WeavingException we) {
                    this.fwCtx.frameworkError(twh.reference.getBundle(), (Throwable)we, new FrameworkListener[0]);
                    ClassFormatError cfe = new ClassFormatError("WeavingException thrown: " + we.getMessage() + " by hook " + twh.getClass().getName());
                    cfe.initCause(we);
                    throw cfe;
                }
                catch (Throwable t) {
                    this.fwCtx.frameworkError(twh.reference.getBundle(), t, new FrameworkListener[0]);
                    twh.blacklist();
                    ClassFormatError cfe = new ClassFormatError("Exception throw: " + t + " while calling hook " + twh.getClass().getName());
                    cfe.initCause(t);
                    throw cfe;
                    return;
                }
            }
        }
        finally {
            wc.markAsComplete();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DynamicListIterator<E>
    implements ListIterator<E> {
        private final WovenClassImpl parent;
        private final ListIterator<E> org;

        public DynamicListIterator(WovenClassImpl parent, ListIterator<E> org) {
            this.parent = parent;
            this.org = org;
        }

        @Override
        public void add(E elem) {
            this.checkChangeAllowed();
            this.org.add(elem);
        }

        @Override
        public boolean hasNext() {
            return this.org.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.org.hasPrevious();
        }

        @Override
        public E next() {
            return this.org.next();
        }

        @Override
        public int nextIndex() {
            return this.org.nextIndex();
        }

        @Override
        public E previous() {
            return this.org.previous();
        }

        @Override
        public int previousIndex() {
            return this.org.previousIndex();
        }

        @Override
        public void remove() {
            this.checkChangeAllowed();
            this.org.remove();
        }

        @Override
        public void set(E elem) {
            this.checkChangeAllowed();
            this.org.set(elem);
        }

        private void checkChangeAllowed() throws UnsupportedOperationException {
            if (this.parent.isWeavingComplete()) {
                throw new IllegalStateException("Parent WovenClass is frozen");
            }
            this.parent.bundle.fwCtx.perm.checkWeaveAdminPerm(this.parent.bundle);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DynamicImportList<E>
    implements List<E> {
        private final List<E> org;
        private final WovenClassImpl parent;

        public DynamicImportList(WovenClassImpl parent) {
            this.parent = parent;
            this.org = new ArrayList();
        }

        public DynamicImportList(WovenClassImpl parent, List<E> subList) {
            this.parent = parent;
            this.org = subList;
        }

        @Override
        public boolean add(E elem) {
            this.checkChangeAllowed();
            return this.org.add(elem);
        }

        @Override
        public void add(int index, E elem) {
            this.checkChangeAllowed();
            this.org.add(index, elem);
        }

        @Override
        public boolean addAll(Collection<? extends E> elems) {
            this.checkChangeAllowed();
            return this.org.addAll(elems);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> elems) {
            this.checkChangeAllowed();
            return this.org.addAll(index, elems);
        }

        @Override
        public void clear() {
            this.checkChangeAllowed();
            this.org.clear();
        }

        @Override
        public boolean contains(Object elem) {
            return this.org.contains(elem);
        }

        @Override
        public boolean containsAll(Collection<?> elems) {
            return this.org.containsAll(elems);
        }

        @Override
        public E get(int index) {
            return this.org.get(index);
        }

        @Override
        public int indexOf(Object elem) {
            return this.org.indexOf(elem);
        }

        @Override
        public boolean isEmpty() {
            return this.org.isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            return new DynamicListIterator<E>(this.parent, this.org.listIterator());
        }

        @Override
        public int lastIndexOf(Object elem) {
            return this.org.lastIndexOf(elem);
        }

        @Override
        public ListIterator<E> listIterator() {
            return new DynamicListIterator<E>(this.parent, this.org.listIterator());
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new DynamicListIterator<E>(this.parent, this.org.listIterator(index));
        }

        @Override
        public E remove(int index) {
            this.checkChangeAllowed();
            return this.org.remove(index);
        }

        @Override
        public boolean remove(Object elem) {
            this.checkChangeAllowed();
            return this.org.remove(elem);
        }

        @Override
        public boolean removeAll(Collection<?> elems) {
            this.checkChangeAllowed();
            return this.org.removeAll(elems);
        }

        @Override
        public boolean retainAll(Collection<?> elems) {
            this.checkChangeAllowed();
            return this.org.removeAll(elems);
        }

        @Override
        public E set(int index, E elem) {
            this.checkChangeAllowed();
            return this.org.set(index, elem);
        }

        @Override
        public int size() {
            return this.org.size();
        }

        @Override
        public List<E> subList(int from, int to) {
            return new DynamicImportList<E>(this.parent, this.org.subList(from, to));
        }

        @Override
        public Object[] toArray() {
            return this.org.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.org.toArray(a);
        }

        private void checkChangeAllowed() throws UnsupportedOperationException {
            if (this.parent.isWeavingComplete()) {
                throw new IllegalStateException("Parent WovenClass is frozen");
            }
            this.parent.bundle.fwCtx.perm.checkWeaveAdminPerm(this.parent.bundle);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WovenClassImpl
    implements WovenClass {
        final BundleImpl bundle;
        final String name;
        byte[] current = null;
        boolean complete = false;
        Class<?> c = null;
        final List<String> dynamicImports = new DynamicImportList<String>(this);

        WovenClassImpl(BundleImpl bundle, String name, byte[] initial) {
            this.bundle = bundle;
            this.name = name;
            this.current = initial;
        }

        @Override
        public byte[] getBytes() {
            this.bundle.fwCtx.perm.checkWeaveAdminPerm(this.bundle);
            if (this.complete) {
                byte[] r = new byte[this.current.length];
                System.arraycopy(this.current, 0, r, 0, this.current.length);
                return r;
            }
            return this.current;
        }

        @Override
        public void setBytes(byte[] newBytes) {
            this.bundle.fwCtx.perm.checkWeaveAdminPerm(this.bundle);
            if (this.complete) {
                throw new IllegalStateException("Trying to call WovenClass.setBytes(byte[]) after weaving is complete");
            }
            if (newBytes == null) {
                throw new NullPointerException("Trying to call WovenClass.setBytes(byte[]) with null newBytes");
            }
            this.current = newBytes;
        }

        @Override
        public List<String> getDynamicImports() {
            return this.dynamicImports;
        }

        @Override
        public boolean isWeavingComplete() {
            return this.complete;
        }

        @Override
        public String getClassName() {
            return this.name;
        }

        @Override
        public ProtectionDomain getProtectionDomain() {
            return this.c == null ? null : this.c.getProtectionDomain();
        }

        @Override
        public Class<?> getDefinedClass() {
            return this.c;
        }

        @Override
        public BundleWiring getBundleWiring() {
            return this.bundle.current().bundleRevision.getWiring();
        }

        void markAsComplete() {
            this.complete = true;
        }

        void setDefinedClass(Class<?> c) {
            this.markAsComplete();
            this.c = c;
        }

        public String toString() {
            return ((Object)new StringBuffer().append("WovenClass[").append(this.name).append(", ").append(this.toString(this.dynamicImports)).append(", byte[").append(this.current.length).append("]=").append(this.current).append("]")).toString();
        }

        String getDynamicImportsAsString() {
            StringBuffer sb = new StringBuffer();
            for (String s : this.dynamicImports) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(s);
            }
            return ((Object)sb).toString();
        }

        String toString(List<String> sl) {
            StringBuffer sb = new StringBuffer();
            sb.append("(");
            for (String s : sl) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                sb.append(s);
            }
            sb.append(")");
            return ((Object)sb).toString();
        }

        public boolean hasAdditionalDynamicImports() {
            return !this.dynamicImports.isEmpty();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TrackedWeavingHook
    implements WeavingHook {
        final WeavingHook tracked;
        final ServiceReference<WeavingHook> reference;
        boolean blacklisted = false;

        TrackedWeavingHook(WeavingHook tracked, ServiceReference<WeavingHook> reference) {
            this.tracked = tracked;
            this.reference = reference;
        }

        @Override
        public void weave(WovenClass wovenClass) {
            this.tracked.weave(wovenClass);
        }

        void blacklist() {
            this.blacklisted = true;
        }

        boolean isBlackListed() {
            return this.blacklisted;
        }
    }
}

