/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.bundlestorage.memory;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleResourceStream;
import org.knopflerfish.framework.FileArchive;
import org.knopflerfish.framework.HeaderDictionary;
import org.knopflerfish.framework.bundlestorage.memory.Archive;
import org.knopflerfish.framework.bundlestorage.memory.BundleStorageImpl;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BundleArchiveImpl
implements BundleArchive {
    private final Archive archive;
    private BundleGeneration bundleGeneration = null;
    private final long id;
    private final String location;
    private int autostartSetting = -1;
    private final BundleStorageImpl storage;
    private Archive[] archives;
    private int startLevel = -1;
    private long lastModified;
    private ArrayList<String> failedPath = null;

    BundleArchiveImpl(BundleStorageImpl bundleStorage, InputStream is, String bundleLocation, long bundleId) throws Exception {
        this.archive = new Archive(this, is);
        this.storage = bundleStorage;
        this.id = bundleId;
        this.location = bundleLocation;
        this.setClassPath();
    }

    BundleArchiveImpl(BundleArchiveImpl old, InputStream is) throws Exception {
        this.location = old.location;
        this.storage = old.storage;
        this.id = old.id;
        this.autostartSetting = old.autostartSetting;
        this.archive = new Archive(this, is);
        this.setClassPath();
    }

    @Override
    public String getAttribute(String key) {
        return this.archive.getAttribute(key);
    }

    @Override
    public FileArchive getFileArchive(String path) {
        for (Archive a : this.archives) {
            if (!a.path.equals(path)) continue;
            return a;
        }
        return null;
    }

    @Override
    public Hashtable<String, String> getLocalizationEntries(String localeFile) {
        BundleResourceStream is = this.archive.getBundleResourceStream(localeFile);
        if (is != null) {
            Properties ht;
            Properties l = new Properties();
            try {
                l.load(is);
            }
            catch (IOException _ignore) {
                // empty catch block
            }
            try {
                is.close();
            }
            catch (IOException _ignore) {
                // empty catch block
            }
            Properties res = ht = l;
            return res;
        }
        return null;
    }

    @Override
    public HeaderDictionary getUnlocalizedAttributes() {
        return new HeaderDictionary(this.archive.manifest.getMainAttributes());
    }

    @Override
    public BundleGeneration getBundleGeneration() {
        return this.bundleGeneration;
    }

    @Override
    public void setBundleGeneration(BundleGeneration bg) {
        this.bundleGeneration = bg;
    }

    @Override
    public long getBundleId() {
        return this.id;
    }

    @Override
    public String getBundleLocation() {
        return this.location;
    }

    @Override
    public int getStartLevel() {
        return this.startLevel;
    }

    @Override
    public void setStartLevel(int level) {
        this.startLevel = level;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public void setLastModified(long timemillisecs) throws IOException {
        this.lastModified = timemillisecs;
    }

    public byte[] getClassBytes(Integer sub, String path) throws IOException {
        return this.archives[sub].getClassBytes(path);
    }

    @Override
    public BundleResourceStream getBundleResourceStream(String component, int ix) {
        if (component.startsWith("/")) {
            component = component.substring(1);
        }
        if (ix == -1) {
            return this.archive.getBundleResourceStream(component);
        }
        return this.archives[ix].getBundleResourceStream(component);
    }

    public String getNativeLibrary(String libName) {
        return null;
    }

    @Override
    public void setAutostartSetting(int setting) throws IOException {
        if (setting != this.autostartSetting) {
            this.autostartSetting = setting;
        }
    }

    @Override
    public int getAutostartSetting() {
        return this.autostartSetting;
    }

    @Override
    public void purge() {
        this.storage.removeArchive(this);
    }

    @Override
    public void close() {
    }

    public List<String> getFailedClassPathEntries() {
        return this.failedPath;
    }

    public String resolveNativeCode() {
        if (this.getAttribute("Bundle-NativeCode") != null) {
            return "Native code not allowed by memory storage";
        }
        return null;
    }

    private void setClassPath() throws IOException {
        String bcp = this.getAttribute("Bundle-ClassPath");
        if (bcp != null) {
            ArrayList<Archive> a = new ArrayList<Archive>();
            StringTokenizer st = new StringTokenizer(bcp, ",");
            while (st.hasMoreTokens()) {
                String path = st.nextToken().trim();
                if (".".equals(path)) {
                    a.add(this.archive);
                    continue;
                }
                if (path.endsWith(".jar")) {
                    try {
                        a.add(this.archive.getSubArchive(path));
                    }
                    catch (IOException ioe) {
                        if (this.failedPath == null) {
                            this.failedPath = new ArrayList(1);
                        }
                        this.failedPath.add(path);
                    }
                    continue;
                }
                if (this.archive.subDirs == null) {
                    this.archive.subDirs = new ArrayList(1);
                }
                this.archive.subDirs.add(path);
            }
            this.archives = a.toArray(new Archive[a.size()]);
        } else {
            this.archives = new Archive[]{this.archive};
        }
    }

    @Override
    public Enumeration<String> findResourcesPath(String path) {
        return this.archive.findResourcesPath(path);
    }

    @Override
    public String getJarLocation() {
        return null;
    }

    @Override
    public ArrayList<List<X509Certificate>> getCertificateChains(boolean onlyTrusted) {
        return null;
    }

    @Override
    public void trustCertificateChain(List<X509Certificate> trustedChain) {
        throw new RuntimeException("NYI");
    }
}

