/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.components.LogData;
import fitnesse.http.HttpException;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ErrorResponder;
import fitnesse.socketservice.SocketFactory;
import fitnesse.util.Clock;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class FitNesseExpediter
implements ResponseSender {
    private static final Logger LOG = Logger.getLogger(FitNesseExpediter.class.getName());
    private final Socket socket;
    private final InputStream input;
    private final OutputStream output;
    private Request request;
    private Response response;
    private final FitNesseContext context;
    protected long requestParsingTimeLimit;
    private long requestProgress;
    private long requestParsingDeadline;
    private volatile boolean hasError;

    public FitNesseExpediter(Socket s, FitNesseContext context) throws IOException {
        this.context = context;
        this.socket = s;
        this.input = s.getInputStream();
        this.output = s.getOutputStream();
        this.requestParsingTimeLimit = 10000L;
    }

    public void start() {
        try {
            Request request = this.makeRequest();
            this.makeResponse(request);
            this.sendResponse();
        }
        catch (SocketException se) {
        }
        catch (Throwable e) {
            LOG.log(Level.WARNING, "Unexpected exception", e);
        }
    }

    public void setRequestParsingTimeLimit(long t) {
        this.requestParsingTimeLimit = t;
    }

    public long getRequestParsingTimeLimit() {
        return this.requestParsingTimeLimit;
    }

    @Override
    public void send(byte[] bytes) {
        try {
            this.output.write(bytes);
            this.output.flush();
        }
        catch (IOException e) {
            LOG.log(Level.INFO, "Output stream closed unexpectedly (Stop button pressed?)", e);
        }
    }

    @Override
    public void close() {
        try {
            this.log(this.socket, this.request, this.response);
            this.socket.close();
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Error while closing socket", e);
        }
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }

    public Request makeRequest() {
        this.request = new Request(this.input);
        this.request.setPeerDn(SocketFactory.peerDn(this.socket));
        this.request.setContextRoot(this.context.contextRoot);
        return this.request;
    }

    public void sendResponse() throws IOException {
        this.response.sendTo(this);
    }

    private Response makeResponse(Request request) throws SocketException {
        try {
            Thread parseThread = this.createParsingThread(request);
            parseThread.start();
            this.waitForRequest(request);
            if (!this.hasError) {
                if (this.context.contextRoot.equals(request.getRequestUri() + "/")) {
                    this.response = new SimpleResponse();
                    this.response.redirect(this.context.contextRoot, "");
                } else {
                    this.response = this.createGoodResponse(request);
                }
            }
        }
        catch (SocketException se) {
            throw se;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unable to handle request", e);
            this.response = new ErrorResponder(e).makeResponse(this.context, request);
        }
        this.response.addHeader("Server", "FitNesse-" + this.context.version);
        this.response.addHeader("Connection", "close");
        return this.response;
    }

    public Response createGoodResponse(Request request) throws Exception {
        if (StringUtils.isBlank(request.getResource()) && StringUtils.isBlank(request.getQueryString())) {
            request.setResource("FrontPage");
        }
        Responder responder = this.context.responderFactory.makeResponder(request);
        responder = this.context.authenticator.authenticate(this.context, request, responder);
        return responder.makeResponse(this.context, request);
    }

    private void waitForRequest(Request request) throws InterruptedException {
        long now = Clock.currentTimeInMillis();
        this.requestParsingDeadline = now + this.requestParsingTimeLimit;
        this.requestProgress = 0L;
        while (!this.hasError && !request.hasBeenParsed()) {
            Thread.sleep(10L);
            if (!this.timeIsUp() || !this.parsingIsUnproductive(request)) continue;
            this.reportError(408, "The client request has been unproductive for too long. It has timed out and will now longer be processed.");
        }
    }

    private boolean parsingIsUnproductive(Request request) {
        long updatedRequestProgress = request.numberOfBytesParsed();
        if (updatedRequestProgress > this.requestProgress) {
            this.requestProgress = updatedRequestProgress;
            return false;
        }
        return true;
    }

    private boolean timeIsUp() {
        long now = Clock.currentTimeInMillis();
        if (now > this.requestParsingDeadline) {
            this.requestParsingDeadline = now + this.requestParsingTimeLimit;
            return true;
        }
        return false;
    }

    private Thread createParsingThread(final Request request) {
        Thread parseThread = new Thread(){

            @Override
            public synchronized void run() {
                try {
                    request.parse();
                }
                catch (HttpException e) {
                    FitNesseExpediter.this.reportError(400, e.getMessage());
                }
                catch (Exception e) {
                    FitNesseExpediter.this.reportError(e);
                }
            }
        };
        return parseThread;
    }

    private void reportError(int status, String message) {
        try {
            this.response = new ErrorResponder(message).makeResponse(this.context, this.request);
            this.response.setStatus(status);
            this.hasError = true;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Can not report error (status = " + status + ", message = " + message + ")", e);
        }
    }

    private void reportError(Exception e) {
        this.response = new ErrorResponder(e).makeResponse(this.context, this.request);
        this.hasError = true;
    }

    public static LogData makeLogData(Socket socket, Request request, Response response) {
        LogData data = new LogData(((InetSocketAddress)socket.getRemoteSocketAddress()).getAddress().getHostAddress(), new GregorianCalendar(), request.getRequestLine(), response.getStatus(), response.getContentSize(), request.getAuthorizationUsername());
        return data;
    }

    public void log(Socket s, Request request, Response response) {
        if (this.context.logger != null) {
            this.context.logger.log(FitNesseExpediter.makeLogData(s, request, response));
        }
    }
}

