/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner;

import fitnesse.testrunner.PageListSetUpTearDownSurrounder;
import fitnesse.testrunner.SuiteContentsFinder;
import fitnesse.testrunner.WikiPageIdentity;
import fitnesse.testrunner.WikiTestPage;
import fitnesse.testsystems.TestPage;
import fitnesse.wiki.WikiPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PagesByTestSystem {
    private final WikiPage root;
    private final Map<WikiPageIdentity, List<TestPage>> pagesByTestSystem;

    public PagesByTestSystem(List<WikiPage> pages, WikiPage root) {
        this.root = root;
        this.pagesByTestSystem = this.addSuiteSetUpAndTearDownToAllTestSystems(this.mapWithAllPagesButSuiteSetUpAndTearDown(pages));
    }

    private Map<WikiPageIdentity, List<WikiPage>> mapWithAllPagesButSuiteSetUpAndTearDown(List<WikiPage> pages) {
        HashMap<WikiPageIdentity, List<WikiPage>> pagesByTestSystem = new HashMap<WikiPageIdentity, List<WikiPage>>(2);
        for (WikiPage wikiPage : pages) {
            if (SuiteContentsFinder.isSuiteSetupOrTearDown(wikiPage)) continue;
            WikiPageIdentity identity = new WikiPageIdentity(wikiPage);
            this.getOrMakeListWithinMap(pagesByTestSystem, identity).add(wikiPage);
        }
        return pagesByTestSystem;
    }

    private List<WikiPage> getOrMakeListWithinMap(Map<WikiPageIdentity, List<WikiPage>> pagesByTestSystem, WikiPageIdentity descriptor) {
        LinkedList<WikiPage> pagesForTestSystem;
        if (!pagesByTestSystem.containsKey(descriptor)) {
            pagesForTestSystem = new LinkedList();
            pagesByTestSystem.put(descriptor, pagesForTestSystem);
        } else {
            pagesForTestSystem = pagesByTestSystem.get(descriptor);
        }
        return pagesForTestSystem;
    }

    private Map<WikiPageIdentity, List<TestPage>> addSuiteSetUpAndTearDownToAllTestSystems(Map<WikiPageIdentity, List<WikiPage>> pagesByTestSystem) {
        HashMap<WikiPageIdentity, List<TestPage>> orderedPagesByTestSystem = new HashMap<WikiPageIdentity, List<TestPage>>(pagesByTestSystem.size());
        if (!pagesByTestSystem.isEmpty()) {
            PageListSetUpTearDownSurrounder surrounder = new PageListSetUpTearDownSurrounder(this.root);
            for (Map.Entry<WikiPageIdentity, List<WikiPage>> pages : pagesByTestSystem.entrySet()) {
                orderedPagesByTestSystem.put(pages.getKey(), this.asTestPages(surrounder.surroundGroupsOfTestPagesWithRespectiveSetUpAndTearDowns(pages.getValue())));
            }
        }
        return orderedPagesByTestSystem;
    }

    private List<TestPage> asTestPages(List<WikiPage> wikiPages) {
        ArrayList<TestPage> testPages = new ArrayList<TestPage>(wikiPages.size());
        for (WikiPage page : wikiPages) {
            testPages.add(new WikiTestPage(page));
        }
        return testPages;
    }

    public int totalTestsToRun() {
        int tests = 0;
        for (List<TestPage> listOfPagesToRun : this.pagesByTestSystem.values()) {
            tests += listOfPagesToRun.size();
        }
        return tests;
    }

    public Collection<WikiPageIdentity> identities() {
        return this.pagesByTestSystem.keySet();
    }

    public List<TestPage> testPagesForIdentity(WikiPageIdentity identity) {
        return Collections.unmodifiableList(this.pagesByTestSystem.get(identity));
    }
}

