/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim;

import fitnesse.slim.SlimError;
import fitnesse.slim.SlimException;
import fitnesse.slim.SlimStreamReader;
import fitnesse.slim.instructions.Instruction;
import fitnesse.slim.instructions.InstructionExecutor;
import fitnesse.slim.protocol.SlimDeserializer;
import fitnesse.slim.protocol.SlimSerializer;
import fitnesse.socketservice.SocketFactory;
import fitnesse.testsystems.CommandRunner;
import fitnesse.testsystems.slim.SlimClient;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.ArrayUtils;

public class SlimCommandRunningClient
implements SlimClient {
    private static final Logger LOG = Logger.getLogger(SlimCommandRunningClient.class.getName());
    public static final int NO_SLIM_SERVER_CONNECTION_FLAG = -32000;
    public static double MINIMUM_REQUIRED_SLIM_VERSION = 0.3;
    private final CommandRunner slimRunner;
    private final int connectionTimeout;
    private final double requiredSlimVersion;
    private Socket client;
    private SlimStreamReader reader;
    private OutputStream writer;
    private String slimServerVersionMessage;
    private double slimServerVersion;
    private String hostName;
    private int port;
    private boolean useSSL;
    private String sslParameterClassName;

    public SlimCommandRunningClient(CommandRunner slimRunner, String hostName, int port, int connectionTimeout, double requiredSlimVersion, boolean useSSL, String sslParameterClassName) {
        this.slimRunner = slimRunner;
        this.hostName = hostName;
        this.port = port;
        this.connectionTimeout = connectionTimeout;
        this.requiredSlimVersion = requiredSlimVersion;
        this.useSSL = useSSL;
        this.sslParameterClassName = sslParameterClassName;
    }

    @Override
    public void start() throws IOException {
        this.slimRunner.asynchronousStart();
        this.connect();
        this.checkForVersionMismatch();
    }

    private void checkForVersionMismatch() {
        double serverVersionNumber = this.getServerVersion();
        if (serverVersionNumber == -32000.0) {
            throw new SlimError("Slim Protocol Version Error: Server did not respond with a valid version number.");
        }
        if (serverVersionNumber < this.requiredSlimVersion) {
            throw new SlimError(String.format("Slim Protocol Version Error: Expected V%s but was V%s", this.requiredSlimVersion, serverVersionNumber));
        }
    }

    @Override
    public void kill() throws IOException {
        if (this.slimRunner != null) {
            this.slimRunner.kill();
        }
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    public void connect() throws IOException {
        int sleepStep = 50;
        int maxTries = this.connectionTimeout * 1000 / 50;
        while (this.client == null) {
            if (this.slimRunner != null && this.slimRunner.isDead()) {
                throw new SlimError("Error SLiM server died before a conection could be established.");
            }
            LOG.finest("Trying to connect to host: " + this.hostName + " on port: " + this.port + " SSL=" + this.useSSL + " timeout setting: " + this.connectionTimeout + " remaining retries: " + maxTries);
            try {
                --maxTries;
                this.client = SocketFactory.tryCreateClientSocket(this.hostName, this.port, this.useSSL, this.sslParameterClassName);
            }
            catch (IOException e) {
                if (maxTries <= 1) {
                    throw new SlimError("Error connecting to SLiM server on " + this.hostName + ":" + this.port, e);
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException i) {
                    throw new SlimError("Wait for connection interrupted.");
                }
            }
        }
        LOG.fine("Connected to host: " + this.hostName + " on port: " + this.port + " SSL=" + this.useSSL + " timeout setting: " + this.connectionTimeout + " remaining retries: " + maxTries);
        this.reader = SlimStreamReader.getReader(this.client);
        this.writer = SlimStreamReader.getByteWriter(this.client);
        this.client.setSoTimeout(this.connectionTimeout * 1000);
        this.validateConnection(this.useSSL);
        this.client.setSoTimeout(this.connectionTimeout * 1000);
    }

    private void validateConnection(boolean isSslConnection) throws IOException {
        int waittime = this.connectionTimeout * 1000;
        if (isSslConnection) {
            waittime = 0;
        }
        this.reader.setTimeoutLimit(waittime);
        this.slimServerVersionMessage = this.reader.readLine();
        this.reader.setTimeoutLimit(0);
        LOG.finest("Read Slim Header: >" + this.slimServerVersionMessage + "<");
        if (this.reader.isTimeout()) {
            throw new SlimError("Timeout while reading slim header from client. Read the following: " + this.slimServerVersionMessage);
        }
        if (!this.isConnected()) {
            throw new SlimError("Got invalid slim header from client. Read the following: " + this.slimServerVersionMessage);
        }
        try {
            this.slimServerVersion = Double.parseDouble(this.slimServerVersionMessage.replace("Slim -- V", ""));
        }
        catch (Exception e) {
            this.slimServerVersion = -32000.0;
            throw new SlimError("Got invalid slim version from Client. Read the following: " + this.slimServerVersionMessage);
        }
        LOG.fine("Got Slim Header: " + this.slimServerVersionMessage + ", and Version " + this.slimServerVersion);
    }

    public double getServerVersion() {
        return this.slimServerVersion;
    }

    public boolean isConnected() {
        return this.slimServerVersionMessage.startsWith("Slim -- V");
    }

    public String getPeerName() {
        return SocketFactory.peerName(this.client);
    }

    public String getMyName() {
        return SocketFactory.myName(this.client);
    }

    @Override
    public Map<String, Object> invokeAndGetResponse(List<Instruction> statements) throws IOException {
        if (statements.isEmpty()) {
            return new HashMap<String, Object>();
        }
        String instructions = SlimSerializer.serialize(this.toList(statements));
        SlimStreamReader.sendSlimMessage(this.writer, instructions);
        String results = this.reader.getSlimMessage();
        List<Object> resultList = SlimDeserializer.deserialize(results);
        return SlimCommandRunningClient.resultToMap(resultList);
    }

    private List<Object> toList(List<Instruction> instructions) {
        final ArrayList<Object> statementsAsList = new ArrayList<Object>(instructions.size());
        for (final Instruction instruction : instructions) {
            ToListExecutor executor = new ToListExecutor(){

                @Override
                public void addPath(String path) throws SlimException {
                    statementsAsList.add(Arrays.asList(instruction.getId(), "import", path));
                }

                @Override
                public Object callAndAssign(String symbolName, String instanceName, String methodsName, Object ... arguments) throws SlimException {
                    Object[] list = new Object[]{instruction.getId(), "callAndAssign", symbolName, instanceName, methodsName};
                    statementsAsList.add(Arrays.asList(ArrayUtils.addAll(list, arguments)));
                    return null;
                }

                @Override
                public Object call(String instanceName, String methodName, Object ... arguments) throws SlimException {
                    Object[] list = new Object[]{instruction.getId(), "call", instanceName, methodName};
                    statementsAsList.add(Arrays.asList(ArrayUtils.addAll(list, arguments)));
                    return null;
                }

                @Override
                public void create(String instanceName, String className, Object ... constructorArgs) throws SlimException {
                    Object[] list = new Object[]{instruction.getId(), "make", instanceName, className};
                    statementsAsList.add(Arrays.asList(ArrayUtils.addAll(list, constructorArgs)));
                }

                @Override
                public void assign(String symbolName, Object value) {
                    if (SlimCommandRunningClient.this.slimServerVersion < 0.4) {
                        throw new SlimError("The assign instruction is available as of SLIM protocol version 0.4");
                    }
                    Object[] list = new Object[]{instruction.getId(), "assign", symbolName, value};
                    statementsAsList.add(Arrays.asList(list));
                }
            };
            instruction.execute(executor);
        }
        return statementsAsList;
    }

    @Override
    public void bye() throws IOException {
        SlimStreamReader.sendSlimMessage(this.writer, "bye");
        this.writer.close();
        this.reader.close();
        this.client.close();
        this.slimRunner.join();
        this.kill();
    }

    public static Map<String, Object> resultToMap(List<?> slimResults) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Object aResult : slimResults) {
            List resultList = (List)aResult;
            map.put((String)resultList.get(0), resultList.get(1));
        }
        return map;
    }

    private static interface ToListExecutor
    extends InstructionExecutor {
    }
}

