/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.slim.instructions.CallInstruction;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.tables.DecisionTableCaller;
import fitnesse.testsystems.slim.tables.SlimAssertion;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.SyntaxError;
import java.util.ArrayList;
import java.util.List;

public class DynamicDecisionTable
extends SlimTable {
    private static final String TABLE_TYPE = "dynamicDecisionTable";

    public DynamicDecisionTable(Table table, String id, SlimTestContext testContext) {
        super(table, id, testContext);
    }

    @Override
    protected String getTableType() {
        return TABLE_TYPE;
    }

    @Override
    public List<SlimAssertion> getAssertions() throws SyntaxError {
        if (this.table.getRowCount() == 2) {
            throw new SyntaxError("DynamicDecisionTables should have at least three rows.");
        }
        return new FixtureCaller().call(this.getFixtureName());
    }

    private class FixtureCaller
    extends DecisionTableCaller {
        public FixtureCaller() {
            super(DynamicDecisionTable.this.table);
        }

        public List<SlimAssertion> call(String fixtureName) throws SyntaxError {
            ArrayList<SlimAssertion> assertions = new ArrayList<SlimAssertion>();
            assertions.add(DynamicDecisionTable.this.constructFixture(fixtureName));
            assertions.add(DynamicDecisionTable.this.makeAssertion(DynamicDecisionTable.this.callFunction(DynamicDecisionTable.this.getTableName(), "table", DynamicDecisionTable.this.tableAsList()), new SlimTable.SilentReturnExpectation(DynamicDecisionTable.this, 0, 0)));
            if (DynamicDecisionTable.this.table.getRowCount() > 2) {
                assertions.addAll(this.invokeRows());
            }
            return assertions;
        }

        private List<SlimAssertion> invokeRows() throws SyntaxError {
            ArrayList<SlimAssertion> assertions = new ArrayList<SlimAssertion>();
            assertions.add(this.callUnreportedFunction("beginTable", 0));
            this.gatherFunctionsAndVariablesFromColumnHeader();
            for (int row = 2; row < DynamicDecisionTable.this.table.getRowCount(); ++row) {
                assertions.addAll(this.invokeRow(row));
            }
            assertions.add(this.callUnreportedFunction("endTable", 0));
            return assertions;
        }

        private List<SlimAssertion> invokeRow(int row) throws SyntaxError {
            ArrayList<SlimAssertion> assertions = new ArrayList<SlimAssertion>();
            this.checkRow(row);
            assertions.add(this.callUnreportedFunction("reset", row));
            assertions.addAll(this.callSetForVariables(row));
            assertions.add(this.callUnreportedFunction("execute", row));
            assertions.addAll(this.callGetForFunctions(row));
            return assertions;
        }

        private SlimAssertion callUnreportedFunction(String functionName, int row) {
            return DynamicDecisionTable.this.makeAssertion(DynamicDecisionTable.this.callFunction(DynamicDecisionTable.this.getTableName(), functionName, new Object[0]), new SlimTable.SilentReturnExpectation(DynamicDecisionTable.this, 0, row));
        }

        private List<SlimAssertion> callGetForFunctions(int row) {
            ArrayList<SlimAssertion> instructions = new ArrayList<SlimAssertion>();
            for (String functionName : this.funcStore.getLeftToRightAndResetColumnNumberIterator()) {
                instructions.add(this.callGetForFunctionInRow(functionName, row));
            }
            return instructions;
        }

        private SlimAssertion callGetForFunctionInRow(String functionName, int row) {
            int col = this.funcStore.getColumnNumber(functionName);
            String assignedSymbol = DynamicDecisionTable.this.ifSymbolAssignment(col, row);
            SlimAssertion assertion = assignedSymbol != null ? DynamicDecisionTable.this.makeAssertion(DynamicDecisionTable.this.callAndAssign(assignedSymbol, DynamicDecisionTable.this.getTableName(), "get", functionName), new SlimTable.SymbolAssignmentExpectation((SlimTable)DynamicDecisionTable.this, assignedSymbol, col, row)) : DynamicDecisionTable.this.makeAssertion(DynamicDecisionTable.this.callFunction(DynamicDecisionTable.this.getTableName(), "get", functionName), new SlimTable.ReturnedValueExpectation(DynamicDecisionTable.this, col, row));
            return assertion;
        }

        private List<SlimAssertion> callSetForVariables(int row) {
            ArrayList<SlimAssertion> assertions = new ArrayList<SlimAssertion>();
            for (String var : this.varStore.getLeftToRightAndResetColumnNumberIterator()) {
                int col = this.varStore.getColumnNumber(var);
                String valueToSet = DynamicDecisionTable.this.table.getCellContents(col, row);
                CallInstruction setInstruction = new CallInstruction(DynamicDecisionTable.this.makeInstructionTag(), DynamicDecisionTable.this.getTableName(), "set", new Object[]{var, valueToSet});
                assertions.add(DynamicDecisionTable.this.makeAssertion(setInstruction, new SlimTable.VoidReturnExpectation(DynamicDecisionTable.this, col, row)));
            }
            return assertions;
        }
    }
}

