/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.fs;

import fitnesse.util.Clock;
import fitnesse.wiki.BaseWikiPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageType;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wiki.fs.ExternalTestPage;
import fitnesse.wiki.fs.FileSystem;
import fitnesse.wikitext.parser.VariableSource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ExternalSuitePage
extends BaseWikiPage {
    public static final String HTML = ".html";
    private File path;
    private FileSystem fileSystem;

    public ExternalSuitePage(File path, String name, BaseWikiPage parent, FileSystem fileSystem, VariableSource variableSource) {
        super(name, parent, variableSource);
        this.path = path;
        this.fileSystem = fileSystem;
    }

    @Override
    public WikiPage addChildPage(String name) {
        return null;
    }

    @Override
    public boolean hasChildPage(String pageName) {
        return this.getChildPage(pageName) != null;
    }

    @Override
    public void removeChildPage(String name) {
    }

    @Override
    public PageData getData() {
        return this.makePageData();
    }

    @Override
    public Collection<VersionInfo> getVersions() {
        return Collections.emptySet();
    }

    @Override
    public WikiPage getVersion(String versionName) {
        return null;
    }

    @Override
    public VersionInfo commit(PageData data) {
        return null;
    }

    @Override
    public List<WikiPage> getChildren() {
        return this.findChildren();
    }

    @Override
    public WikiPage getChildPage(String name) {
        for (WikiPage child : this.findChildren()) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    private List<WikiPage> findChildren() {
        ArrayList<WikiPage> children = new ArrayList<WikiPage>();
        for (String child : this.fileSystem.list(this.path)) {
            File childPath = new File(this.path, child);
            if (child.endsWith(HTML)) {
                children.add(new ExternalTestPage(childPath, child.replace(HTML, ""), this, this.fileSystem, this.getVariableSource()));
                continue;
            }
            if (!this.hasHtmlChild(childPath).booleanValue()) continue;
            children.add(new ExternalSuitePage(childPath, child, this, this.fileSystem, this.getVariableSource()));
        }
        return children;
    }

    private Boolean hasHtmlChild(File path) {
        if (path.getName().endsWith(HTML)) {
            return true;
        }
        for (String child : this.fileSystem.list(path)) {
            if (!this.hasHtmlChild(new File(path, child)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private PageData makePageData() {
        WikiPageProperties properties = new WikiPageProperties();
        properties.set(PageType.SUITE.toString());
        properties.set("WhereUsed");
        properties.set("RecentChanges");
        properties.set("Files");
        properties.set("Versions");
        properties.set("Search");
        properties.setLastModificationTime(Clock.currentDate());
        return new PageData("!contents", properties);
    }
}

