/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.fitnesse;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;

public class TestSummary {
    public final String name;
    public final Set<String> tags;
    public final long timestamp;
    public final int duration;
    public final int right;
    public final int wrong;
    public final String result;
    public final int exceptions;
    public final String firstError;

    public TestSummary(String name, Set<String> tags, long timestamp, int duration, int right, int wrong, String result, int exceptions, String firstError) {
        this.name = name;
        this.tags = tags;
        this.timestamp = timestamp;
        this.duration = duration;
        this.right = right;
        this.wrong = wrong;
        this.result = wrong + exceptions > 0 ? "FAILED" : "PASSED";
        this.exceptions = exceptions;
        this.firstError = firstError;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.duration ^ this.duration >>> 32);
        result = 31 * result + this.exceptions;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.right;
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.wrong;
        result = 31 * result + (this.firstError == null ? 0 : this.firstError.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestSummary other = (TestSummary)obj;
        if (this.duration != other.duration) {
            return false;
        }
        if (this.exceptions != other.exceptions) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.result == null ? other.result != null : !this.result.equals(other.result)) {
            return false;
        }
        if (this.right != other.right) {
            return false;
        }
        if (this.tags == null ? other.tags != null : !this.tags.equals(other.tags)) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        if (this.wrong != other.wrong) {
            return false;
        }
        return !(this.firstError == null ? other.firstError != null : !this.firstError.equals(other.firstError));
    }

    public String toString() {
        JsonArrayBuilder tagBuilder = Json.createArrayBuilder();
        for (String s : this.tags) {
            tagBuilder.add(s);
        }
        JsonObjectBuilder obj = Json.createObjectBuilder();
        obj.add("type", "result").add("name", this.name).add("timestamp", this.timestamp).add("duration", this.duration).add("right", this.right).add("wrong", this.wrong).add("result", this.result).add("exceptions", this.exceptions);
        if (this.firstError != null) {
            obj.add("firstError", this.firstError);
        }
        return obj.toString();
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.name);
        map.put("timestamp", this.timestamp);
        map.put("duration", this.duration);
        map.put("right", this.right);
        map.put("wrong", this.wrong);
        map.put("result", this.result);
        map.put("exceptions", this.exceptions);
        if (this.firstError != null) {
            map.put("firstError", this.firstError);
        }
        return map;
    }
}

