/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStatus;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexStatus;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotShardsStats;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotStats;
import org.elasticsearch.cluster.metadata.SnapshotId;
import org.elasticsearch.cluster.metadata.SnapshotMetaData;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentFactory;

public class SnapshotStatus
implements ToXContent,
Streamable {
    private SnapshotId snapshotId;
    private SnapshotMetaData.State state;
    private ImmutableList<SnapshotIndexShardStatus> shards;
    private ImmutableMap<String, SnapshotIndexStatus> indicesStatus;
    private SnapshotShardsStats shardsStats;
    private SnapshotStats stats;

    SnapshotStatus(SnapshotId snapshotId, SnapshotMetaData.State state, ImmutableList<SnapshotIndexShardStatus> shards) {
        this.snapshotId = snapshotId;
        this.state = state;
        this.shards = shards;
        this.shardsStats = new SnapshotShardsStats(shards);
        this.updateShardStats();
    }

    SnapshotStatus() {
    }

    public SnapshotId getSnapshotId() {
        return this.snapshotId;
    }

    public SnapshotMetaData.State getState() {
        return this.state;
    }

    public List<SnapshotIndexShardStatus> getShards() {
        return this.shards;
    }

    public SnapshotShardsStats getShardsStats() {
        return this.shardsStats;
    }

    public Map<String, SnapshotIndexStatus> getIndices() {
        if (this.indicesStatus != null) {
            return this.indicesStatus;
        }
        ImmutableMap.Builder<String, SnapshotIndexStatus> indicesStatus = ImmutableMap.builder();
        HashSet<String> indices = Sets.newHashSet();
        for (SnapshotIndexShardStatus shard : this.shards) {
            indices.add(shard.getIndex());
        }
        for (String index : indices) {
            ArrayList<SnapshotIndexShardStatus> shards = Lists.newArrayList();
            for (SnapshotIndexShardStatus shard : this.shards) {
                if (!shard.getIndex().equals(index)) continue;
                shards.add(shard);
            }
            indicesStatus.put(index, new SnapshotIndexStatus(index, shards));
        }
        this.indicesStatus = indicesStatus.build();
        return this.indicesStatus;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.snapshotId = SnapshotId.readSnapshotId(in);
        this.state = SnapshotMetaData.State.fromValue(in.readByte());
        int size = in.readVInt();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            builder.add(SnapshotIndexShardStatus.readShardSnapshotStatus(in));
        }
        this.shards = builder.build();
        this.updateShardStats();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.snapshotId.writeTo(out);
        out.writeByte(this.state.value());
        out.writeVInt(this.shards.size());
        for (SnapshotIndexShardStatus shard : this.shards) {
            shard.writeTo(out);
        }
    }

    public static SnapshotStatus readSnapshotStatus(StreamInput in) throws IOException {
        SnapshotStatus snapshotInfo = new SnapshotStatus();
        snapshotInfo.readFrom(in);
        return snapshotInfo;
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return builder.string();
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }

    public SnapshotStats getStats() {
        return this.stats;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Fields.SNAPSHOT, this.snapshotId.getSnapshot());
        builder.field(Fields.REPOSITORY, this.snapshotId.getRepository());
        builder.field(Fields.STATE, this.state.name());
        this.shardsStats.toXContent(builder, params);
        this.stats.toXContent(builder, params);
        builder.startObject(Fields.INDICES);
        for (SnapshotIndexStatus indexStatus : this.getIndices().values()) {
            indexStatus.toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    private void updateShardStats() {
        this.stats = new SnapshotStats();
        this.shardsStats = new SnapshotShardsStats(this.shards);
        for (SnapshotIndexShardStatus shard : this.shards) {
            this.stats.add(shard.getStats());
        }
    }

    static final class Fields {
        static final XContentBuilderString SNAPSHOT = new XContentBuilderString("snapshot");
        static final XContentBuilderString REPOSITORY = new XContentBuilderString("repository");
        static final XContentBuilderString STATE = new XContentBuilderString("state");
        static final XContentBuilderString INDICES = new XContentBuilderString("indices");

        Fields() {
        }
    }
}

