/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.action.search.type.TransportSearchTypeAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.action.SearchServiceListener;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchTransportRequest;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.threadpool.ThreadPool;

public class TransportSearchDfsQueryAndFetchAction
extends TransportSearchTypeAction {
    @Inject
    public TransportSearchDfsQueryAndFetchAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, SearchServiceTransportAction searchService, SearchPhaseController searchPhaseController, ActionFilters actionFilters) {
        super(settings, threadPool, clusterService, searchService, searchPhaseController, actionFilters);
    }

    @Override
    protected void doExecute(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        new AsyncAction(searchRequest, listener).start();
    }

    private class AsyncAction
    extends TransportSearchTypeAction.BaseAsyncAction<DfsSearchResult> {
        private final AtomicArray<QueryFetchSearchResult> queryFetchResults;

        private AsyncAction(SearchRequest request, ActionListener<SearchResponse> listener) {
            super(request, listener);
            this.queryFetchResults = new AtomicArray(this.firstResults.length());
        }

        @Override
        protected String firstPhaseName() {
            return "dfs";
        }

        @Override
        protected void sendExecuteFirstPhase(DiscoveryNode node, ShardSearchTransportRequest request, SearchServiceListener<DfsSearchResult> listener) {
            TransportSearchDfsQueryAndFetchAction.this.searchService.sendExecuteDfs(node, request, listener);
        }

        @Override
        protected void moveToSecondPhase() {
            AggregatedDfs dfs = TransportSearchDfsQueryAndFetchAction.this.searchPhaseController.aggregateDfs(this.firstResults);
            AtomicInteger counter = new AtomicInteger(this.firstResults.asList().size());
            for (AtomicArray.Entry entry : this.firstResults.asList()) {
                DfsSearchResult dfsResult = (DfsSearchResult)entry.value;
                DiscoveryNode node = this.nodes.get(dfsResult.shardTarget().nodeId());
                QuerySearchRequest querySearchRequest = new QuerySearchRequest(this.request, dfsResult.id(), dfs);
                this.executeSecondPhase(entry.index, dfsResult, counter, node, querySearchRequest);
            }
        }

        void executeSecondPhase(final int shardIndex, final DfsSearchResult dfsResult, final AtomicInteger counter, DiscoveryNode node, final QuerySearchRequest querySearchRequest) {
            TransportSearchDfsQueryAndFetchAction.this.searchService.sendExecuteFetch(node, querySearchRequest, new SearchServiceListener<QueryFetchSearchResult>(){

                @Override
                public void onResult(QueryFetchSearchResult result) {
                    result.shardTarget(dfsResult.shardTarget());
                    AsyncAction.this.queryFetchResults.set(shardIndex, result);
                    if (counter.decrementAndGet() == 0) {
                        AsyncAction.this.finishHim();
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    AsyncAction.this.onSecondPhaseFailure(t, querySearchRequest, shardIndex, dfsResult, counter);
                }
            });
        }

        void onSecondPhaseFailure(Throwable t, QuerySearchRequest querySearchRequest, int shardIndex, DfsSearchResult dfsResult, AtomicInteger counter) {
            if (TransportSearchDfsQueryAndFetchAction.this.logger.isDebugEnabled()) {
                TransportSearchDfsQueryAndFetchAction.this.logger.debug("[{}] Failed to execute query phase", t, querySearchRequest.id());
            }
            this.addShardFailure(shardIndex, dfsResult.shardTarget(), t);
            this.successfulOps.decrementAndGet();
            if (counter.decrementAndGet() == 0) {
                this.finishHim();
            }
        }

        private void finishHim() {
            TransportSearchDfsQueryAndFetchAction.this.threadPool.executor("search").execute(new ActionRunnable(this.listener){

                @Override
                public void doRun() throws IOException {
                    boolean useScroll = !AsyncAction.this.useSlowScroll && AsyncAction.this.request.scroll() != null;
                    AsyncAction.this.sortedShardList = TransportSearchDfsQueryAndFetchAction.this.searchPhaseController.sortDocs(useScroll, AsyncAction.this.queryFetchResults);
                    InternalSearchResponse internalResponse = TransportSearchDfsQueryAndFetchAction.this.searchPhaseController.merge(AsyncAction.this.sortedShardList, AsyncAction.this.queryFetchResults, AsyncAction.this.queryFetchResults);
                    String scrollId = null;
                    if (AsyncAction.this.request.scroll() != null) {
                        scrollId = TransportSearchHelper.buildScrollId(AsyncAction.this.request.searchType(), (AtomicArray<? extends SearchPhaseResult>)AsyncAction.this.firstResults, null);
                    }
                    this.listener.onResponse(new SearchResponse(internalResponse, scrollId, AsyncAction.this.expectedSuccessfulOps, AsyncAction.this.successfulOps.get(), AsyncAction.this.buildTookInMillis(), AsyncAction.this.buildShardFailures()));
                }

                @Override
                public void onFailure(Throwable t) {
                    ReduceSearchPhaseException failure = new ReduceSearchPhaseException("query_fetch", "", t, AsyncAction.this.buildShardFailures());
                    if (TransportSearchDfsQueryAndFetchAction.this.logger.isDebugEnabled()) {
                        TransportSearchDfsQueryAndFetchAction.this.logger.debug("failed to reduce search", failure, new Object[0]);
                    }
                    super.onFailure(t);
                }
            });
        }
    }
}

