/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Locale;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.NoClassSettingsException;

public class Classes {
    private static final char PACKAGE_SEPARATOR = '.';

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = Classes.class.getClassLoader();
        }
        return cl;
    }

    public static String getPackageName(Class<?> clazz) {
        String className = clazz.getName();
        int lastDotIndex = className.lastIndexOf(46);
        return lastDotIndex != -1 ? className.substring(0, lastDotIndex) : "";
    }

    public static String getPackageNameNoDomain(Class<?> clazz) {
        String fullPackage = Classes.getPackageName(clazz);
        if (fullPackage.startsWith("org.") || fullPackage.startsWith("com.") || fullPackage.startsWith("net.")) {
            return fullPackage.substring(4);
        }
        return fullPackage;
    }

    public static boolean isInnerClass(Class<?> clazz) {
        return !Modifier.isStatic(clazz.getModifiers()) && clazz.getEnclosingClass() != null;
    }

    public static boolean isConcrete(Class<?> clazz) {
        int modifiers = clazz.getModifiers();
        return !clazz.isInterface() && !Modifier.isAbstract(modifiers);
    }

    public static <T> Class<? extends T> loadClass(ClassLoader classLoader, String className, String prefixPackage, String suffixClassName) {
        return Classes.loadClass(classLoader, className, prefixPackage, suffixClassName, null);
    }

    public static <T> Class<? extends T> loadClass(ClassLoader classLoader, String className, String prefixPackage, String suffixClassName, String errorPrefix) {
        Object[] classNames;
        Throwable t = null;
        for (String string : classNames = Classes.classNames(className, prefixPackage, suffixClassName)) {
            try {
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException ex) {
                t = ex;
            }
            catch (NoClassDefFoundError er) {
                t = er;
            }
        }
        if (errorPrefix == null) {
            errorPrefix = "failed to load class";
        }
        throw new NoClassSettingsException(errorPrefix + " with value [" + className + "]; tried " + Arrays.toString(classNames), t);
    }

    private static String[] classNames(String className, String prefixPackage, String suffixClassName) {
        String prefixValue = prefixPackage;
        int packageSeparator = className.lastIndexOf(46);
        String classNameValue = className;
        if (packageSeparator > 0) {
            prefixValue = className.substring(0, packageSeparator + 1);
            classNameValue = className.substring(packageSeparator + 1);
        }
        return new String[]{className, prefixValue + Strings.capitalize(Strings.toCamelCase(classNameValue)) + suffixClassName, prefixValue + Strings.toCamelCase(classNameValue) + "." + Strings.capitalize(Strings.toCamelCase(classNameValue)) + suffixClassName, prefixValue + Strings.toCamelCase(classNameValue).toLowerCase(Locale.ROOT) + "." + Strings.capitalize(Strings.toCamelCase(classNameValue)) + suffixClassName};
    }

    private Classes() {
    }
}

