/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class DisMaxQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<DisMaxQueryBuilder> {
    private ArrayList<QueryBuilder> queries = Lists.newArrayList();
    private float boost = -1.0f;
    private float tieBreaker = -1.0f;
    private String queryName;

    public DisMaxQueryBuilder add(QueryBuilder queryBuilder) {
        this.queries.add(queryBuilder);
        return this;
    }

    @Override
    public DisMaxQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public DisMaxQueryBuilder tieBreaker(float tieBreaker) {
        this.tieBreaker = tieBreaker;
        return this;
    }

    public DisMaxQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("dis_max");
        if (this.tieBreaker != -1.0f) {
            builder.field("tie_breaker", this.tieBreaker);
        }
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        builder.startArray("queries");
        for (QueryBuilder queryBuilder : this.queries) {
            queryBuilder.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
    }
}

