/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore.fieldvaluefactor;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lucene.search.function.FieldValueFactorFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.functionscore.ScoreFunctionParser;
import org.elasticsearch.search.internal.SearchContext;

public class FieldValueFactorFunctionParser
implements ScoreFunctionParser {
    public static String[] NAMES = new String[]{"field_value_factor", "fieldValueFactor"};

    @Override
    public ScoreFunction parse(QueryParseContext parseContext, XContentParser parser) throws IOException, QueryParsingException {
        XContentParser.Token token;
        String currentFieldName = null;
        String field = null;
        float boostFactor = 1.0f;
        FieldValueFactorFunction.Modifier modifier = FieldValueFactorFunction.Modifier.NONE;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("field".equals(currentFieldName)) {
                    field = parser.text();
                    continue;
                }
                if ("factor".equals(currentFieldName)) {
                    boostFactor = parser.floatValue();
                    continue;
                }
                if ("modifier".equals(currentFieldName)) {
                    modifier = FieldValueFactorFunction.Modifier.valueOf(parser.text().toUpperCase(Locale.ROOT));
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), NAMES[0] + " query does not support [" + currentFieldName + "]");
            }
            if (!"factor".equals(currentFieldName) || token != XContentParser.Token.START_ARRAY && token != XContentParser.Token.START_OBJECT) continue;
            throw new QueryParsingException(parseContext.index(), "[" + NAMES[0] + "] field 'factor' does not support lists or objects");
        }
        if (field == null) {
            throw new QueryParsingException(parseContext.index(), "[" + NAMES[0] + "] required field 'field' missing");
        }
        SearchContext searchContext = SearchContext.current();
        FieldMapper mapper = searchContext.mapperService().smartNameFieldMapper(field);
        if (mapper == null) {
            throw new ElasticsearchException("Unable to find a field mapper for field [" + field + "]");
        }
        return new FieldValueFactorFunction(field, boostFactor, modifier, (IndexNumericFieldData)searchContext.fieldData().getForField(mapper));
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

