/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.cat;

import org.elasticsearch.client.Client;
import org.elasticsearch.common.Table;
import org.elasticsearch.common.io.UTF8StreamWriter;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestTable;

public abstract class AbstractCatAction
extends BaseRestHandler {
    public AbstractCatAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
    }

    abstract void doRequest(RestRequest var1, RestChannel var2, Client var3);

    abstract void documentation(StringBuilder var1);

    abstract Table getTableWithHeader(RestRequest var1);

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) throws Exception {
        boolean helpWanted = request.paramAsBoolean("help", false);
        if (helpWanted) {
            Table table = this.getTableWithHeader(request);
            int[] width = RestTable.buildHelpWidths(table, request);
            BytesStreamOutput bytesOutput = channel.bytesOutput();
            UTF8StreamWriter out = new UTF8StreamWriter().setOutput(bytesOutput);
            for (Table.Cell cell : table.getHeaders()) {
                RestTable.pad(new Table.Cell(cell.value), width[0], request, out);
                out.append(" | ");
                RestTable.pad(new Table.Cell(cell.attr.containsKey("alias") ? cell.attr.get("alias") : ""), width[1], request, out);
                out.append(" | ");
                RestTable.pad(new Table.Cell(cell.attr.containsKey("desc") ? cell.attr.get("desc") : "not available"), width[2], request, out);
                out.append("\n");
            }
            out.close();
            channel.sendResponse(new BytesRestResponse(RestStatus.OK, "text/plain; charset=UTF-8", bytesOutput.bytes(), true));
        } else {
            this.doRequest(request, channel, client);
        }
    }
}

