/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.scripted;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.ScriptParameterParser;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.scripted.InternalScriptedMetric;
import org.elasticsearch.search.aggregations.metrics.scripted.ScriptedMetricAggregator;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptedMetricParser
implements Aggregator.Parser {
    public static final String INIT_SCRIPT = "init_script";
    public static final String MAP_SCRIPT = "map_script";
    public static final String COMBINE_SCRIPT = "combine_script";
    public static final String REDUCE_SCRIPT = "reduce_script";
    public static final ParseField PARAMS_FIELD = new ParseField("params", new String[0]);
    public static final ParseField REDUCE_PARAMS_FIELD = new ParseField("reduce_params", new String[0]);
    public static final ParseField LANG_FIELD = new ParseField("lang", new String[0]);

    @Override
    public String type() {
        return InternalScriptedMetric.TYPE.name();
    }

    @Override
    public AggregatorFactory parse(String aggregationName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        Map<String, Object> params = null;
        Map<String, Object> reduceParams = null;
        String currentFieldName = null;
        HashSet<String> scriptParameters = new HashSet<String>();
        scriptParameters.add(INIT_SCRIPT);
        scriptParameters.add(MAP_SCRIPT);
        scriptParameters.add(COMBINE_SCRIPT);
        scriptParameters.add(REDUCE_SCRIPT);
        ScriptParameterParser scriptParameterParser = new ScriptParameterParser(scriptParameters);
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (PARAMS_FIELD.match(currentFieldName)) {
                    params = parser.map();
                    continue;
                }
                if (REDUCE_PARAMS_FIELD.match(currentFieldName)) {
                    reduceParams = parser.map();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            if (token.isValue()) {
                if (scriptParameterParser.token(currentFieldName, token, parser)) continue;
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            throw new SearchParseException(context, "Unexpected token " + (Object)((Object)token) + " in [" + aggregationName + "].");
        }
        ScriptParameterParser.ScriptParameterValue initScriptValue = scriptParameterParser.getScriptParameterValue(INIT_SCRIPT);
        String initScript = null;
        ScriptService.ScriptType initScriptType = null;
        if (initScriptValue != null) {
            initScript = initScriptValue.script();
            initScriptType = initScriptValue.scriptType();
        }
        ScriptParameterParser.ScriptParameterValue mapScriptValue = scriptParameterParser.getScriptParameterValue(MAP_SCRIPT);
        String mapScript = null;
        ScriptService.ScriptType mapScriptType = null;
        if (mapScriptValue != null) {
            mapScript = mapScriptValue.script();
            mapScriptType = mapScriptValue.scriptType();
        }
        ScriptParameterParser.ScriptParameterValue combineScriptValue = scriptParameterParser.getScriptParameterValue(COMBINE_SCRIPT);
        String combineScript = null;
        ScriptService.ScriptType combineScriptType = null;
        if (combineScriptValue != null) {
            combineScript = combineScriptValue.script();
            combineScriptType = combineScriptValue.scriptType();
        }
        ScriptParameterParser.ScriptParameterValue reduceScriptValue = scriptParameterParser.getScriptParameterValue(REDUCE_SCRIPT);
        String reduceScript = null;
        ScriptService.ScriptType reduceScriptType = null;
        if (reduceScriptValue != null) {
            reduceScript = reduceScriptValue.script();
            reduceScriptType = reduceScriptValue.scriptType();
        }
        String scriptLang = scriptParameterParser.lang();
        if (mapScript == null) {
            throw new SearchParseException(context, "map_script field is required in [" + aggregationName + "].");
        }
        return new ScriptedMetricAggregator.Factory(aggregationName, scriptLang, initScriptType, initScript, mapScriptType, mapScript, combineScriptType, combineScript, reduceScriptType, reduceScript, params, reduceParams);
    }
}

