/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support.values;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.elasticsearch.index.fielddata.SortingNumericDoubleValues;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.support.ScriptValues;

public class ScriptDoubleValues
extends SortingNumericDoubleValues
implements ScriptValues {
    final SearchScript script;

    public ScriptDoubleValues(SearchScript script) {
        this.script = script;
    }

    @Override
    public SearchScript script() {
        return this.script;
    }

    @Override
    public void setDocument(int docId) {
        this.script.setNextDocId(docId);
        Object value = this.script.run();
        if (value == null) {
            this.count = 0;
        } else if (value instanceof Number) {
            this.count = 1;
            this.values[0] = ((Number)value).doubleValue();
        } else if (value.getClass().isArray()) {
            this.count = Array.getLength(value);
            this.grow();
            for (int i = 0; i < this.count; ++i) {
                this.values[i] = ((Number)Array.get(value, i)).doubleValue();
            }
        } else if (value instanceof Collection) {
            this.count = ((Collection)value).size();
            this.grow();
            int i = 0;
            Iterator it = ((Collection)value).iterator();
            while (it.hasNext()) {
                this.values[i] = ((Number)it.next()).doubleValue();
                ++i;
            }
            assert (i == this.count);
        } else {
            throw new AggregationExecutionException("Unsupported script value [" + value + "]");
        }
        this.sort();
    }
}

