/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.datehistogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.datehistogram.DateHistogramFacet;
import org.elasticsearch.search.facet.datehistogram.InternalDateHistogramFacet;

public class InternalFullDateHistogramFacet
extends InternalDateHistogramFacet {
    private static final BytesReference STREAM_TYPE = new HashedBytesArray(Strings.toUTF8Bytes("fdHistogram"));
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(StreamInput in) throws IOException {
            return InternalFullDateHistogramFacet.readHistogramFacet(in);
        }
    };
    private DateHistogramFacet.ComparatorType comparatorType;
    List<FullEntry> entries;

    public static void registerStreams() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public BytesReference streamType() {
        return STREAM_TYPE;
    }

    InternalFullDateHistogramFacet() {
    }

    InternalFullDateHistogramFacet(String name) {
        super(name);
    }

    public InternalFullDateHistogramFacet(String name, DateHistogramFacet.ComparatorType comparatorType, List<FullEntry> entries) {
        super(name);
        this.comparatorType = comparatorType;
        this.entries = entries;
    }

    public List<FullEntry> getEntries() {
        return this.entries;
    }

    @Override
    public Iterator<DateHistogramFacet.Entry> iterator() {
        return this.getEntries().iterator();
    }

    @Override
    public Facet reduce(InternalFacet.ReduceContext context) {
        FullEntry value;
        List<Facet> facets = context.facets();
        if (facets.size() == 1) {
            InternalFullDateHistogramFacet internalFacet = (InternalFullDateHistogramFacet)facets.get(0);
            List<FullEntry> entries = internalFacet.getEntries();
            CollectionUtil.timSort(entries, this.comparatorType.comparator());
            return internalFacet;
        }
        Recycler.V map = context.cacheRecycler().longObjectMap(-1);
        for (Facet facet : facets) {
            InternalFullDateHistogramFacet histoFacet = (InternalFullDateHistogramFacet)facet;
            for (FullEntry fullEntry : histoFacet.entries) {
                FullEntry current = (FullEntry)map.v().get(fullEntry.time);
                if (current != null) {
                    current.count += fullEntry.count;
                    current.total += fullEntry.total;
                    current.totalCount += fullEntry.totalCount;
                    if (fullEntry.min < current.min) {
                        current.min = fullEntry.min;
                    }
                    if (!(fullEntry.max > current.max)) continue;
                    current.max = fullEntry.max;
                    continue;
                }
                map.v().put(fullEntry.time, fullEntry);
            }
        }
        Object[] values = map.v().values().toArray();
        Arrays.sort(values, this.comparatorType.comparator());
        ArrayList<FullEntry> ordered = new ArrayList<FullEntry>(map.v().size());
        for (int i = 0; i < map.v().size() && (value = (FullEntry)values[i]) != null; ++i) {
            ordered.add(value);
        }
        map.close();
        InternalFullDateHistogramFacet ret = new InternalFullDateHistogramFacet(this.getName());
        ret.comparatorType = this.comparatorType;
        ret.entries = ordered;
        return ret;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.field(Fields._TYPE, "date_histogram");
        builder.startArray(Fields.ENTRIES);
        for (DateHistogramFacet.Entry entry : this.getEntries()) {
            builder.startObject();
            builder.field(Fields.TIME, entry.getTime());
            builder.field(Fields.COUNT, entry.getCount());
            builder.field(Fields.MIN, entry.getMin());
            builder.field(Fields.MAX, entry.getMax());
            builder.field(Fields.TOTAL, entry.getTotal());
            builder.field(Fields.TOTAL_COUNT, entry.getTotalCount());
            builder.field(Fields.MEAN, entry.getMean());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static InternalFullDateHistogramFacet readHistogramFacet(StreamInput in) throws IOException {
        InternalFullDateHistogramFacet facet = new InternalFullDateHistogramFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.comparatorType = DateHistogramFacet.ComparatorType.fromId(in.readByte());
        int size = in.readVInt();
        this.entries = new ArrayList<FullEntry>(size);
        for (int i = 0; i < size; ++i) {
            this.entries.add(new FullEntry(in.readLong(), in.readVLong(), in.readDouble(), in.readDouble(), in.readVLong(), in.readDouble()));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.comparatorType.id());
        out.writeVInt(this.entries.size());
        for (FullEntry entry : this.entries) {
            out.writeLong(entry.time);
            out.writeVLong(entry.count);
            out.writeDouble(entry.min);
            out.writeDouble(entry.max);
            out.writeVLong(entry.totalCount);
            out.writeDouble(entry.total);
        }
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString ENTRIES = new XContentBuilderString("entries");
        static final XContentBuilderString TIME = new XContentBuilderString("time");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString TOTAL_COUNT = new XContentBuilderString("total_count");
        static final XContentBuilderString MEAN = new XContentBuilderString("mean");
        static final XContentBuilderString MIN = new XContentBuilderString("min");
        static final XContentBuilderString MAX = new XContentBuilderString("max");

        Fields() {
        }
    }

    public static class FullEntry
    implements DateHistogramFacet.Entry {
        private final long time;
        long count;
        long totalCount;
        double total;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;

        public FullEntry(long time, long count, double min, double max, long totalCount, double total) {
            this.time = time;
            this.count = count;
            this.min = min;
            this.max = max;
            this.totalCount = totalCount;
            this.total = total;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public double getTotal() {
            return this.total;
        }

        @Override
        public long getTotalCount() {
            return this.totalCount;
        }

        @Override
        public double getMean() {
            if (this.totalCount == 0L) {
                return this.totalCount;
            }
            return this.total / (double)this.totalCount;
        }

        @Override
        public double getMin() {
            return this.min;
        }

        @Override
        public double getMax() {
            return this.max;
        }
    }
}

