/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.lookup.DocLookup;
import org.elasticsearch.search.lookup.FieldsLookup;
import org.elasticsearch.search.lookup.IndexLookup;
import org.elasticsearch.search.lookup.SourceLookup;

public class SearchLookup {
    final DocLookup docMap;
    final SourceLookup sourceLookup;
    final FieldsLookup fieldsLookup;
    final IndexLookup indexLookup;
    final ImmutableMap<String, Object> asMap;

    public SearchLookup(MapperService mapperService, IndexFieldDataService fieldDataService, @Nullable String[] types) {
        ImmutableMap.Builder<String, Object> builder = ImmutableMap.builder();
        this.docMap = new DocLookup(mapperService, fieldDataService, types);
        this.sourceLookup = new SourceLookup();
        this.fieldsLookup = new FieldsLookup(mapperService, types);
        this.indexLookup = new IndexLookup(builder);
        builder.put("doc", this.docMap);
        builder.put("_doc", this.docMap);
        builder.put("_source", this.sourceLookup);
        builder.put("_fields", this.fieldsLookup);
        builder.put("_index", this.indexLookup);
        this.asMap = builder.build();
    }

    public ImmutableMap<String, Object> asMap() {
        return this.asMap;
    }

    public SourceLookup source() {
        return this.sourceLookup;
    }

    public IndexLookup indexLookup() {
        return this.indexLookup;
    }

    public FieldsLookup fields() {
        return this.fieldsLookup;
    }

    public DocLookup doc() {
        return this.docMap;
    }

    public void setNextReader(AtomicReaderContext context) {
        this.docMap.setNextReader(context);
        this.sourceLookup.setNextReader(context);
        this.fieldsLookup.setNextReader(context);
        this.indexLookup.setNextReader(context);
    }

    public void setNextDocId(int docId) {
        this.docMap.setNextDocId(docId);
        this.sourceLookup.setNextDocId(docId);
        this.fieldsLookup.setNextDocId(docId);
        this.indexLookup.setNextDocId(docId);
    }
}

