/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.xunit;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.domain.BaseTestTool;
import com.xebialabs.xltest.domain.ImportException;
import com.xebialabs.xltest.domain.Importable;
import com.xebialabs.xltest.utils.OverthereFileComparator;
import com.xebialabs.xltest.utils.glob.FileMatcher;
import com.xebialabs.xltest.xunit.XUnitImporter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XUnitTestTool
extends BaseTestTool {
    private static final Logger LOG = LoggerFactory.getLogger(XUnitTestTool.class);
    public static final String TOOL_NAME = "xUnit";

    public String getName() {
        return TOOL_NAME;
    }

    public String getCategory() {
        return "functional";
    }

    public SortedSet<OverthereFile> findTestResultPaths(OverthereFile searchRoot, FileMatcher fileMatcher) {
        SortedSet testResultFiles = super.findTestResultPaths(searchRoot, fileMatcher);
        TreeSet<OverthereFile> testResultDirectories = new TreeSet<OverthereFile>((Comparator<OverthereFile>)new OverthereFileComparator());
        for (OverthereFile resultFile : testResultFiles) {
            testResultDirectories.add(resultFile.getParentFile());
        }
        return testResultDirectories;
    }

    public List<Importable> findImportables(OverthereFile searchPath, FileMatcher fileMatcher) throws ImportException {
        return Arrays.asList(this.findLatestImportable(searchPath, fileMatcher));
    }

    public Importable findLatestImportable(OverthereFile searchPath, FileMatcher fileMatcher) throws ImportException {
        LOG.debug("findLatestImportable({},{})", (Object)searchPath.getPath(), (Object)fileMatcher);
        SortedSet testResultFiles = this.globFiles(searchPath, fileMatcher);
        return new XUnitImporter(searchPath, fileMatcher.toString(), testResultFiles);
    }

    public String getDefaultSearchPattern() {
        return "**/TEST-*.xml";
    }
}

