/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.util.ExceptionHandler;
import de.schlichtherle.truezip.util.ThreadGroups;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class FsResourceAccountant {
    private static final Logger logger = Logger.getLogger(FsResourceAccountant.class.getName(), FsResourceAccountant.class.getName());
    private final Lock lock;
    private final Condition condition;
    @Nullable
    private volatile Map<Closeable, Account> threads = new WeakHashMap<Closeable, Account>();

    FsResourceAccountant(Lock lock) {
        this.condition = lock.newCondition();
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startAccountingFor(Closeable resource) {
        this.lock.lock();
        try {
            if (!this.threads.containsKey(resource)) {
                this.threads.put(resource, new Account(resource));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopAccountingFor(Closeable resource) {
        this.lock.lock();
        try {
            Account ref = this.threads.remove(resource);
            if (null != ref) {
                assert (!ref.isEnqueued());
                this.condition.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int waitOtherThreads(long timeout) {
        this.lock.lock();
        try {
            int size;
            long start = System.currentTimeMillis();
            while ((size = this.threads.size()) > this.threadLocalResources()) {
                if (timeout > 0L) {
                    long toWait = timeout - (System.currentTimeMillis() - start);
                    if (toWait <= 0L) break;
                    if (this.condition.await(toWait, TimeUnit.MILLISECONDS)) continue;
                    int n = this.threads.size();
                    return n;
                }
                this.condition.await();
            }
            int n = size;
            return n;
        }
        catch (InterruptedException ex) {
            logger.log(Level.WARNING, "interrupted", ex);
            int n = this.threads.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    private int threadLocalResources() {
        int n = 0;
        Thread currentThread = Thread.currentThread();
        for (Account ref : this.threads.values()) {
            if (ref.owner.get() != currentThread) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <X extends Exception> void closeAllResources(ExceptionHandler<? super IOException, X> handler) throws X {
        this.lock.lock();
        try {
            Iterator<Closeable> i = this.threads.keySet().iterator();
            while (i.hasNext()) {
                try {
                    Closeable closeable = i.next();
                    i.remove();
                    closeable.close();
                }
                catch (IOException ex) {
                    handler.warn(ex);
                }
            }
            assert (this.threads.isEmpty());
        }
        finally {
            this.lock.unlock();
        }
    }

    public static final class Collector
    extends Thread {
        static final ReferenceQueue<Closeable> queue = new ReferenceQueue();

        Collector() {
            super(ThreadGroups.getTopLevel(), Collector.class.getName());
            this.setPriority(8);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        ((Account)queue.remove()).notifyAccountant();
                    }
                }
                catch (InterruptedException ex) {
                    logger.log(Level.FINE, "interrupted", ex);
                    continue;
                }
                break;
            }
        }

        static {
            new Collector().start();
        }
    }

    private final class Account
    extends WeakReference<Closeable> {
        final Reference<Thread> owner;

        Account(Closeable resource) {
            super(resource, Collector.queue);
            this.owner = new WeakReference<Thread>(Thread.currentThread());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void notifyAccountant() {
            Lock lock = FsResourceAccountant.this.lock;
            lock.lock();
            try {
                FsResourceAccountant.this.condition.signalAll();
            }
            finally {
                lock.unlock();
            }
        }
    }
}

