/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest;

import com.xebialabs.deployit.ReleaseInfo;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.core.rest.api.MetadataServiceImpl;
import com.xebialabs.deployit.engine.api.MetadataService;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.repository.JcrRepositoryService;
import com.xebialabs.deployit.repository.RepositoryAdapter;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.deployit.upgrade.Upgrader;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.license.service.LicenseServiceImpl;
import com.xebialabs.xlplatform.jcr.ModeShapeRepositoryFactoryBean;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xltest.SpringContextHolder;
import com.xebialabs.xltest.elasticsearch.ElasticSearchClientFactoryBean;
import com.xebialabs.xltest.repository.ValidatingRepository;
import com.xebialabs.xltest.service.EventRepository;
import com.xebialabs.xltest.service.EventRepositoryImpl;
import com.xebialabs.xltest.service.licenseinstallservice.LicenseInstallService;
import com.xebialabs.xltest.service.licenseinstallservice.LicenseInstallServiceImpl;
import com.xebialabs.xltest.upgrade.XlTestViewUpgrader;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.crypto.SecretKey;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import org.elasticsearch.client.Client;
import org.springframework.context.annotation.Bean;

public abstract class AbstractContextConfig {
    @Bean(name={"xlt.license.server.url"})
    public String licenseServerUrl() {
        return System.getProperty("xlt.license.server.url", "https://download.xebialabs.com/api/license");
    }

    @Bean(name={"xlt.license.file"})
    public String licenseFile() {
        return System.getProperty("xlt.license.file", "conf/xl-testview-license.lic");
    }

    @Bean(name={"xlt.elasticsearch.data"})
    public String elasticSearchBaseDir() {
        return System.getProperty("xlt.elasticsearch.data", "data");
    }

    @Bean(name={"xlt.elasticsearch.http"})
    public boolean elasticSearchHttpServer() {
        return System.getProperty("xlt.elasticsearch.http", "false").equalsIgnoreCase("true");
    }

    @Bean(name={"xlt.elasticsearch.port.range"})
    public String elasticSearchPort() {
        return System.getProperty("xlt.elasticsearch.port.range", "9200-9299");
    }

    @Bean
    public MetadataService metadataService() {
        return new MetadataServiceImpl();
    }

    @Bean
    public Repository repository(RepositoryService repositoryService, Validator validator) {
        return new RepositoryAdapter(repositoryService, validator, null);
    }

    @Bean
    public RepositoryServiceHolder repositoryServiceHolder(RepositoryService repositoryService) {
        return new RepositoryServiceHolder(repositoryService);
    }

    @Bean
    public LicenseService licenseService() throws IOException {
        return new LicenseServiceImpl(this.licenseFile(), "XL TestView", "3");
    }

    @Bean
    public LicenseInstallService licenseInstallService(LicenseService licenseService) {
        return new LicenseInstallServiceImpl(this.licenseFile(), licenseService, this.licenseServerUrl());
    }

    @Bean
    public ServerConfiguration serverConfiguration() {
        ServerConfiguration serverCfg = new ServerConfiguration();
        serverCfg.setDefaults();
        return serverCfg;
    }

    @Bean
    public RepositoryService repositoryService(JcrTemplate jcrTemplate, Validator validator) throws IOException, RepositoryException {
        SecretKey secretKey = DeployitKeys.getPasswordEncryptionKey((String)"keyStorePassword");
        PasswordEncrypter.init((SecretKey)secretKey);
        PasswordEncrypter passwordEncrypter = PasswordEncrypter.getInstance();
        JcrRepositoryService jcrRepositoryService = new JcrRepositoryService(jcrTemplate, passwordEncrypter, this.licenseService());
        jcrRepositoryService.initializeLicenseValidator();
        return new ValidatingRepository((RepositoryService)jcrRepositoryService, validator);
    }

    @Bean
    public JcrTemplate jcrTemplate(javax.jcr.Repository jcrRepository) {
        return new JcrTemplate(jcrRepository, (Credentials)this.repositoryConfig().credentials().get());
    }

    @Bean
    public ModeShapeRepositoryFactoryBean getModeShapeFactory() {
        ModeShapeRepositoryFactoryBean factory = new ModeShapeRepositoryFactoryBean(this.repositoryConfig());
        return factory;
    }

    @Bean
    public EventRepository eventRepository(Client client) throws NoSuchMethodException {
        return new EventRepositoryImpl(client);
    }

    @Bean
    public ExecutorService executorService() {
        return Executors.newCachedThreadPool();
    }

    @Bean
    public SpringContextHolder springContextHolder() {
        return new SpringContextHolder();
    }

    @Bean
    public Upgrader upgrader(JcrTemplate jcrTemplate, RepositoryVersionService repositoryVersionService) {
        return new XlTestViewUpgrader(jcrTemplate, true, repositoryVersionService);
    }

    @Bean
    public abstract XlRepositoryConfig repositoryConfig();

    @Bean
    public abstract ReleaseInfo releaseInfo();

    @Bean
    public abstract ElasticSearchClientFactoryBean getElasticSearchFactory() throws Exception;

    @Bean(name={"xlt.load.demo.data"})
    public abstract boolean loadDemoData();
}

