/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.internal;

import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.serialize.ListOfEventsWriter;
import com.xebialabs.xltest.service.EventRepository;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONException;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/api/internal/events")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@NoCache
public class EventController {
    private static final Logger LOG = LoggerFactory.getLogger(EventController.class);
    private final EventRepository eventRepository;
    private final ListOfEventsWriter serializer = new ListOfEventsWriter();

    @Autowired
    public EventController(EventRepository eventRepository) {
        this.eventRepository = eventRepository;
    }

    @GET
    @Path(value="/{eventId:.+}")
    public Response findEvent(@PathParam(value="eventId") String eventId) throws JSONException {
        Event event = this.eventRepository.findById(eventId);
        String serializedEvent = this.serializer.toJson(event);
        return Response.status((int)200).entity((Object)serializedEvent).build();
    }

    @POST
    @Path(value="/{eventId:.+}/tags/")
    public Response updatedTags(@PathParam(value="eventId") String eventId, Map<String, Object> tags) {
        LOG.debug("Updating event {} with tags {}.", (Object)eventId, tags);
        Event event = this.eventRepository.findById(eventId);
        event.updateWithProperties(tags);
        this.eventRepository.update(event, true);
        return Response.status((int)204).build();
    }
}

