/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.ExecutionResult;
import com.xebialabs.xltest.domain.NoTestRunFoundException;
import com.xebialabs.xltest.domain.TestRun;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRunImpl
implements TestRun {
    private static final Logger LOG = LoggerFactory.getLogger(TestRunImpl.class);
    private static final Set<String> standardProps = new HashSet<String>(Arrays.asList("timestamp", "testSpecification", "runId", "type"));
    private final List<Event> events;
    private final UUID testRunId;
    private String testSpecificationName;
    private Date startTime;
    private Date finishedTime;
    private boolean qualificationResult;
    private String failureReason;
    private Map<String, Object> parameters;
    private int duration;

    public TestRunImpl(List<Event> events) {
        this.events = events;
        this.parameters = new HashMap<String, Object>();
        this.testRunId = this.findTestRunId();
        this.createTestRun(this.findEvent("executionStarted"), this.findEvent("importStarted"), this.findEvent("importFinished"), this.findEvent("executionFinished"), this.findEvent("qualificationComputed"));
    }

    public TestRunImpl(UUID uuid) {
        this.events = Collections.emptyList();
        this.testRunId = uuid;
    }

    private UUID findTestRunId() {
        return this.events.isEmpty() ? null : this.events.get(0).getTestRunId();
    }

    private Event findEvent(String eventType) {
        for (Event ev : this.events) {
            if (!eventType.equals(ev.getType())) continue;
            return ev;
        }
        return null;
    }

    private void createTestRun(Event executionStartedEvent, Event importStartedEvent, Event importFinishedEvent, Event executionFinishedEvent, Event qualificationEvent) {
        if (executionStartedEvent != null) {
            LOG.debug("Creating testRun with runId {} from startEvent {}", (Object)this.testRunId, (Object)executionStartedEvent);
            this.setTestSpecificationName((String)executionStartedEvent.getRequired("testSpecification"));
            this.setStartTime(new Date(((Number)executionStartedEvent.getRequired("timestamp")).longValue()));
            this.updateParameters(executionStartedEvent);
        } else if (importStartedEvent != null) {
            LOG.debug("Creating testRun with runId {} from importStartedEvent {}", (Object)this.testRunId, (Object)importStartedEvent);
            this.setTestSpecificationName((String)importStartedEvent.getRequired("testSpecification"));
            this.setStartTime(new Date(((Number)importStartedEvent.getRequired("lastModified")).longValue()));
            this.updateParameters(importStartedEvent);
        } else {
            throw new NoTestRunFoundException("Can't populate TestRun from these executionStarted or importStarted events. Both could not be found");
        }
        if (importFinishedEvent != null && importFinishedEvent.hasProperty("timestamp")) {
            this.setFinishedTime(importFinishedEvent.getTimestampAsDate());
            this.duration = importFinishedEvent.getDuration();
            this.updateParameters(importFinishedEvent);
        } else if (executionFinishedEvent != null && executionFinishedEvent.hasProperty("timestamp")) {
            this.setFinishedTime(executionFinishedEvent.getTimestampAsDate());
            this.updateParameters(executionFinishedEvent);
        }
        if (qualificationEvent != null) {
            this.setQualificationResult((Boolean)qualificationEvent.get("qualification"));
            String failureReason = "";
            if (qualificationEvent.hasProperty("failureReason")) {
                failureReason = (String)qualificationEvent.get("failureReason");
            }
            this.setFailureReason(failureReason);
        }
    }

    private void updateParameters(Event event) {
        if (event != null) {
            for (String key : event.getProperties().keySet()) {
                if (standardProps.contains(key)) continue;
                this.parameters.put(key, event.get(key));
            }
        }
    }

    public UUID getTestRunId() {
        return this.testRunId;
    }

    public String getId() {
        return this.testRunId.toString();
    }

    public String getTestSpecificationName() {
        return this.testSpecificationName;
    }

    public void setTestSpecificationName(String testSpecificationName) {
        this.testSpecificationName = testSpecificationName;
    }

    public Date getStartTime() {
        return this.startTime != null ? new Date(this.startTime.getTime()) : null;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getFinishedTime() {
        return this.finishedTime != null ? new Date(this.finishedTime.getTime()) : null;
    }

    public void setFinishedTime(Date finishedTime) {
        this.finishedTime = finishedTime;
    }

    public boolean isFinished() {
        return this.finishedTime != null;
    }

    public boolean getQualificationResult() {
        return this.qualificationResult;
    }

    public void setQualificationResult(boolean qualificationResult) {
        this.qualificationResult = qualificationResult;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public int getDuration() {
        if (this.duration < 0) {
            return (int)(this.finishedTime.getTime() - this.startTime.getTime());
        }
        return this.duration;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public boolean hasParameter(String parameterName) {
        return this.getParameters() != null && this.getParameters().containsKey(parameterName);
    }

    public Object getParameter(String parameterName) {
        return this.getParameters().get(parameterName);
    }

    public List<Event> getEvents(Map<String, Object> queryParameters) {
        final Set<Map.Entry<String, Object>> queryEntries = queryParameters.entrySet();
        return new ArrayList<Event>(Collections2.filter(this.events, (Predicate)new Predicate<Event>(){

            public boolean apply(Event input) {
                for (Map.Entry entry : queryEntries) {
                    if (entry.getValue().equals(input.get((String)entry.getKey()))) continue;
                    return false;
                }
                return true;
            }
        }));
    }

    public List<Event> getEvents() {
        return this.events;
    }

    private Event getFinishedEvent() {
        return this.findEvent("executionFinished");
    }

    public Event getStartedEvent() {
        return this.findEvent("executionStarted");
    }

    public long timeElapsed() {
        return new Date().getTime() - this.getStartTime().getTime();
    }

    public ExecutionResult getExecutionResult() {
        Event startedEvent = this.getStartedEvent();
        Event finishedEvent = this.getFinishedEvent();
        if (startedEvent != null && finishedEvent == null) {
            return ExecutionResult.running((long)this.timeElapsed());
        }
        if (startedEvent != null && finishedEvent != null) {
            return this.qualificationResult ? ExecutionResult.finished() : ExecutionResult.failed((String)this.failureReason);
        }
        return ExecutionResult.notRunning();
    }
}

