/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.elasticsearch;

import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class ElasticSearchClientFactoryBean
implements InitializingBean,
DisposableBean,
FactoryBean<Client> {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchClientFactoryBean.class);
    private String clusterName = "elasticsearch_xltest";
    private String nodeName = "XL TestView";
    private int numberOfShards = 1;
    private final int numberOfReplicas = 0;
    private String host = "127.0.0.1";
    private String portRange = "9200-9300";
    private String pathData = ".";
    private boolean httpEnabled = false;
    private boolean inMemory = false;
    private Client client;
    private Node node;

    public void destroy() throws Exception {
        if (this.node != null && !this.node.isClosed()) {
            LOG.info("Closing ElasticSearch node");
            this.node.close();
        }
    }

    public void afterPropertiesSet() throws Exception {
        LOG.info("Starting up ElasticSearch");
        ImmutableSettings.Builder nodeSettings = NodeBuilder.nodeBuilder().settings();
        nodeSettings.put("network.host", this.host);
        nodeSettings.put("http.port", this.portRange);
        nodeSettings.put("cluster.name", this.clusterName);
        nodeSettings.put("cluster.routing.allocation.disk.threshold_enabled", false);
        nodeSettings.put("index.number_of_shards", this.numberOfShards);
        nodeSettings.put("index.number_of_replicas", 0);
        if (this.inMemory) {
            LOG.warn("Running ElasticSearch in memory DO NOT USE IN PRODUCTION");
            nodeSettings.put("index.store.type", "memory");
        }
        nodeSettings.put("node.local", true);
        nodeSettings.put("discovery.zen.ping.multicast.enabled", false);
        nodeSettings.put("node.name", this.nodeName);
        nodeSettings.put("path.data", this.pathData);
        nodeSettings.put("http.enabled", this.httpEnabled);
        this.node = NodeBuilder.nodeBuilder().settings(nodeSettings.build()).node();
        this.client = this.node.client();
        LOG.info("Started up ElasticSearch");
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setNumberOfShards(int numberOfShards) {
        this.numberOfShards = numberOfShards;
    }

    public void setPathData(String pathData) {
        this.pathData = pathData;
    }

    public void setHttpEnabled(boolean httpEnabled) {
        this.httpEnabled = httpEnabled;
    }

    public void setInMemory(boolean inMemory) {
        this.inMemory = inMemory;
    }

    public void setPortRange(String portRange) {
        this.portRange = portRange;
    }

    public Client getObject() throws Exception {
        return this.client;
    }

    public Class<?> getObjectType() {
        return Client.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

