/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.serialize;

import com.google.common.base.Strings;
import com.jayway.jsonpath.spi.JsonProviderFactory;
import com.xebialabs.xltest.serialize.BasicMessageBodyReader;
import com.xebialabs.xltest.view.ExecutionParameters;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.codehaus.jettison.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Provider
@Consumes(value={"application/json"})
public class ExecutionParametersReader
extends BasicMessageBodyReader<ExecutionParameters> {
    Logger LOG = LoggerFactory.getLogger(ExecutionParametersReader.class);

    @Override
    public boolean isReadable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return ExecutionParameters.class.isAssignableFrom(aClass);
    }

    @Override
    public ExecutionParameters readJson(String json) throws JSONException {
        if (Strings.isNullOrEmpty((String)json)) {
            return new ExecutionParameters(null, null, null);
        }
        Map object = (Map)JsonProviderFactory.createProvider().parse(json);
        String commandLine = (String)object.get("commandLine");
        String hostId = (String)object.get("hostId");
        Map parameters = (Map)object.get("parameters");
        return new ExecutionParameters(commandLine, hostId, parameters);
    }
}

